/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonBorderModel;
import com.android.tools.adtui.model.stdui.DefaultCommonBorderModel;
import com.android.tools.adtui.stdui.GraphicsUtilKt;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.adtui.stdui.StandardDimensions;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001 B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J8\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/adtui/stdui/CommonBorder;", "Ljavax/swing/border/Border;", "cornerRadius", "", "model", "Lcom/android/tools/adtui/model/stdui/CommonBorderModel;", "padding", "Ljava/awt/Insets;", "(FLcom/android/tools/adtui/model/stdui/CommonBorderModel;Ljava/awt/Insets;)V", "drawRoundedRect", "", "g2", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/geom/Rectangle2D$Float;", "borderColor", "Ljava/awt/Color;", "stroke", "backgroundColor", "getBorderInsets", "component", "Ljava/awt/Component;", "isBorderOpaque", "", "paintBorder", "g", "Ljava/awt/Graphics;", "x", "", "y", "width", "height", "PathBuilder", "intellij.android.adt.ui"})
public final class CommonBorder
implements Border {
    private final float cornerRadius;
    private final CommonBorderModel model;
    private final Insets padding;

    @Override
    @NotNull
    public Insets getBorderInsets(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object = this.padding.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Insets");
        }
        Insets insets = (Insets)object;
        int inset = Math.round(StandardDimensions.INSTANCE.getINNER_BORDER_WIDTH() + StandardDimensions.INSTANCE.getOUTER_BORDER_WIDTH());
        insets.left += inset;
        insets.right += inset;
        insets.top += inset;
        insets.bottom += inset;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paintBorder(@NotNull Component component, @NotNull Graphics g, int x, int y, int width, int height) {
        void outerColor;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D g2 = (Graphics2D)g;
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, component.getWidth(), component.getHeight());
        Pair pair = !component.isEnabled() ? new Pair((Object)UIUtil.TRANSPARENT_COLOR, (Object)StandardColors.DISABLED_INNER_BORDER_COLOR) : (this.model.getHasError() ? new Pair((Object)StandardColors.ERROR_OUTER_BORDER_COLOR, (Object)StandardColors.ERROR_INNER_BORDER_COLOR) : (IJSwingUtilities.hasFocus((Component)component) ? new Pair((Object)StandardColors.FOCUSED_OUTER_BORDER_COLOR, (Object)StandardColors.FOCUSED_INNER_BORDER_COLOR) : (this.model.getHasPlaceHolder() ? new Pair((Object)UIUtil.TRANSPARENT_COLOR, (Object)StandardColors.PLACEHOLDER_INNER_BORDER_COLOR) : new Pair((Object)UIUtil.TRANSPARENT_COLOR, (Object)StandardColors.INNER_BORDER_COLOR))));
        Color color = (Color)pair.component1();
        Color innerColor = (Color)pair.component2();
        float adjustedInnerWidth = StandardDimensions.INSTANCE.getINNER_BORDER_WIDTH();
        void var12_13 = outerColor;
        if (Intrinsics.areEqual((Object)var12_13, (Object)UIUtil.TRANSPARENT_COLOR)) {
            GraphicsUtilKt.applyInset(rect, StandardDimensions.INSTANCE.getOUTER_BORDER_WIDTH());
        } else if (Intrinsics.areEqual((Object)var12_13, (Object)innerColor)) {
            adjustedInnerWidth += StandardDimensions.INSTANCE.getOUTER_BORDER_WIDTH();
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            void v0 = outerColor;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"outerColor");
            CommonBorder.drawRoundedRect$default(this, g2, rect, (Color)v0, StandardDimensions.INSTANCE.getOUTER_BORDER_WIDTH(), this.cornerRadius + StandardDimensions.INSTANCE.getINNER_BORDER_WIDTH(), null, 32, null);
            GraphicsUtilKt.applyInset(rect, StandardDimensions.INSTANCE.getOUTER_BORDER_WIDTH());
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color2 = innerColor;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"innerColor");
        Color color3 = component.getBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"component.background");
        this.drawRoundedRect(g2, rect, color2, adjustedInnerWidth, this.cornerRadius, color3);
    }

    private final void drawRoundedRect(Graphics2D g2, Rectangle2D.Float rect, Color borderColor, float stroke, float cornerRadius, Color backgroundColor) {
        PathBuilder builder = new PathBuilder(JreHiDpiUtil.isJreHiDPI((Graphics2D)g2), rect, stroke, cornerRadius, this.padding);
        if (Intrinsics.areEqual((Object)backgroundColor, (Object)UIUtil.TRANSPARENT_COLOR) ^ true) {
            g2.setColor(backgroundColor);
            g2.fill(builder.makeLeftMargin());
            g2.fill(builder.makeRightMargin());
            if (this.padding.top > 0) {
                g2.fill(builder.makeTopMargin());
            }
            if (this.padding.bottom > 0) {
                g2.fill(builder.makeBottomMargin());
            }
        }
        g2.setColor(borderColor);
        g2.setStroke(new BasicStroke(stroke));
        g2.draw(builder.makeRoundedRect());
    }

    static /* synthetic */ void drawRoundedRect$default(CommonBorder commonBorder, Graphics2D graphics2D, Rectangle2D.Float float_, Color color, float f, float f2, Color color2, int n, Object object) {
        if ((n & 0x20) != 0) {
            Color color3 = UIUtil.TRANSPARENT_COLOR;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"UIUtil.TRANSPARENT_COLOR");
            color2 = color3;
        }
        commonBorder.drawRoundedRect(graphics2D, float_, color, f, f2, color2);
    }

    public CommonBorder(float cornerRadius, @NotNull CommonBorderModel model2, @NotNull Insets padding) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        this.cornerRadius = cornerRadius;
        this.model = model2;
        this.padding = padding;
    }

    public /* synthetic */ CommonBorder(float f, CommonBorderModel commonBorderModel, Insets insets, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            commonBorderModel = new DefaultCommonBorderModel();
        }
        if ((n & 4) != 0) {
            insets = new Insets(StandardDimensions.INSTANCE.getVERTICAL_PADDING(), StandardDimensions.INSTANCE.getHORIZONTAL_PADDING(), StandardDimensions.INSTANCE.getVERTICAL_PADDING(), StandardDimensions.INSTANCE.getHORIZONTAL_PADDING());
        }
        this(f, commonBorderModel, insets);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020\u001dJ\u0006\u0010 \u001a\u00020\u001dJ\u0006\u0010!\u001a\u00020\u001dR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/adtui/stdui/CommonBorder$PathBuilder;", "", "hiDpi", "", "rect", "Ljava/awt/geom/Rectangle2D$Float;", "stroke", "", "cornerRadius", "padding", "Ljava/awt/Insets;", "(ZLjava/awt/geom/Rectangle2D$Float;FFLjava/awt/Insets;)V", "bottom", "corner", "curve1", "curve2", "left", "marginBottom", "marginLeft", "marginRight", "marginTop", "right", "top", "addLeftSideCurve", "", "path", "Ljava/awt/geom/Path2D$Float;", "addRightSideCurve", "makeBottomMargin", "Ljava/awt/Shape;", "makeLeftMargin", "makeRightMargin", "makeRoundedRect", "makeTopMargin", "intellij.android.adt.ui"})
    private static final class PathBuilder {
        private final float left;
        private final float top;
        private float right;
        private float bottom;
        private final float corner;
        private final float curve1;
        private final float curve2;
        private final float marginLeft;
        private final float marginRight;
        private final float marginTop;
        private final float marginBottom;

        @NotNull
        public final Shape makeRoundedRect() {
            Path2D.Float path = new Path2D.Float();
            this.addLeftSideCurve(path);
            path.lineTo(this.right - this.corner, this.top);
            this.addRightSideCurve(path);
            path.lineTo(this.left + this.corner, this.bottom);
            return path;
        }

        @NotNull
        public final Shape makeLeftMargin() {
            Path2D.Float path = new Path2D.Float();
            this.addLeftSideCurve(path);
            path.lineTo(this.marginLeft, this.top);
            path.lineTo(this.marginLeft, this.bottom);
            path.lineTo(this.left + this.corner, this.bottom);
            return path;
        }

        @NotNull
        public final Shape makeRightMargin() {
            Path2D.Float path = new Path2D.Float();
            this.addRightSideCurve(path);
            path.lineTo(this.right - this.marginRight, this.bottom);
            path.lineTo(this.right - this.marginRight, this.top);
            path.lineTo(this.right - this.corner, this.top);
            return path;
        }

        @NotNull
        public final Shape makeTopMargin() {
            Path2D.Float path = new Path2D.Float();
            path.moveTo(this.left + this.corner, this.top);
            path.lineTo(this.right - this.corner, this.top);
            path.lineTo(this.right - this.corner, this.top + this.marginTop + 1.0f);
            path.lineTo(this.left + this.corner, this.top + this.marginTop + 1.0f);
            return path;
        }

        @NotNull
        public final Shape makeBottomMargin() {
            Path2D.Float path = new Path2D.Float();
            path.moveTo(this.left + this.corner, this.bottom);
            path.lineTo(this.right - this.corner, this.bottom);
            path.lineTo(this.right - this.corner, this.bottom - this.marginBottom - 1.0f);
            path.lineTo(this.left + this.corner, this.bottom - this.marginBottom - 1.0f);
            return path;
        }

        private final void addLeftSideCurve(Path2D.Float path) {
            path.moveTo(this.left + this.corner, this.bottom);
            path.curveTo(this.left + this.curve1, this.bottom - this.curve2, this.left + this.curve2, this.bottom - this.curve1, this.left, this.bottom - this.corner);
            path.lineTo(this.left, this.top + this.corner);
            path.curveTo(this.left + this.curve2, this.top + this.curve1, this.left + this.curve1, this.top + this.curve2, this.left + this.corner, this.top);
        }

        private final void addRightSideCurve(Path2D.Float path) {
            path.moveTo(this.right - this.corner, this.top);
            path.curveTo(this.right - this.curve1, this.top + this.curve2, this.right - this.curve2, this.top + this.curve1, this.right, this.top + this.corner);
            path.lineTo(this.right, this.bottom - this.corner);
            path.curveTo(this.right - this.curve2, this.bottom - this.curve1, this.right - this.curve1, this.bottom - this.curve2, this.right - this.corner, this.bottom);
        }

        public PathBuilder(boolean hiDpi, @NotNull Rectangle2D.Float rect, float stroke, float cornerRadius, @NotNull Insets padding) {
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            if (stroke > 1.0f || hiDpi) {
                GraphicsUtilKt.applyInset(rect, stroke / 2.0f);
            } else {
                rect.width -= 1.0f;
                rect.height -= 1.0f;
            }
            this.left = rect.x;
            this.top = rect.y;
            this.right = rect.x + rect.width;
            this.bottom = rect.y + rect.height;
            this.corner = cornerRadius + stroke / 2.0f;
            this.curve1 = cornerRadius / 2.0f;
            this.curve2 = cornerRadius - cornerRadius * (float)Math.sqrt(3.0) / 2.0f;
            if (stroke > 1.0f || hiDpi) {
                GraphicsUtilKt.applyInset(rect, -stroke / 2.0f);
            } else {
                rect.width += 1.0f;
                rect.height += 1.0f;
            }
            float inset = StandardDimensions.INSTANCE.getINNER_BORDER_WIDTH() + StandardDimensions.INSTANCE.getOUTER_BORDER_WIDTH();
            float f = inset + (float)padding.left;
            float f2 = this.corner + this.left;
            boolean bl = false;
            this.marginLeft = Math.max(f, f2);
            f = inset + (float)padding.right;
            f2 = this.corner;
            bl = false;
            this.marginRight = Math.max(f, f2);
            this.marginTop = padding.top;
            this.marginBottom = padding.bottom;
        }
    }
}

