/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.trackgroup;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.BoxSelectionModel;
import com.android.tools.adtui.model.DragAndDropListModel;
import com.android.tools.adtui.model.trackgroup.TrackGroupActionListener;
import com.android.tools.adtui.model.trackgroup.TrackModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackGroupModel
extends DragAndDropListModel<TrackModel> {
    private static final AtomicInteger TRACK_ID_GENERATOR = new AtomicInteger();
    private final String myTitle;
    @Nullable
    private final String myTitleHelpText;
    @Nullable
    private final String myTitleHelpLinkText;
    @Nullable
    private final String myTitleHelpLinkUrl;
    private final boolean myCollapsedInitially;
    private final boolean myHideHeader;
    private final boolean myTrackSelectable;
    @Nullable
    private final BoxSelectionModel myBoxSelectionModel;
    private final AspectObserver myObserver = new AspectObserver();
    private final List<TrackGroupActionListener> myActionListeners = new ArrayList<TrackGroupActionListener>();

    private TrackGroupModel(Builder builder) {
        this.myTitle = builder.myTitle;
        this.myTitleHelpText = builder.myTitleHelpText;
        this.myTitleHelpLinkText = builder.myTitleHelpLinkText;
        this.myTitleHelpLinkUrl = builder.myTitleHelpLinkUrl;
        this.myCollapsedInitially = builder.myCollapsedInitially;
        this.myHideHeader = builder.myHideHeader;
        this.myTrackSelectable = builder.myTrackSelectable;
        this.myBoxSelectionModel = builder.myBoxSelectionModel;
    }

    public <M, R extends Enum> void addTrackModel(@NotNull TrackModel.Builder<M, R> builder) {
        if (builder == null) {
            TrackGroupModel.$$$reportNull$$$0(0);
        }
        TrackModel trackModel = builder.setId(TRACK_ID_GENERATOR.getAndIncrement()).build();
        this.insertOrderedElement(trackModel);
        trackModel.getAspectModel().addDependency(this.myObserver).onChange(TrackModel.Aspect.COLLAPSE_CHANGE, () -> {
            int index = this.indexOf(trackModel);
            if (index != -1) {
                this.fireContentsChanged(this, index, index);
            }
        });
    }

    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitleHelpText() {
        return this.myTitleHelpText;
    }

    @Nullable
    public String getTitleHelpLinkText() {
        return this.myTitleHelpLinkText;
    }

    @Nullable
    public String getTitleHelpLinkUrl() {
        return this.myTitleHelpLinkUrl;
    }

    public boolean isCollapsedInitially() {
        return this.myCollapsedInitially;
    }

    public boolean getHideHeader() {
        return this.myHideHeader;
    }

    public boolean isTrackSelectable() {
        return this.myTrackSelectable;
    }

    @Nullable
    public BoxSelectionModel getBoxSelectionModel() {
        return this.myBoxSelectionModel;
    }

    public void addActionListener(@NotNull TrackGroupActionListener actionListener) {
        if (actionListener == null) {
            TrackGroupModel.$$$reportNull$$$0(1);
        }
        this.myActionListeners.add(actionListener);
    }

    @NotNull
    public List<TrackGroupActionListener> getActionListeners() {
        List<TrackGroupActionListener> list = this.myActionListeners;
        if (list == null) {
            TrackGroupModel.$$$reportNull$$$0(2);
        }
        return list;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/trackgroup/TrackGroupModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/trackgroup/TrackGroupModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTrackModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addActionListener";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String myTitle = "";
        @Nullable
        private String myTitleHelpText = null;
        @Nullable
        private String myTitleHelpLinkText = null;
        @Nullable
        private String myTitleHelpLinkUrl = null;
        private boolean myCollapsedInitially = false;
        private boolean myHideHeader = false;
        private boolean myTrackSelectable = false;
        @Nullable
        private BoxSelectionModel myBoxSelectionModel;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.myTitle = title;
            return this;
        }

        public Builder setTitleHelpText(@NotNull String titleHelpText) {
            if (titleHelpText == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myTitleHelpText = titleHelpText;
            return this;
        }

        public Builder setTitleHelpLink(@NotNull String titleHelpLinkText, @NotNull String titleHelpLinkUrl) {
            if (titleHelpLinkText == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (titleHelpLinkUrl == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myTitleHelpLinkText = titleHelpLinkText;
            this.myTitleHelpLinkUrl = titleHelpLinkUrl;
            return this;
        }

        public Builder setCollapsedInitially(boolean collapsedInitially) {
            this.myCollapsedInitially = collapsedInitially;
            return this;
        }

        public Builder setHideHeader(boolean hideHeader) {
            this.myHideHeader = hideHeader;
            return this;
        }

        public Builder setTrackSelectable(boolean trackSelectable) {
            this.myTrackSelectable = trackSelectable;
            return this;
        }

        public Builder setBoxSelectionModel(BoxSelectionModel rangeSelectionModel) {
            this.myBoxSelectionModel = rangeSelectionModel;
            return this;
        }

        public TrackGroupModel build() {
            return new TrackGroupModel(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleHelpText";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleHelpLinkText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleHelpLinkUrl";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/model/trackgroup/TrackGroupModel$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTitleHelpText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setTitleHelpLink";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

