/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class NumberFormatter {
    private static final Format INTEGER_FORMAT = NumberFormat.getIntegerInstance();
    private static final String[] FILE_SIZE_UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    private static final int FILE_SIZE_MULTIPLIER = 1024;
    private static final String[] FREQUENCY_UNITS = new String[]{"kHz", "MHz", "GHz"};
    private static final int FREQUENCY_MULTIPLIER = 1000;

    @NotNull
    public static String formatInteger(@NotNull Number number) {
        if (number == null) {
            NumberFormatter.$$$reportNull$$$0(0);
        }
        String string = INTEGER_FORMAT.format(number);
        if (string == null) {
            NumberFormatter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(long sizeInBytes) {
        String string = NumberFormatter.formatNumberWithUnit(sizeInBytes, 1024, FILE_SIZE_UNITS);
        if (string == null) {
            NumberFormatter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String formatFrequency(long frequencyInKhz) {
        String string = NumberFormatter.formatNumberWithUnit(frequencyInKhz, 1000, FREQUENCY_UNITS);
        if (string == null) {
            NumberFormatter.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String formatNumberWithUnit(long number, int multiplier, String[] units) {
        double result = number;
        String unit = units[0];
        for (int i = 1; i < units.length && !(result < (double)multiplier); result /= (double)multiplier, ++i) {
            unit = units[i];
        }
        String decimalFormat = result < 100.0 ? "%.1f" : "%.0f";
        return String.format(Locale.US, decimalFormat + " %s", result, unit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/formatter/NumberFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/formatter/NumberFormatter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatInteger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrequency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatInteger";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

