/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.event.NestedScrollPaneMouseWheelListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public final class AdtUiUtils {
    public static final JBFont DEFAULT_FONT = JBUI.Fonts.label((float)10.0f);
    public static final JBFont EMPTY_TOOL_WINDOW_FONT = JBUI.Fonts.label((float)16.0f);
    public static final Color DEFAULT_FONT_COLOR = JBColor.foreground();
    public static final Color DEFAULT_BORDER_COLOR = StudioColorsKt.getBorder();
    public static final Border DEFAULT_TOP_BORDER = BorderFactory.createMatteBorder(1, 0, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_LEFT_BORDER = BorderFactory.createMatteBorder(0, 1, 0, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_BOTTOM_BORDER = BorderFactory.createMatteBorder(0, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_RIGHT_BORDER = BorderFactory.createMatteBorder(0, 0, 0, 1, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_HORIZONTAL_BORDERS = BorderFactory.createMatteBorder(1, 0, 1, 0, DEFAULT_BORDER_COLOR);
    public static final Border DEFAULT_VERTICAL_BORDERS = BorderFactory.createMatteBorder(0, 1, 0, 1, DEFAULT_BORDER_COLOR);
    public static final GridBagConstraints GBC_FULL = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 256, 1, new Insets(0, 0, 0, 0), 0, 0);

    private AdtUiUtils() {
    }

    @NotNull
    public static String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace, float spaceThreshold) {
        if (text == null) {
            AdtUiUtils.$$$reportNull$$$0(0);
        }
        if (metrics == null) {
            AdtUiUtils.$$$reportNull$$$0(1);
        }
        return AdtUiUtils.shrinkToFit(text, s -> availableSpace > spaceThreshold && availableSpace >= (float)metrics.stringWidth((String)s));
    }

    @NotNull
    public static String shrinkToFit(@NotNull String text, @NotNull FontMetrics metrics, float availableSpace) {
        if (text == null) {
            AdtUiUtils.$$$reportNull$$$0(2);
        }
        if (metrics == null) {
            AdtUiUtils.$$$reportNull$$$0(3);
        }
        return AdtUiUtils.shrinkToFit(text, metrics, availableSpace, 0.0f);
    }

    @NotNull
    public static String shrinkToFit(@NotNull String text, @NotNull Predicate<String> textFitPredicate) {
        if (text == null) {
            AdtUiUtils.$$$reportNull$$$0(4);
        }
        if (textFitPredicate == null) {
            AdtUiUtils.$$$reportNull$$$0(5);
        }
        if (textFitPredicate.test(text)) {
            String string = text;
            if (string == null) {
                AdtUiUtils.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (!textFitPredicate.test("...")) {
            return "";
        }
        int smallestLength = 0;
        int largestLength = text.length();
        int bestLength = smallestLength;
        do {
            int midLength;
            if (textFitPredicate.test(text.substring(0, midLength = smallestLength + (largestLength - smallestLength) / 2) + "...")) {
                bestLength = midLength;
                smallestLength = midLength + 1;
                continue;
            }
            largestLength = midLength - 1;
        } while (smallestLength <= largestLength);
        return bestLength > 0 ? text.substring(0, bestLength) + "..." : "";
    }

    public static int unscale(int i) {
        return Math.round((float)i / JBUI.scale((float)1.0f));
    }

    public static Color overlayColor(int backgroundRgb, int foregroundRbg, float foregroundOpacity) {
        Color background = new Color(backgroundRgb);
        Color forground = new Color(foregroundRbg);
        return new Color(Math.round((float)background.getRed() * (1.0f - foregroundOpacity) + (float)forground.getRed() * foregroundOpacity), Math.round((float)background.getGreen() * (1.0f - foregroundOpacity) + (float)forground.getGreen() * foregroundOpacity), Math.round((float)background.getBlue() * (1.0f - foregroundOpacity) + (float)forground.getBlue() * foregroundOpacity));
    }

    public static boolean isActionKeyDown(@NotNull InputEvent event) {
        if (event == null) {
            AdtUiUtils.$$$reportNull$$$0(7);
        }
        return SystemInfo.isMac ? event.isMetaDown() : event.isControlDown();
    }

    @JdkConstants.InputEventMask
    public static int getActionMask() {
        return SystemInfo.isMac ? 256 : 128;
    }

    public static String getActionKeyText() {
        if (SystemInfo.isMac) {
            Font labelFont = UIUtil.getLabelFont();
            return labelFont != null && labelFont.canDisplayUpTo("\u2318") == -1 ? "\u2318" : "Cmd";
        }
        return "Ctrl";
    }

    public static JComponent createHorizontalSeparator() {
        JPanel separatorWrapper = new JPanel(new TabularLayout("*", "*,Fit,*"));
        separatorWrapper.add((Component)new JSeparator(), new TabularLayout.Constraint(1, 0));
        Dimension size = new Dimension(1, 2);
        separatorWrapper.setMinimumSize(size);
        separatorWrapper.setPreferredSize(size);
        separatorWrapper.setOpaque(false);
        return separatorWrapper;
    }

    @NotNull
    public static JBScrollPane createNestedVScrollPane(@NotNull JComponent component) {
        if (component == null) {
            AdtUiUtils.$$$reportNull$$$0(8);
        }
        JBScrollPane scrollPane = new JBScrollPane((Component)component);
        NestedScrollPaneMouseWheelListener.installOn((JScrollPane)scrollPane);
        JBScrollPane jBScrollPane = scrollPane;
        if (jBScrollPane == null) {
            AdtUiUtils.$$$reportNull$$$0(9);
        }
        return jBScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFitPredicate";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/common/AdtUiUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/common/AdtUiUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "shrinkToFit";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedVScrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shrinkToFit";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isActionKeyDown";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNestedVScrollPane";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

