/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.linechart.DefaultLineChartReducer;
import com.android.tools.adtui.chart.linechart.LineChartCustomRenderer;
import com.android.tools.adtui.chart.linechart.LineChartReducer;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.model.LineChartModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.SeriesData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class LineChart
extends AnimatedComponent {
    static final float EPSILON = 1.0E-4f;
    private static final double BUCKET_BAR_PERCENTAGE = 0.7;
    @NotNull
    final LineChartModel myModel;
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myLinesConfig;
    @NotNull
    private final ArrayList<Path2D> myLinePaths;
    @NotNull
    private final ArrayList<RangedContinuousSeries> myLinePathSeries;
    @NotNull
    private final List<LineChartCustomRenderer> myCustomRenderers;
    @NotNull
    private Color myMaxLineColor;
    private int myMaxLineMargin;
    private boolean myShowMaxLine;
    private int myXOffset;
    private int myYOffset;
    private int myTopPadding;
    private int mNextLineColorIndex;
    private boolean myRedraw;
    private boolean myFillEndGap;
    @NotNull
    private final LineChartReducer myReducer;
    private long myRedraws;
    private long myDraws;
    private long myLastCount;
    private long myLastDraws;
    private long myLastRedraws;
    private Map<LineConfig, DashInfo> myDashInfoCache;

    @VisibleForTesting
    public LineChart(@NotNull LineChartModel model2, @NotNull LineChartReducer reducer) {
        if (model2 == null) {
            LineChart.$$$reportNull$$$0(0);
        }
        if (reducer == null) {
            LineChart.$$$reportNull$$$0(1);
        }
        this.myLinesConfig = new LinkedHashMap<RangedContinuousSeries, LineConfig>();
        this.myCustomRenderers = new ArrayList<LineChartCustomRenderer>();
        this.myMaxLineColor = Color.BLACK;
        this.myXOffset = 0;
        this.myYOffset = 0;
        this.myTopPadding = 0;
        this.myDashInfoCache = new HashMap<LineConfig, DashInfo>();
        this.myLinePaths = new ArrayList();
        this.myLinePathSeries = new ArrayList();
        this.myReducer = reducer;
        this.myModel = model2;
        this.myRedraw = true;
        this.myModel.addDependency(this.myAspectObserver).onChange(LineChartModel.Aspect.LINE_CHART, this::modelChanged);
    }

    public LineChart(@NotNull LineChartModel model2) {
        if (model2 == null) {
            LineChart.$$$reportNull$$$0(2);
        }
        this(model2, new DefaultLineChartReducer());
    }

    public LineChart(@NotNull List<RangedContinuousSeries> data) {
        if (data == null) {
            LineChart.$$$reportNull$$$0(3);
        }
        this(new LineChartModel());
        this.myModel.addAll(data);
    }

    public void configure(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        if (series == null) {
            LineChart.$$$reportNull$$$0(4);
        }
        if (config == null) {
            LineChart.$$$reportNull$$$0(5);
        }
        this.myLinesConfig.put(series, config);
    }

    public void addCustomRenderer(@NotNull LineChartCustomRenderer renderer) {
        if (renderer == null) {
            LineChart.$$$reportNull$$$0(6);
        }
        this.myCustomRenderers.add(renderer);
    }

    @NotNull
    public LineConfig getLineConfig(RangedContinuousSeries rangedContinuousSeries) {
        LineConfig config = this.myLinesConfig.get(rangedContinuousSeries);
        if (config == null) {
            config = new LineConfig(LineConfig.getColor(this.mNextLineColorIndex++));
            this.configure(rangedContinuousSeries, config);
        }
        LineConfig lineConfig = config;
        if (lineConfig == null) {
            LineChart.$$$reportNull$$$0(7);
        }
        return lineConfig;
    }

    private void modelChanged() {
        this.myRedraw = true;
        this.opaqueRepaint();
    }

    private void redraw(@NotNull Dimension dim) {
        if (dim == null) {
            LineChart.$$$reportNull$$$0(8);
        }
        long duration = System.nanoTime();
        List<SeriesData<Long>> lastStackedSeries = null;
        ArrayDeque<Path2D.Float> orderedPaths = new ArrayDeque<Path2D.Float>(this.myLinesConfig.size());
        ArrayDeque<RangedContinuousSeries> orderedSeries = new ArrayDeque<RangedContinuousSeries>(this.myLinesConfig.size());
        for (RangedContinuousSeries ranged : this.myModel.getSeries()) {
            if (ranged.getXRange().isEmpty() || ranged.getXRange().isPoint() || ranged.getYRange().isEmpty() || ranged.getYRange().isPoint()) continue;
            LineConfig config = this.getLineConfig(ranged);
            List<SeriesData<Long>> seriesList = ranged.getSeries();
            if (config.isStacked()) {
                if (lastStackedSeries == null) {
                    lastStackedSeries = ContainerUtil.map(seriesList, data -> new SeriesData<Long>(data.x, (Long)data.value));
                } else {
                    for (int i = 0; i < seriesList.size() && i < lastStackedSeries.size(); ++i) {
                        SeriesData seriesData = (SeriesData)lastStackedSeries.get(i);
                        Long.valueOf((Long)seriesData.value + (Long)((SeriesData)seriesList.get((int)i)).value);
                        seriesData.value = seriesData.value;
                    }
                    seriesList = lastStackedSeries;
                }
            }
            Path2D.Float path = new Path2D.Float();
            double xMin = ranged.getXRange().getMin();
            double xLength = ranged.getXRange().getLength();
            double yMin = ranged.getYRange().getMin();
            double yLength = ranged.getYRange().getLength();
            double firstXd = 0.0;
            double firstX = 0.0;
            seriesList = this.myReducer.reduceData(seriesList, config);
            double xBucketInterval = config.getDataBucketInterval() / xLength;
            double xBucketBarWidth = xBucketInterval * 0.7;
            boolean optimizeYZooming = !config.isStepped() && xBucketInterval == 0.0;
            for (int i = 0; i < seriesList.size(); ++i) {
                double barX;
                SeriesData<Long> data2 = seriesList.get(i);
                SeriesData<Long> dataNext = seriesList.get(i + 1 == seriesList.size() ? i : i + 1);
                SeriesData<Long> dataPrev = seriesList.get(i - 1 < 0 ? i : i - 1);
                double xd = ((double)data2.x - xMin) / xLength;
                double yd = 1.0 - ((double)((Long)data2.value).longValue() - yMin) / yLength;
                double originalXd = xd;
                if (xd < 0.0) {
                    double xdNext = ((double)dataNext.x - xMin) / xLength;
                    if (xdNext < 0.0) {
                        if (data2 != dataNext) continue;
                        ((Path2D)path).moveTo(0.0, yd);
                        continue;
                    }
                    double ydNext = 1.0 - ((double)((Long)dataNext.value).longValue() - yMin) / yLength;
                    double newPosition = 0.0;
                    if (config.isDash()) {
                        newPosition = xd % 1.0;
                    }
                    if (optimizeYZooming) {
                        double ratio = (newPosition - xd) / (xdNext - xd);
                        yd = (1.0 - ratio) * yd + ratio * ydNext;
                    }
                    xd = newPosition;
                } else if (xd > 1.0) {
                    double xdPrev = ((double)dataPrev.x - xMin) / xLength;
                    if (xdPrev > 1.0) break;
                    if (optimizeYZooming) {
                        double ratio = (1.0 - xdPrev) / (xd - xdPrev);
                        double ydPrev = 1.0 - ((double)((Long)dataPrev.value).longValue() - yMin) / yLength;
                        yd = (1.0 - ratio) * ydPrev + ratio * yd;
                    }
                    xd = 1.0;
                }
                if (path.getCurrentPoint() == null) {
                    firstXd = xd;
                    firstX = data2.x;
                    ((Path2D)path).moveTo(xd, xBucketInterval != 0.0 ? 1.0 : yd);
                } else if (xBucketInterval == 0.0) {
                    if (config.isStepped()) {
                        float y = (float)path.getCurrentPoint().getY();
                        ((Path2D)path).lineTo(xd, y);
                    }
                    ((Path2D)path).lineTo(xd, yd);
                }
                if (xBucketInterval == 0.0 || !((barX = Math.min(1.0, originalXd + xBucketBarWidth)) - xd > (double)1.0E-4f)) continue;
                ((Path2D)path).lineTo(xd, 1.0);
                ((Path2D)path).lineTo(xd, yd);
                ((Path2D)path).lineTo(barX, yd);
                ((Path2D)path).lineTo(barX, 1.0);
            }
            if (this.myFillEndGap && path.getCurrentPoint() != null) {
                ((Path2D)path).lineTo(Math.max(path.getCurrentPoint().getX(), 1.0), path.getCurrentPoint().getY());
            }
            if (config.isFilled() && path.getCurrentPoint() != null) {
                ((Path2D)path).lineTo(path.getCurrentPoint().getX(), 1.0);
                ((Path2D)path).lineTo(firstXd, 1.0);
            }
            if (config.isFilled()) {
                orderedPaths.addFirst(path);
                orderedSeries.addFirst(ranged);
            } else {
                orderedPaths.addLast(path);
                orderedSeries.addLast(ranged);
            }
            if (config.isDash() && config.isAdjustDash()) {
                DashInfo dashInfo;
                if (!this.myDashInfoCache.containsKey(config)) {
                    dashInfo = new DashInfo();
                    this.myDashInfoCache.put(config, dashInfo);
                } else {
                    dashInfo = this.myDashInfoCache.get(config);
                    this.computeAdjustedDashPhase(dashInfo, config, path, dim, firstX, xMin, xLength, yLength);
                }
                dashInfo.myPreviousFirstX = firstX;
                dashInfo.myPreviousXMin = xMin;
                dashInfo.myPreviousXLength = xLength;
                dashInfo.myPreviousYLength = yLength;
                dashInfo.myPreviousDashPath = path;
                continue;
            }
            this.myDashInfoCache.remove(config);
        }
        this.myLinePaths.clear();
        this.myLinePaths.addAll(orderedPaths);
        this.myLinePathSeries.clear();
        this.myLinePathSeries.addAll(orderedSeries);
        this.addDebugInfo("postAnimate time: %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - duration));
    }

    @Override
    protected void draw(Graphics2D g2d, Dimension dim) {
        int i;
        long now;
        long drawStartTime = now = System.nanoTime();
        if ((double)(now - this.myLastCount) > 1.0E9) {
            this.myLastDraws = this.myDraws;
            this.myLastRedraws = this.myRedraws;
            this.myDraws = 0L;
            this.myRedraws = 0L;
            this.myLastCount = now;
        }
        ++this.myDraws;
        if (this.myRedraw) {
            this.myRedraw = false;
            this.redraw(dim);
            ++this.myRedraws;
        } else {
            this.addDebugInfo("postAnimate time: 0 ms", new Object[0]);
        }
        this.addDebugInfo("Draws in the last second %d", this.myLastDraws);
        this.addDebugInfo("Redraws in the last second %d", this.myLastRedraws);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform scale = new AffineTransform(dim.getWidth(), 0.0, 0.0, dim.getHeight() - (double)this.myTopPadding, (double)this.myXOffset, (double)(this.myYOffset + this.myTopPadding));
        if (this.myShowMaxLine) {
            g2d.setColor(this.myMaxLineColor);
            g2d.setStroke(new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f));
            g2d.drawLine(this.myMaxLineMargin, 0, dim.width, 0);
        }
        ArrayList<Path2D> transformedPaths = new ArrayList<Path2D>(this.myLinePaths.size());
        ArrayList<LineConfig> configs = new ArrayList<LineConfig>(this.myLinePaths.size());
        for (i = 0; i < this.myLinePaths.size(); ++i) {
            Path2D scaledPath = new Path2D.Float(this.myLinePaths.get(i), scale);
            LineConfig config = this.getLineConfig(this.myLinePathSeries.get(i));
            configs.add(config);
            scaledPath = this.myReducer.reducePath(scaledPath, config);
            transformedPaths.add(scaledPath);
            if (!this.isDrawDebugInfo()) continue;
            int count = 0;
            PathIterator it = scaledPath.getPathIterator(null);
            while (!it.isDone()) {
                ++count;
                it.next();
            }
            this.addDebugInfo("# of points drawn: %d", count);
        }
        for (i = 0; i < transformedPaths.size(); ++i) {
            LineChart.drawLine(g2d, (Path2D)transformedPaths.get(i), (LineConfig)configs.get(i));
        }
        this.myCustomRenderers.forEach(renderer -> renderer.renderLines(this, g2d, transformedPaths, this.myLinePathSeries));
        this.addDebugInfo("Draw time: %.2fms", (double)(System.nanoTime() - drawStartTime) / 1000000.0);
    }

    public static void drawLine(@NotNull Graphics2D g2d, @NotNull Path2D path, @NotNull LineConfig config) {
        if (g2d == null) {
            LineChart.$$$reportNull$$$0(9);
        }
        if (path == null) {
            LineChart.$$$reportNull$$$0(10);
        }
        if (config == null) {
            LineChart.$$$reportNull$$$0(11);
        }
        g2d.setColor(config.getColor());
        g2d.setStroke(config.isDash() && config.isAdjustDash() ? config.getAdjustedStroke() : config.getStroke());
        if (config.isStepped()) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (config.isFilled()) {
            g2d.fill(path);
        } else {
            g2d.draw(path);
        }
    }

    public void setShowMaxLine(boolean showMaxLine) {
        this.myShowMaxLine = showMaxLine;
    }

    public void setMaxLineColor(@NotNull Color maxLineColor) {
        if (maxLineColor == null) {
            LineChart.$$$reportNull$$$0(12);
        }
        this.myMaxLineColor = maxLineColor;
    }

    public void setMaxLineMargin(int maxLineMargin) {
        this.myMaxLineMargin = maxLineMargin;
    }

    /*
     * WARNING - void declaration
     */
    private void computeAdjustedDashPhase(@NotNull DashInfo dashInfo, @NotNull LineConfig config, @NotNull Path2D path, @NotNull Dimension dim, double firstX, double xMin, double d, double d2) {
        void yLength;
        void xLength;
        if (dashInfo == null) {
            LineChart.$$$reportNull$$$0(13);
        }
        if (config == null) {
            LineChart.$$$reportNull$$$0(14);
        }
        if (path == null) {
            LineChart.$$$reportNull$$$0(15);
        }
        if (dim == null) {
            LineChart.$$$reportNull$$$0(16);
        }
        if (Math.abs(dashInfo.myPreviousXLength - xLength) > (double)1.0E-4f || Math.abs(dashInfo.myPreviousYLength - yLength) > (double)1.0E-4f || Math.abs(dashInfo.myPreviousXMin - xMin) > xLength / 2.0) {
            return;
        }
        Path2D pathToUse = null;
        double firstXd = 0.0;
        boolean newPathIsAhead = false;
        if (xMin - dashInfo.myPreviousXMin > (double)1.0E-4f) {
            pathToUse = dashInfo.myPreviousDashPath;
            firstXd = (firstX - dashInfo.myPreviousXMin) / xLength;
            newPathIsAhead = true;
        } else if (dashInfo.myPreviousXMin - xMin > (double)1.0E-4f) {
            pathToUse = path;
            firstXd = (dashInfo.myPreviousFirstX - xMin) / xLength;
        }
        if (pathToUse == null || pathToUse.getCurrentPoint() == null) {
            return;
        }
        float dashPatternLength = config.getDashLength();
        double deltaPathLength = 0.0;
        PathIterator iterator = pathToUse.getPathIterator(null);
        float[] coords = new float[6];
        int segType = iterator.currentSegment(coords);
        assert (segType == 0);
        if (Math.abs((double)coords[0] - firstXd) < (double)1.0E-4f) {
            return;
        }
        double prevX = coords[0];
        double prevY = coords[1];
        iterator.next();
        while (!iterator.isDone()) {
            segType = iterator.currentSegment(coords);
            assert (segType == 1);
            if ((double)coords[0] - firstXd >= (double)1.0E-4f) {
                if (!(firstXd - prevX >= (double)1.0E-4f)) break;
                deltaPathLength += (firstXd - prevX) * (double)dim.width;
                break;
            }
            deltaPathLength = config.isStepped() ? (deltaPathLength += Math.abs((double)coords[0] - prevX) * (double)dim.width + Math.abs((double)coords[1] - prevY) * (double)dim.height) : (deltaPathLength += Math.hypot(((double)coords[0] - prevX) * (double)dim.width, ((double)coords[1] - prevY) * (double)dim.height));
            prevX = coords[0];
            prevY = coords[1];
            iterator.next();
        }
        double dashPhase = config.getAdjustedDashPhase();
        if (newPathIsAhead) {
            dashPhase = (dashPhase + deltaPathLength) % (double)dashPatternLength;
        } else if ((dashPhase = (dashPhase - deltaPathLength) % (double)dashPatternLength) < 0.0) {
            dashPhase += (double)dashPatternLength;
        }
        config.setAdjustedDashPhase(dashPhase);
    }

    public void setRenderOffset(int xOffset, int yOffset) {
        this.myXOffset = xOffset;
        this.myYOffset = yOffset;
    }

    public void setTopPadding(int padding) {
        this.myTopPadding = padding;
    }

    public void setFillEndGap(boolean fillEndGap) {
        this.myFillEndGap = fillEndGap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "series";
                break;
            }
            case 5: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/linechart/LineChart";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dim";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maxLineColor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dashInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/linechart/LineChart";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addCustomRenderer";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "redraw";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "drawLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMaxLineColor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeAdjustedDashPhase";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DashInfo {
        double myPreviousFirstX;
        double myPreviousXMin;
        double myPreviousXLength;
        double myPreviousYLength;
        Path2D myPreviousDashPath;

        private DashInfo() {
        }
    }
}

