/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.linechart;

import com.android.tools.adtui.chart.linechart.AbstractDurationDataRenderer;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DurationDataRenderer<E extends DurationData>
extends AspectObserver
implements AbstractDurationDataRenderer {
    static final float EPSILON = 1.0E-6f;
    static final JBColor BACKGROUND_HIGHLIGHT_COLOR = new JBColor(ColorUtil.withAlpha((Color)JBColor.BLACK, (double)0.2f), ColorUtil.withAlpha((Color)JBColor.WHITE, (double)0.2f));
    @NotNull
    private DurationDataModel<E> myModel;
    @NotNull
    private final List<Rectangle2D.Float> myClickRegionCache;
    @NotNull
    private final List<SeriesData<E>> myDataCache;
    @NotNull
    private final List<Boolean> myRegionOnLineSeries;
    @NotNull
    private final Color myColor;
    @Nullable
    private final Color myDurationBgColor;
    @Nullable
    private Icon myIcon;
    @Nullable
    private Function<E, Icon> myIconMapper;
    @Nullable
    private Stroke myStroke;
    @Nullable
    private Function<E, String> myLabelProvider;
    @Nullable
    private Consumer<E> myClickHandler;
    @Nullable
    private Consumer<E> myHoverHandler;
    @Nullable
    private Color myLabelBgColor;
    @Nullable
    private Color myLabelHoveredBgColor;
    @Nullable
    private Color myLabelClickedBgColor;
    @Nullable
    private Color myLabelTextColor;
    private float myLineStrokeOffset;
    private float myLabelXOffset;
    private float myLabelYOffset;
    private boolean myBackgroundClickable;
    @NotNull
    private final Insets myHostInsets;
    private int myClickRegionPaddingX;
    private int myClickRegionPaddingY;
    @NotNull
    private final List<Rectangle2D.Float> myPathCache;
    @NotNull
    private final List<JLabel> myLabelCache;
    @NotNull
    private final Map<RangedContinuousSeries, LineConfig> myCustomLineConfigs;
    private Point myMousePosition;
    private Component myMouseComponent;
    private boolean myClick;
    private boolean myInComponentRegion;

    public DurationDataRenderer(@NotNull DurationDataModel<E> model2, @NotNull Builder<E> builder) {
        if (model2 == null) {
            DurationDataRenderer.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            DurationDataRenderer.$$$reportNull$$$0(1);
        }
        this.myClickRegionCache = new ArrayList<Rectangle2D.Float>();
        this.myDataCache = new ArrayList<SeriesData<E>>();
        this.myRegionOnLineSeries = new ArrayList<Boolean>();
        this.myPathCache = new ArrayList<Rectangle2D.Float>();
        this.myLabelCache = new ArrayList<JLabel>();
        this.myCustomLineConfigs = new HashMap<RangedContinuousSeries, LineConfig>();
        this.myModel = model2;
        this.myColor = builder.myColor;
        this.myDurationBgColor = builder.myDurationBgColor;
        this.myIcon = builder.myIcon;
        this.myIconMapper = builder.myIconMapper;
        this.myStroke = builder.myStroke;
        this.myLabelProvider = builder.myLabelProvider;
        this.myClickHandler = builder.myClickHandler;
        this.myHoverHandler = builder.myHoverHandler;
        this.myLabelBgColor = builder.myLabelBgColor;
        this.myLabelHoveredBgColor = builder.myLabelHoveredBgColor;
        this.myLabelClickedBgColor = builder.myLabelClickedBgColor;
        this.myLabelTextColor = builder.myLabelTextColor;
        this.myLabelXOffset = builder.myLabelXOffset;
        this.myLabelYOffset = builder.myLabelYOffset;
        this.myHostInsets = builder.myHostInsets;
        this.myClickRegionPaddingX = builder.myClickRegionPaddingX;
        this.myClickRegionPaddingY = builder.myClickRegionPaddingY;
        this.myBackgroundClickable = builder.myBackgroundClickable;
        if (this.myStroke instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)this.myStroke;
            this.myLineStrokeOffset = stroke.getLineWidth() / 2.0f;
        } else {
            this.myLineStrokeOffset = 0.0f;
        }
        this.myModel.addDependency(this).onChange(DurationDataModel.Aspect.DURATION_DATA, this::modelChanged);
    }

    public void addCustomLineConfig(@NotNull RangedContinuousSeries series, @NotNull LineConfig config) {
        if (series == null) {
            DurationDataRenderer.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DurationDataRenderer.$$$reportNull$$$0(3);
        }
        this.myCustomLineConfigs.put(series, config);
    }

    @VisibleForTesting
    LineConfig getCustomLineConfig(@NotNull RangedContinuousSeries series) {
        if (series == null) {
            DurationDataRenderer.$$$reportNull$$$0(4);
        }
        return this.myCustomLineConfigs.get(series);
    }

    @VisibleForTesting
    @NotNull
    public List<Rectangle2D.Float> getClickRegionCache() {
        List<Rectangle2D.Float> list = this.myClickRegionCache;
        if (list == null) {
            DurationDataRenderer.$$$reportNull$$$0(5);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public List<Boolean> getRegionOnLineSeries() {
        List<Boolean> list = this.myRegionOnLineSeries;
        if (list == null) {
            DurationDataRenderer.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void modelChanged() {
        this.myDataCache.clear();
        this.myClickRegionCache.clear();
        this.myPathCache.clear();
        this.myLabelCache.clear();
        this.myRegionOnLineSeries.clear();
        RangedSeries<E> series = this.myModel.getSeries();
        RangedContinuousSeries attached = this.myModel.getAttachedSeries();
        Predicate<SeriesData<E>> attachedPredicate = this.myModel.getAttachPredicate();
        double xMin = series.getXRange().getMin();
        double xLength = series.getXRange().getLength();
        List<SeriesData<E>> seriesList = series.getSeries();
        List attachedSeriesList = attached != null ? attached.getSeries() : null;
        double yMin = attached == null ? 0.0 : attached.getYRange().getMin();
        double yMax = attached == null ? 0.0 : attached.getYRange().getMax();
        int j = 0;
        SeriesData lastFoundData = null;
        for (SeriesData<E> data : seriesList) {
            Rectangle2D.Float rect = new Rectangle2D.Float();
            double yStart = 1.0;
            double xStart = ((double)data.x - xMin) / xLength;
            double xDuration = (double)((DurationData)data.value).getDurationUs() / xLength;
            rect.setRect(xStart, 0.0, xDuration, 1.0);
            this.myPathCache.add(rect);
            Rectangle2D.Float clickRegion = new Rectangle2D.Float();
            boolean regionIsOnLineSeries = false;
            if (attachedSeriesList != null && (attachedPredicate == null || attachedPredicate.test(data))) {
                while (j < attachedSeriesList.size()) {
                    SeriesData seriesData = attachedSeriesList.get(j);
                    if ((float)(seriesData.x - data.x) > 1.0E-6f) {
                        if (lastFoundData == null) break;
                        assert (this.myModel.getInterpolatable() != null);
                        double adjustedY = this.myModel.getInterpolatable().interpolate(lastFoundData, seriesData, data.x);
                        yStart = 1.0 - (adjustedY - yMin) / (yMax - yMin);
                        regionIsOnLineSeries = true;
                        break;
                    }
                    if (j == attachedSeriesList.size() - 1) {
                        yStart = 1.0 - ((double)((Long)seriesData.value).longValue() - yMin) / (yMax - yMin);
                        regionIsOnLineSeries = true;
                    }
                    lastFoundData = seriesData;
                    ++j;
                }
            }
            this.myDataCache.add(data);
            this.myClickRegionCache.add(clickRegion);
            this.myRegionOnLineSeries.add(regionIsOnLineSeries);
            double regionWidth = 0.0;
            double regionHeight = 0.0;
            Icon icon = this.getIcon((DurationData)data.value);
            if (icon != null) {
                regionWidth += (double)icon.getIconWidth();
                regionHeight += (double)icon.getIconHeight();
            }
            if (this.myLabelProvider != null) {
                JLabel label2 = new JLabel(this.myLabelProvider.apply((DurationData)data.value));
                label2.setFont((Font)AdtUiUtils.DEFAULT_FONT.deriveFont(9.0f));
                label2.setForeground(this.myLabelTextColor);
                Dimension size = label2.getPreferredSize();
                label2.setBounds(0, 0, size.width, size.height);
                this.myLabelCache.add(label2);
                regionWidth += size.getWidth();
                regionHeight = Math.max(regionHeight, size.getHeight());
            }
            if (!(regionWidth > 0.0)) continue;
            clickRegion.setRect(xStart, yStart, regionWidth, regionHeight);
        }
        if (this.myHoverHandler != null) {
            E pickData = this.calculatePickData();
            this.myHoverHandler.accept(pickData);
        }
    }

    @Override
    public void renderLines(@NotNull LineChart lineChart, @NotNull Graphics2D g2d, @NotNull List<Path2D> transformedPaths, @NotNull List<RangedContinuousSeries> series) {
        if (lineChart == null) {
            DurationDataRenderer.$$$reportNull$$$0(7);
        }
        if (g2d == null) {
            DurationDataRenderer.$$$reportNull$$$0(8);
        }
        if (transformedPaths == null) {
            DurationDataRenderer.$$$reportNull$$$0(9);
        }
        if (series == null) {
            DurationDataRenderer.$$$reportNull$$$0(10);
        }
        BiPredicate<SeriesData<E>, RangedContinuousSeries> renderSeriesPredicate = this.myModel.getRenderSeriesPredicate();
        if (this.myDurationBgColor != null || !this.myCustomLineConfigs.isEmpty() || renderSeriesPredicate != null) {
            Shape originalClip = g2d.getClip();
            Dimension dim = lineChart.getSize();
            Rectangle2D.Float clipRect = new Rectangle2D.Float();
            ArrayList<LineConfig> configs = new ArrayList<LineConfig>(series.size());
            for (RangedContinuousSeries rangedSeries : series) {
                LineConfig config = lineChart.getLineConfig(rangedSeries);
                if (this.myCustomLineConfigs.containsKey(rangedSeries)) {
                    LineConfig customConfig = this.myCustomLineConfigs.get(rangedSeries);
                    if (config.isAdjustDash() && customConfig.isAdjustDash()) {
                        customConfig.setAdjustedDashPhase(config.getAdjustedDashPhase());
                    }
                    config = customConfig;
                }
                configs.add(config);
            }
            for (int i = 0; i < this.myPathCache.size(); ++i) {
                Rectangle2D.Float rect = this.myPathCache.get(i);
                SeriesData<E> data = this.myDataCache.get(i);
                double scaledXStart = (double)rect.x * dim.getWidth();
                double scaledXDuration = (double)rect.width * dim.getWidth();
                double newX = Math.max(scaledXStart, originalClip.getBounds().getX());
                ((Rectangle2D)clipRect).setRect(newX, originalClip.getBounds().getY(), Math.min(scaledXDuration + scaledXStart - newX, originalClip.getBounds().getX() + originalClip.getBounds().getWidth() - newX), Math.min(originalClip.getBounds().getHeight(), dim.getHeight()));
                g2d.setColor(this.myDurationBgColor == null ? lineChart.getBackground() : this.myDurationBgColor);
                g2d.setClip(clipRect);
                g2d.fill(clipRect);
                for (int j = 0; j < transformedPaths.size(); ++j) {
                    RangedContinuousSeries rangedSeries = series.get(j);
                    if (renderSeriesPredicate != null && !renderSeriesPredicate.test(data, rangedSeries)) continue;
                    LineChart.drawLine(g2d, transformedPaths.get(j), (LineConfig)configs.get(j));
                }
                if (this.myBackgroundClickable && this.myMousePosition != null && (double)this.myMousePosition.x > scaledXStart && (double)this.myMousePosition.x < scaledXStart + scaledXDuration) {
                    g2d.setColor((Color)BACKGROUND_HIGHLIGHT_COLOR);
                    g2d.fill(clipRect);
                }
                g2d.setClip(originalClip);
            }
        }
        if (this.myStroke != null) {
            g2d.setColor(this.myColor);
            g2d.setStroke(this.myStroke);
            Line2D.Float eventLine = new Line2D.Float();
            for (Rectangle2D.Float rect : this.myPathCache) {
                double scaledXStart = rect.x * (float)lineChart.getWidth();
                double scaledXDuration = rect.width * (float)lineChart.getWidth();
                g2d.translate(scaledXStart, 0.0);
                ((Line2D)eventLine).setLine(0.0, 0.0, 0.0, lineChart.getHeight());
                g2d.draw(eventLine);
                ((Line2D)eventLine).setLine(scaledXDuration, 0.0, scaledXDuration, lineChart.getHeight());
                g2d.draw(eventLine);
                g2d.translate(-scaledXStart, 0.0);
            }
        }
    }

    @VisibleForTesting
    Rectangle2D.Float getScaledClickRegion(@NotNull Rectangle2D.Float rect, int componentWidth, int componentHeight, boolean regionOnLineSeries) {
        if (rect == null) {
            DurationDataRenderer.$$$reportNull$$$0(11);
        }
        float paddedHeight = rect.height + (float)(this.myClickRegionPaddingY * 2);
        float paddedWidth = rect.width + (float)(this.myClickRegionPaddingX * 2);
        int totalXInsets = this.myHostInsets.left + this.myHostInsets.right;
        float scaledStartX = (float)this.myHostInsets.left + rect.x * (float)(componentWidth - totalXInsets) + this.myLabelXOffset + this.myLineStrokeOffset;
        float scaledStartY = this.getClampedLabelY(rect.y, paddedHeight, componentHeight, !regionOnLineSeries);
        return new Rectangle2D.Float(scaledStartX, scaledStartY, paddedWidth, paddedHeight);
    }

    @Override
    public void renderOverlay(@NotNull Component host, @NotNull Graphics2D g2d) {
        if (host == null) {
            DurationDataRenderer.$$$reportNull$$$0(12);
        }
        if (g2d == null) {
            DurationDataRenderer.$$$reportNull$$$0(13);
        }
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float rect = this.getScaledClickRegion(this.myClickRegionCache.get(i), host.getWidth(), host.getHeight(), this.myRegionOnLineSeries.get(i));
            if (this.myLabelBgColor != null) {
                g2d.setColor(this.myLabelBgColor);
                if (this.myMousePosition != null && rect.contains(this.myMousePosition)) {
                    g2d.setColor(this.myHoverHandler != null || this.myClick && this.myClickHandler != null ? this.myLabelClickedBgColor : this.myLabelHoveredBgColor);
                }
                g2d.fill(rect);
            }
            rect.x += (float)this.myClickRegionPaddingX;
            rect.y += (float)this.myClickRegionPaddingY;
            g2d.translate(rect.x, rect.y);
            Icon icon = this.getIcon((DurationData)this.myDataCache.get((int)i).value);
            if (icon != null) {
                icon.paintIcon(host, g2d, 0, 0);
                float shift = icon.getIconWidth();
                g2d.translate(shift, 0.0);
                rect.x += shift;
            }
            if (this.myLabelProvider != null) {
                this.myLabelCache.get(i).paint(g2d);
            }
            g2d.translate(-rect.x, -rect.y);
        }
        this.myClick = false;
    }

    private boolean isHoveringOverClickRegion(@NotNull Component overlayComponent, @NotNull MouseEvent event) {
        if (overlayComponent == null) {
            DurationDataRenderer.$$$reportNull$$$0(14);
        }
        if (event == null) {
            DurationDataRenderer.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < this.myClickRegionCache.size(); ++i) {
            Rectangle2D.Float region = this.myClickRegionCache.get(i);
            boolean regionOnLineSeries = this.myRegionOnLineSeries.get(i);
            Rectangle2D.Float rect = this.getScaledClickRegion(region, overlayComponent.getWidth(), overlayComponent.getHeight(), regionOnLineSeries);
            if (this.myMousePosition == null || !rect.contains(this.myMousePosition)) continue;
            return true;
        }
        return this.myBackgroundClickable && this.calculateBackgroundData() != null;
    }

    @Override
    public boolean handleMouseEvent(@NotNull Component overlayComponent, @NotNull Component selectionComponent, @NotNull MouseEvent event) {
        if (overlayComponent == null) {
            DurationDataRenderer.$$$reportNull$$$0(16);
        }
        if (selectionComponent == null) {
            DurationDataRenderer.$$$reportNull$$$0(17);
        }
        if (event == null) {
            DurationDataRenderer.$$$reportNull$$$0(18);
        }
        this.myMousePosition = event.getPoint();
        if (event.getID() == 504) {
            this.myInComponentRegion = true;
        } else if (event.getID() == 505) {
            this.myInComponentRegion = false;
        }
        this.myMouseComponent = event.getComponent();
        E pickData = this.calculatePickData();
        if (this.myHoverHandler != null) {
            this.myHoverHandler.accept(pickData);
        }
        boolean bl = this.myClick = event.getClickCount() > 0;
        if (this.myClickHandler != null && this.myClick) {
            if (pickData == null && this.myBackgroundClickable) {
                pickData = this.calculateBackgroundData();
            }
            if (pickData != null) {
                this.myClickHandler.accept(pickData);
                return true;
            }
        }
        if (this.isHoveringOverClickRegion(overlayComponent, event)) {
            selectionComponent.setCursor(Cursor.getPredefinedCursor(0));
            return true;
        }
        return false;
    }

    @Nullable
    private E calculateBackgroundData() {
        assert (this.myMousePosition != null);
        for (int i = 0; i < this.myPathCache.size(); ++i) {
            Rectangle2D.Float rect = this.myPathCache.get(i);
            Dimension dim = this.myMouseComponent.getSize();
            double scaledXStart = (double)rect.x * dim.getWidth();
            double scaledXWidth = (double)rect.width * dim.getWidth();
            if (!((double)this.myMousePosition.x >= scaledXStart) || !((double)this.myMousePosition.x < scaledXStart + scaledXWidth)) continue;
            return (E)((DurationData)this.myDataCache.get((int)i).value);
        }
        return null;
    }

    @Nullable
    private E calculatePickData() {
        if (!this.myInComponentRegion || this.myMouseComponent == null) {
            return null;
        }
        DurationData closestData = null;
        double closestManhattanDistance = 3.4028234663852886E38;
        Dimension dim = this.myMouseComponent.getSize();
        for (int i = 0; i < this.myDataCache.size(); ++i) {
            double manhattanDistance;
            Rectangle2D.Float rect = this.myClickRegionCache.get(i);
            float paddedWidth = rect.width + (float)(this.myClickRegionPaddingX * 2);
            float paddedHeight = rect.height + (float)(this.myClickRegionPaddingY * 2);
            boolean onLineSeries = this.myRegionOnLineSeries.get(i);
            float scaledY = this.getClampedLabelY(rect.y, paddedHeight, dim.height, !onLineSeries);
            Rectangle2D.Float scaledRect = new Rectangle2D.Float(rect.x * (float)dim.width + this.myLabelXOffset + this.myLineStrokeOffset, scaledY, paddedWidth, paddedWidth);
            if (!scaledRect.contains(this.myMousePosition) || !((manhattanDistance = Math.abs(this.myMousePosition.getX() + this.myMousePosition.getY() - scaledRect.getX() - scaledRect.getY() - (scaledRect.getWidth() + scaledRect.getHeight()) * 0.5)) < closestManhattanDistance)) continue;
            closestManhattanDistance = manhattanDistance;
            closestData = (DurationData)this.myDataCache.get((int)i).value;
        }
        return (E)closestData;
    }

    private float getClampedLabelY(float normalizedY, float height, int hostHeight, boolean shouldRespectInsets) {
        float totalYInsets = this.myHostInsets.top + this.myHostInsets.bottom;
        float maxScaledY = (float)(hostHeight - this.myHostInsets.bottom) - height;
        float scaledY = (float)this.myHostInsets.top + normalizedY * ((float)hostHeight - totalYInsets) - height + this.myLabelYOffset;
        return shouldRespectInsets ? Math.max((float)this.myHostInsets.top, Math.min(scaledY, maxScaledY)) : scaledY;
    }

    @VisibleForTesting
    @Nullable
    Icon getIcon(E durationData) {
        if (this.myIconMapper != null) {
            return this.myIconMapper.apply(durationData);
        }
        if (this.myIcon != null) {
            return this.myIcon;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "series";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/chart/linechart/DurationDataRenderer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineChart";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedPaths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlayComponent";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/chart/linechart/DurationDataRenderer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClickRegionCache";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionOnLineSeries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCustomLineConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLineConfig";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renderLines";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getScaledClickRegion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderOverlay";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isHoveringOverClickRegion";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleMouseEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder<E extends DurationData> {
        @NotNull
        private final DurationDataModel<E> myModel;
        @NotNull
        private final Color myColor;
        @Nullable
        private Color myDurationBgColor;
        @Nullable
        private Icon myIcon;
        @Nullable
        private Function<E, Icon> myIconMapper;
        @Nullable
        private Stroke myStroke;
        @Nullable
        private Function<E, String> myLabelProvider;
        @Nullable
        private Consumer<E> myClickHandler;
        @Nullable
        private Consumer<E> myHoverHandler;
        @Nullable
        private Color myLabelBgColor;
        @Nullable
        private Color myLabelHoveredBgColor;
        @Nullable
        private Color myLabelClickedBgColor;
        @Nullable
        private Color myLabelTextColor;
        private float myLabelXOffset;
        private float myLabelYOffset;
        @NotNull
        private Insets myHostInsets;
        private int myClickRegionPaddingX;
        private int myClickRegionPaddingY;
        private boolean myBackgroundClickable;

        public Builder(@NotNull DurationDataModel<E> model2, @NotNull Color color) {
            if (model2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (color == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myIcon = null;
            this.myIconMapper = null;
            this.myStroke = null;
            this.myLabelProvider = null;
            this.myClickHandler = null;
            this.myHoverHandler = null;
            this.myLabelBgColor = null;
            this.myLabelHoveredBgColor = null;
            this.myLabelClickedBgColor = null;
            this.myLabelTextColor = null;
            this.myHostInsets = JBUI.emptyInsets();
            this.myClickRegionPaddingX = 4;
            this.myClickRegionPaddingY = 2;
            this.myBackgroundClickable = false;
            this.myModel = model2;
            this.myColor = color;
        }

        public Builder<E> setDurationBg(@NotNull Color durationBgColor) {
            if (durationBgColor == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myDurationBgColor = durationBgColor;
            return this;
        }

        public Builder<E> setIcon(@NotNull Icon icon) {
            if (icon == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myIcon = icon;
            return this;
        }

        public Builder<E> setIconMapper(@Nullable Function<E, Icon> iconMapper) {
            this.myIconMapper = iconMapper;
            return this;
        }

        public Builder<E> setStroke(@NotNull Stroke stroke) {
            if (stroke == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myStroke = stroke;
            return this;
        }

        public Builder<E> setLabelProvider(@NotNull Function<E, String> provider) {
            if (provider == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myLabelProvider = provider;
            return this;
        }

        public Builder<E> setClickHander(@NotNull Consumer<E> handler) {
            if (handler == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myClickHandler = handler;
            return this;
        }

        public Builder<E> setHoverHandler(@NotNull Consumer<E> handler) {
            if (handler == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myHoverHandler = handler;
            return this;
        }

        public Builder<E> setLabelColors(@NotNull Color bgColor, @NotNull Color hoveredColor, @NotNull Color clickedColor, @NotNull Color color) {
            if (bgColor == null) {
                Builder.$$$reportNull$$$0(8);
            }
            if (hoveredColor == null) {
                Builder.$$$reportNull$$$0(9);
            }
            if (clickedColor == null) {
                Builder.$$$reportNull$$$0(10);
            }
            if (color == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myLabelBgColor = bgColor;
            this.myLabelHoveredBgColor = hoveredColor;
            this.myLabelClickedBgColor = clickedColor;
            this.myLabelTextColor = color;
            return this;
        }

        public Builder<E> setLabelOffsets(float xOffset, float yOffset) {
            this.myLabelXOffset = xOffset;
            this.myLabelYOffset = yOffset;
            return this;
        }

        public Builder<E> setHostInsets(@NotNull Insets insets) {
            if (insets == null) {
                Builder.$$$reportNull$$$0(12);
            }
            this.myHostInsets = insets;
            return this;
        }

        public Builder<E> setClickRegionPadding(int xPadding, int yPadding) {
            this.myClickRegionPaddingX = xPadding;
            this.myClickRegionPaddingY = yPadding;
            return this;
        }

        public Builder<E> setBackgroundClickable(boolean clickable) {
            this.myBackgroundClickable = clickable;
            return this;
        }

        @NotNull
        public DurationDataRenderer<E> build() {
            return new DurationDataRenderer<E>(this.myModel, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "durationBgColor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stroke";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bgColor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hoveredColor";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clickedColor";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insets";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/chart/linechart/DurationDataRenderer$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setDurationBg";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setStroke";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabelProvider";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setClickHander";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setHoverHandler";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setLabelColors";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setHostInsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

