/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TabularLayout$SizeCalculator$WhenMappings;
import com.android.tools.adtui.TabularLayoutKt;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u000545678B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB%\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010)\u001a\u00020(2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020(2\u0006\u0010&\u001a\u00020\"H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0004J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0007J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0014J\u0014\u00101\u001a\u00020(*\u00020\"2\u0006\u00102\u001a\u000203H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00040\u000fj\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0004`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/android/tools/adtui/TabularLayout;", "Ljava/awt/LayoutManager2;", "colSizes", "", "Lcom/android/tools/adtui/TabularLayout$SizingRule;", "([Lcom/android/tools/adtui/TabularLayout$SizingRule;)V", "colSizesString", "", "(Ljava/lang/String;)V", "initialRowSizesString", "(Ljava/lang/String;Ljava/lang/String;)V", "initialRowSizes", "([Lcom/android/tools/adtui/TabularLayout$SizingRule;[Lcom/android/tools/adtui/TabularLayout$SizingRule;)V", "", "constraints", "Ljava/util/HashMap;", "Ljava/awt/Component;", "Lcom/android/tools/adtui/TabularLayout$Constraint;", "Lkotlin/collections/HashMap;", "numColumns", "", "getNumColumns", "()I", "rowSizes", "vGap", "addLayoutComponent", "", "comp", "constraint", "", "name", "getLayoutAlignmentX", "", "target", "Ljava/awt/Container;", "getLayoutAlignmentY", "invalidateLayout", "layoutContainer", "parent", "maximumLayoutSize", "Ljava/awt/Dimension;", "minimumLayoutSize", "preferredLayoutSize", "removeLayoutComponent", "setRowSizing", "rowIndex", "rowSize", "rowSizeString", "setVGap", "getLayoutSize", "includeExtraSize", "", "Constraint", "LayoutResult", "PosSize", "SizeCalculator", "SizingRule", "intellij.android.adt.ui"})
public final class TabularLayout
implements LayoutManager2 {
    private final List<SizingRule> colSizes;
    private final HashMap<Integer, SizingRule> rowSizes;
    private int vGap;
    private final HashMap<Component, Constraint> constraints;

    public final int getNumColumns() {
        return this.colSizes.size();
    }

    @NotNull
    public final TabularLayout setVGap(int vGap) {
        this.vGap = vGap;
        return this;
    }

    @NotNull
    public final TabularLayout setRowSizing(int rowIndex, @NotNull SizingRule rowSize) {
        Intrinsics.checkNotNullParameter((Object)rowSize, (String)"rowSize");
        ((Map)this.rowSizes).put(rowIndex, rowSize);
        return this;
    }

    @NotNull
    public final TabularLayout setRowSizing(int rowIndex, @NotNull String rowSizeString) {
        Intrinsics.checkNotNullParameter((Object)rowSizeString, (String)"rowSizeString");
        return this.setRowSizing(rowIndex, SizingRule.Companion.fromString(rowSizeString));
    }

    @Override
    public void addLayoutComponent(@NotNull Component comp, @NotNull Object constraint) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        boolean bl = constraint instanceof Constraint;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Children of containers using " + this.getClass().getSimpleName() + " must be added with a constraint";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = false;
        bl2 = false;
        Constraint $this$with = (Constraint)constraint;
        boolean bl5 = false;
        boolean bl6 = $this$with.getCol() + $this$with.getColSpan() <= this.colSizes.size();
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string = "Component added with invalid column span. col: " + $this$with.getCol() + ", span: " + $this$with.getColSpan() + ", num cols: " + this.colSizes.size();
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ((Map)this.constraints).put(comp, constraint);
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return 0.5f;
    }

    @Override
    public void invalidateLayout(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
    }

    @Override
    public void addLayoutComponent(@NotNull String name, @NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
    }

    @Override
    public void removeLayoutComponent(@NotNull Component comp) {
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        this.constraints.remove(comp);
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getLayoutSize(parent, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.getLayoutSize(parent, false);
    }

    private final Dimension getLayoutSize(Container $this$getLayoutSize, boolean includeExtraSize) {
        LayoutResult result = new LayoutResult($this$getLayoutSize);
        int w = result.getColCalculator().getTotalSize(includeExtraSize);
        int h = result.getRowCalculator().getTotalSize(includeExtraSize);
        Insets insets = result.getInsets();
        boolean bl = false;
        boolean bl2 = false;
        Insets $this$with = insets;
        boolean bl3 = false;
        return new Dimension($this$with.left + $this$with.right + w, $this$with.top + $this$with.bottom + h);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layoutContainer(@NotNull Container parent) {
        Sequence visibleComponents2;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        EdtInvocationManager edtInvocationManager = EdtInvocationManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)edtInvocationManager, (String)"EdtInvocationManager.getInstance()");
        boolean bl = edtInvocationManager.isEventDispatchThread();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        LayoutResult result = new LayoutResult(parent);
        SizeCalculator colCalc = result.getColCalculator();
        SizeCalculator rowCalc = result.getRowCalculator();
        if (colCalc.getLength() == 0 || rowCalc.getLength() == 0) {
            return;
        }
        Insets insets = parent.getInsets();
        List<PosSize> rowBounds = rowCalc.getBounds(insets.top, parent.getHeight() - insets.bottom - insets.top);
        List<PosSize> colBounds = colCalc.getBounds(insets.left, parent.getWidth() - insets.right - insets.left);
        Sequence $this$forEach$iv = visibleComponents2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence((Object)0, (Function1)layoutContainer.visibleComponents.1.INSTANCE), (int)parent.getComponentCount()), (Function1)((Function1)new Function1<Integer, Component>(parent){
            final /* synthetic */ Container $parent;

            public final Component invoke(int it) {
                return this.$parent.getComponent(it);
            }
            {
                this.$parent = container;
                super(1);
            }
        })), (Function1)layoutContainer.visibleComponents.3.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int n;
            int n2;
            int n3;
            Constraint cons;
            Component comp = (Component)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)this.constraints.get(comp));
            Intrinsics.checkNotNullExpressionValue((Object)cons, (String)"constraints[comp]!!");
            Iterable $this$sumBy$iv = (Iterable)RangesKt.until((int)cons.getCol(), (int)(cons.getCol() + cons.getColSpan()));
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            Iterator iterator = $this$sumBy$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int element$iv2;
                int n4 = element$iv2 = ((IntIterator)iterator).nextInt();
                n3 = sum$iv;
                n2 = 0;
                n = colBounds.get((int)it).getSize();
                sum$iv = n3 + n;
            }
            int totalWidth = sum$iv;
            Iterable $this$sumBy$iv2 = (Iterable)RangesKt.until((int)cons.getRow(), (int)(cons.getRow() + cons.getRowSpan()));
            boolean $i$f$sumBy2 = false;
            int sum$iv2 = 0;
            Iterator iterator2 = $this$sumBy$iv2.iterator();
            while (iterator2.hasNext()) {
                void it;
                int element$iv3;
                n2 = element$iv3 = ((IntIterator)iterator2).nextInt();
                n3 = sum$iv2;
                boolean bl6 = false;
                n = rowBounds.get((int)it).getSize();
                sum$iv2 = n3 + n;
            }
            int totalHeight = sum$iv2;
            PosSize c = colBounds.get(cons.getCol());
            PosSize r = rowBounds.get(cons.getRow());
            comp.setBounds(c.getPos(), r.getPos(), totalWidth, totalHeight);
        }
    }

    /*
     * WARNING - void declaration
     */
    public TabularLayout(@NotNull SizingRule[] colSizes, @NotNull SizingRule[] initialRowSizes) {
        Intrinsics.checkNotNullParameter((Object)colSizes, (String)"colSizes");
        Intrinsics.checkNotNullParameter((Object)initialRowSizes, (String)"initialRowSizes");
        this.colSizes = CollectionsKt.listOf((Object[])Arrays.copyOf(colSizes, colSizes.length));
        int n = 0;
        this.rowSizes = new HashMap();
        n = 0;
        this.constraints = new HashMap();
        SizingRule[] sizingRuleArray = initialRowSizes;
        int n2 = sizingRuleArray.length;
        n = 0;
        while (n < n2) {
            void i;
            SizingRule irs = sizingRuleArray[n];
            this.setRowSizing((int)i, irs);
            ++i;
        }
    }

    public TabularLayout(SizingRule ... colSizes) {
        Intrinsics.checkNotNullParameter((Object)colSizes, (String)"colSizes");
        this(colSizes, new SizingRule[0]);
    }

    public TabularLayout(@NotNull String colSizesString) {
        Intrinsics.checkNotNullParameter((Object)colSizesString, (String)"colSizesString");
        SizingRule[] sizingRuleArray = TabularLayoutKt.access$parseSizingRules(colSizesString);
        this(Arrays.copyOf(sizingRuleArray, sizingRuleArray.length));
    }

    public TabularLayout(@NotNull String colSizesString, @NotNull String initialRowSizesString) {
        Intrinsics.checkNotNullParameter((Object)colSizesString, (String)"colSizesString");
        Intrinsics.checkNotNullParameter((Object)initialRowSizesString, (String)"initialRowSizesString");
        this(TabularLayoutKt.access$parseSizingRules(colSizesString), TabularLayoutKt.access$parseSizingRules(initialRowSizesString));
    }

    public static final /* synthetic */ void access$setVGap$p(TabularLayout $this, int n) {
        $this.vGap = n;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0003\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule;", "", "type", "Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;", "value", "", "(Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;I)V", "getType", "()Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;", "getValue", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "FitSizing", "Type", "intellij.android.adt.ui"})
    public static final class SizingRule {
        @NotNull
        private final Type type;
        private final int value;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Type getType() {
            return this.type;
        }

        public final int getValue() {
            return this.value;
        }

        public SizingRule(@NotNull Type type, int value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.value = value;
        }

        @NotNull
        public final Type component1() {
            return this.type;
        }

        public final int component2() {
            return this.value;
        }

        @NotNull
        public final SizingRule copy(@NotNull Type type, int value) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            return new SizingRule(type, value);
        }

        public static /* synthetic */ SizingRule copy$default(SizingRule sizingRule, Type type, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                type = sizingRule.type;
            }
            if ((n2 & 2) != 0) {
                n = sizingRule.value;
            }
            return sizingRule.copy(type, n);
        }

        @NotNull
        public String toString() {
            return "SizingRule(type=" + (Object)((Object)this.type) + ", value=" + this.value + ")";
        }

        public int hashCode() {
            Type type = this.type;
            return (type != null ? ((Object)((Object)type)).hashCode() : 0) * 31 + Integer.hashCode(this.value);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SizingRule)) break block3;
                    SizingRule sizingRule = (SizingRule)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.type), (Object)((Object)sizingRule.type)) || this.value != sizingRule.value) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule$Type;", "", "(Ljava/lang/String;I)V", "FIT", "FIXED", "PROPORTIONAL", "intellij.android.adt.ui"})
        public static final class Type
        extends Enum<Type> {
            public static final /* enum */ Type FIT;
            public static final /* enum */ Type FIXED;
            public static final /* enum */ Type PROPORTIONAL;
            private static final /* synthetic */ Type[] $VALUES;

            static {
                Type[] typeArray = new Type[3];
                Type[] typeArray2 = typeArray;
                typeArray[0] = FIT = new Type();
                typeArray[1] = FIXED = new Type();
                typeArray[2] = PROPORTIONAL = new Type();
                $VALUES = typeArray;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String string) {
                return Enum.valueOf(Type.class, string);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule$FitSizing;", "", "(Ljava/lang/String;I)V", "MINIMUM", "PREFERRED", "intellij.android.adt.ui"})
        public static final class FitSizing
        extends Enum<FitSizing> {
            public static final /* enum */ FitSizing MINIMUM;
            public static final /* enum */ FitSizing PREFERRED;
            private static final /* synthetic */ FitSizing[] $VALUES;

            static {
                FitSizing[] fitSizingArray = new FitSizing[2];
                FitSizing[] fitSizingArray2 = fitSizingArray;
                fitSizingArray[0] = MINIMUM = new FitSizing();
                fitSizingArray[1] = PREFERRED = new FitSizing();
                $VALUES = fitSizingArray;
            }

            public static FitSizing[] values() {
                return (FitSizing[])$VALUES.clone();
            }

            public static FitSizing valueOf(String string) {
                return Enum.valueOf(FitSizing.class, string);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizingRule$Companion;", "", "()V", "fromString", "Lcom/android/tools/adtui/TabularLayout$SizingRule;", "s", "", "intellij.android.adt.ui"})
        public static final class Companion {
            @NotNull
            public final SizingRule fromString(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                fromString.1 $fun$getFitSizing$1 = fromString.1.INSTANCE;
                try {
                    SizingRule sizingRule;
                    if (Intrinsics.areEqual((Object)s, (Object)"*")) {
                        sizingRule = new SizingRule(Type.PROPORTIONAL, 1);
                    } else if (StringsKt.startsWith$default((String)s, (String)"Fit", (boolean)false, (int)2, null)) {
                        sizingRule = new SizingRule(Type.FIT, $fun$getFitSizing$1.invoke(s).ordinal());
                    } else if (StringsKt.endsWith$default((String)s, (String)"px", (boolean)false, (int)2, null)) {
                        String string = StringsKt.dropLast((String)s, (int)2);
                        boolean bl = false;
                        SizingRule sizingRule2 = new SizingRule(Type.FIXED, Integer.parseInt(string));
                        sizingRule = sizingRule2;
                    } else if (StringsKt.endsWith$default((String)s, (String)"*", (boolean)false, (int)2, null)) {
                        String string = StringsKt.dropLast((String)s, (int)1);
                        boolean bl = false;
                        SizingRule sizingRule3 = new SizingRule(Type.PROPORTIONAL, Integer.parseInt(string));
                        sizingRule = sizingRule3;
                    } else {
                        throw (Throwable)new IllegalArgumentException("Bad size value: \"" + s + '\"');
                    }
                    return sizingRule;
                }
                catch (NumberFormatException ex) {
                    throw (Throwable)new IllegalArgumentException("Bad size value: \"" + s + '\"');
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/adtui/TabularLayout$Constraint;", "", "row", "", "col", "colSpan", "(III)V", "rowSpan", "(IIII)V", "getCol", "()I", "getColSpan", "getRow", "getRowSpan", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.adt.ui"})
    public static final class Constraint {
        private final int row;
        private final int col;
        private final int rowSpan;
        private final int colSpan;

        public final int getRow() {
            return this.row;
        }

        public final int getCol() {
            return this.col;
        }

        public final int getRowSpan() {
            return this.rowSpan;
        }

        public final int getColSpan() {
            return this.colSpan;
        }

        public Constraint(int row, int col, int rowSpan, int colSpan) {
            this.row = row;
            this.col = col;
            this.rowSpan = rowSpan;
            this.colSpan = colSpan;
            boolean bl = this.colSpan > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "TabularLayout column span must be greater than 0";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @JvmOverloads
        public Constraint(int row, int col, int colSpan) {
            this(row, col, 1, colSpan);
        }

        public /* synthetic */ Constraint(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n3 = 1;
            }
            this(n, n2, n3);
        }

        @JvmOverloads
        public Constraint(int row, int col) {
            this(row, col, 0, 4, null);
        }

        public final int component1() {
            return this.row;
        }

        public final int component2() {
            return this.col;
        }

        public final int component3() {
            return this.rowSpan;
        }

        public final int component4() {
            return this.colSpan;
        }

        @NotNull
        public final Constraint copy(int row, int col, int rowSpan, int colSpan) {
            return new Constraint(row, col, rowSpan, colSpan);
        }

        public static /* synthetic */ Constraint copy$default(Constraint constraint, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = constraint.row;
            }
            if ((n5 & 2) != 0) {
                n2 = constraint.col;
            }
            if ((n5 & 4) != 0) {
                n3 = constraint.rowSpan;
            }
            if ((n5 & 8) != 0) {
                n4 = constraint.colSpan;
            }
            return constraint.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Constraint(row=" + this.row + ", col=" + this.col + ", rowSpan=" + this.rowSpan + ", colSpan=" + this.colSpan + ")";
        }

        public int hashCode() {
            return ((Integer.hashCode(this.row) * 31 + Integer.hashCode(this.col)) * 31 + Integer.hashCode(this.rowSpan)) * 31 + Integer.hashCode(this.colSpan);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Constraint)) break block3;
                    Constraint constraint = (Constraint)object;
                    if (this.row != constraint.row || this.col != constraint.col || this.rowSpan != constraint.rowSpan || this.colSpan != constraint.colSpan) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u001b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000bJ\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/adtui/TabularLayout$SizeCalculator;", "", "sparseRules", "", "", "Lcom/android/tools/adtui/TabularLayout$SizingRule;", "numRules", "gap", "(Ljava/util/Map;II)V", "rules", "", "(Ljava/util/List;I)V", "extraSize", "length", "getLength", "()I", "percentages", "", "", "sizes", "getBounds", "Lcom/android/tools/adtui/TabularLayout$PosSize;", "start", "totalSpace", "getComponentDimension", "Ljava/awt/Dimension;", "i", "c", "Ljava/awt/Component;", "getTotalSize", "includeExtraSize", "", "notifySize", "", "size", "intellij.android.adt.ui"})
    private static final class SizeCalculator {
        private final List<Integer> sizes;
        private final List<Float> percentages;
        private int extraSize;
        private final List<SizingRule> rules;
        private final int gap;

        public final int getLength() {
            return this.sizes.size();
        }

        public final void notifySize(int i, int size) {
            switch (TabularLayout$SizeCalculator$WhenMappings.$EnumSwitchMapping$1[this.rules.get(i).getType().ordinal()]) {
                case 1: {
                    this.sizes.set(i, RangesKt.coerceAtLeast((int)((Number)this.sizes.get(i)).intValue(), (int)size));
                    break;
                }
                case 2: {
                    this.extraSize = RangesKt.coerceAtLeast((int)this.extraSize, (int)MathKt.roundToInt((float)((float)size / ((Number)this.percentages.get(i)).floatValue())));
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        @NotNull
        public final Dimension getComponentDimension(int i, @NotNull Component c) {
            Dimension dimension;
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            if (this.rules.get(i).getValue() == SizingRule.FitSizing.PREFERRED.ordinal()) {
                Dimension dimension2 = c.getPreferredSize();
                dimension = dimension2;
                Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"c.preferredSize");
            } else {
                Dimension dimension3 = c.getMinimumSize();
                dimension = dimension3;
                Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"c.minimumSize");
            }
            return dimension;
        }

        /*
         * WARNING - void declaration
         */
        public final int getTotalSize(boolean includeExtraSize) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.sizes;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            int $i$f$filterTo = 0;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(it > 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notZeroSizes = (List)destination$iv$iv;
            int gapsNeeded = RangesKt.coerceAtLeast((int)(notZeroSizes.size() - 1), (int)0);
            Integer n = this.extraSize;
            boolean bl = false;
            boolean bl2 = false;
            $i$f$filterTo = ((Number)n).intValue();
            int n2 = CollectionsKt.sumOfInt((Iterable)notZeroSizes) + this.gap * gapsNeeded;
            boolean bl3 = false;
            boolean bl4 = includeExtraSize;
            Integer n3 = bl4 ? n : null;
            return n2 + (n3 != null ? n3 : 0);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PosSize> getBounds(int start, int totalSpace) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable $this$mapTo$iv$iv;
            if (this.sizes.size() == 0) {
                boolean bl = false;
                return CollectionsKt.emptyList();
            }
            int remainingSpace = totalSpace - CollectionsKt.sumOfInt((Iterable)this.sizes);
            Iterable $this$map$iv = this.sizes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                int n = ((Number)item$iv$iv).intValue();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PosSize posSize = new PosSize(0, 0, 3, null);
                boolean bl2 = false;
                boolean bl3 = false;
                PosSize $this$apply = posSize;
                boolean bl4 = false;
                $this$apply.setSize((int)it);
                PosSize posSize2 = posSize;
                collection.add(posSize2);
            }
            List bounds = (List)destination$iv$iv;
            if (remainingSpace > 0) {
                void $this$forEach$iv2;
                Iterator $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                int spaceUsed = 0;
                int lastIndex = -1;
                $this$mapTo$iv$iv = (Iterable)CollectionsKt.getIndices((Collection)this.rules);
                boolean $i$f$filter = false;
                void $i$f$mapTo2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator it = $this$filterTo$iv$iv2.iterator();
                while (it.hasNext()) {
                    Object element$iv$iv = it.next();
                    int it2 = ((Number)element$iv$iv).intValue();
                    boolean bl = false;
                    if (!(this.rules.get(it2).getType() == SizingRule.Type.PROPORTIONAL)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    int i = ((Number)element$iv).intValue();
                    boolean bl = false;
                    ((PosSize)bounds.get(i)).setSize(MathKt.roundToInt((float)((float)remainingSpace * ((Number)this.percentages.get(i)).floatValue())));
                    spaceUsed += ((PosSize)bounds.get(i)).getSize();
                    lastIndex = i;
                }
                if (spaceUsed != remainingSpace && lastIndex >= 0) {
                    PosSize posSize = (PosSize)bounds.get(lastIndex);
                    posSize.setSize(posSize.getSize() + (remainingSpace - spaceUsed));
                }
            }
            int pos = start;
            Iterable lastIndex = bounds;
            boolean $i$f$filter = false;
            void $i$f$forEach = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PosSize it = (PosSize)element$iv$iv;
                boolean bl = false;
                if (!(it.getSize() > 0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                PosSize it = (PosSize)element$iv;
                boolean bl = false;
                it.setPos(pos);
                pos += it.getSize() + this.gap;
            }
            return bounds;
        }

        /*
         * WARNING - void declaration
         */
        public SizeCalculator(@NotNull List<SizingRule> rules, int gap) {
            void $this$sumBy$iv2;
            void $this$filterTo$iv$iv;
            Number number;
            List<Integer> list;
            boolean bl;
            int n;
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            this.rules = rules;
            this.gap = gap;
            int n2 = this.rules.size();
            SizeCalculator sizeCalculator = this;
            boolean bl2 = false;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n2);
            boolean bl3 = false;
            int n3 = 0;
            n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                n = n3++;
                bl = false;
                int n5 = n;
                list = arrayList;
                boolean bl4 = false;
                number = 0;
                ((ArrayList)list).add(number);
            }
            list = arrayList;
            sizeCalculator.sizes = list;
            n2 = this.rules.size();
            sizeCalculator = this;
            bl2 = false;
            arrayList = new ArrayList(n2);
            bl3 = false;
            n3 = 0;
            n3 = 0;
            n4 = n2;
            while (n3 < n4) {
                n = n3++;
                bl = false;
                int it = n;
                list = arrayList;
                boolean bl5 = false;
                number = Float.valueOf(0.0f);
                ((ArrayList)list).add(number);
            }
            list = arrayList;
            sizeCalculator.percentages = list;
            Iterable $this$filter$iv = this.rules;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SizingRule it = (SizingRule)element$iv$iv;
                boolean bl6 = false;
                if (!(it.getType() == SizingRule.Type.PROPORTIONAL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sumBy = false;
            int sum$iv = 0;
            for (Object element$iv : $this$sumBy$iv2) {
                void it;
                SizingRule sizingRule = (SizingRule)element$iv;
                int n6 = sum$iv;
                boolean bl7 = false;
                int n7 = it.getValue();
                sum$iv = n6 + n7;
            }
            float totalProportionalSize = sum$iv;
            boolean $this$sumBy$iv2 = false;
            for (SizingRule rule : (Iterable)this.rules) {
                void i;
                switch (TabularLayout$SizeCalculator$WhenMappings.$EnumSwitchMapping$0[rule.getType().ordinal()]) {
                    case 1: {
                        boolean bl8 = totalProportionalSize > 0.0f;
                        n4 = 0;
                        boolean bl9 = false;
                        if (_Assertions.ENABLED && !bl8) {
                            boolean bl10 = false;
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        this.percentages.set((int)i, Float.valueOf((float)rule.getValue() / totalProportionalSize));
                        break;
                    }
                    case 2: {
                        this.sizes.set((int)i, JBUI.scale((int)rule.getValue()));
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                ++i;
            }
        }

        public SizeCalculator(@NotNull Map<Integer, SizingRule> sparseRules, int numRules, int gap) {
            Intrinsics.checkNotNullParameter(sparseRules, (String)"sparseRules");
            this(TabularLayoutKt.access$fromSparseRules(sparseRules, numRules), gap);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/adtui/TabularLayout$PosSize;", "", "pos", "", "size", "(II)V", "getPos", "()I", "setPos", "(I)V", "getSize", "setSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.adt.ui"})
    private static final class PosSize {
        private int pos;
        private int size;

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public PosSize(int pos, int size) {
            this.pos = pos;
            this.size = size;
        }

        public /* synthetic */ PosSize(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public PosSize() {
            this(0, 0, 3, null);
        }

        public final int component1() {
            return this.pos;
        }

        public final int component2() {
            return this.size;
        }

        @NotNull
        public final PosSize copy(int pos, int size) {
            return new PosSize(pos, size);
        }

        public static /* synthetic */ PosSize copy$default(PosSize posSize, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = posSize.pos;
            }
            if ((n3 & 2) != 0) {
                n2 = posSize.size;
            }
            return posSize.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "PosSize(pos=" + this.pos + ", size=" + this.size + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.pos) * 31 + Integer.hashCode(this.size);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PosSize)) break block3;
                    PosSize posSize = (PosSize)object;
                    if (this.pos != posSize.pos || this.size != posSize.size) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/adtui/TabularLayout$LayoutResult;", "", "container", "Ljava/awt/Container;", "(Lcom/android/tools/adtui/TabularLayout;Ljava/awt/Container;)V", "colCalculator", "Lcom/android/tools/adtui/TabularLayout$SizeCalculator;", "getColCalculator", "()Lcom/android/tools/adtui/TabularLayout$SizeCalculator;", "insets", "Ljava/awt/Insets;", "getInsets", "()Ljava/awt/Insets;", "rowCalculator", "getRowCalculator", "intellij.android.adt.ui"})
    private final class LayoutResult {
        @NotNull
        private final Insets insets;
        @NotNull
        private final SizeCalculator colCalculator;
        @NotNull
        private final SizeCalculator rowCalculator;

        @NotNull
        public final Insets getInsets() {
            return this.insets;
        }

        @NotNull
        public final SizeCalculator getColCalculator() {
            return this.colCalculator;
        }

        @NotNull
        public final SizeCalculator getRowCalculator() {
            return this.rowCalculator;
        }

        /*
         * WARNING - void declaration
         */
        public LayoutResult(Container container) {
            void $this$filterTo$iv$iv;
            void $this$forEach$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            this.colCalculator = new SizeCalculator(TabularLayout.this.colSizes, 0);
            EdtInvocationManager edtInvocationManager = EdtInvocationManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)edtInvocationManager, (String)"EdtInvocationManager.getInstance()");
            boolean bl = edtInvocationManager.isEventDispatchThread();
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            bl2 = false;
            List components = new ArrayList();
            int numRows = 0;
            Insets insets = container.getInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"container.insets");
            this.insets = insets;
            Iterable iterable = (Iterable)RangesKt.until((int)0, (int)container.getComponentCount());
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                Component component = container.getComponent((int)it);
                collection.add(component);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl6 = false;
                Component component = it;
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"it");
                components.add(component);
                Object v = TabularLayout.this.constraints.get(it);
                Intrinsics.checkNotNull(v);
                numRows = RangesKt.coerceAtLeast((int)numRows, (int)(((Constraint)v).getRow() + 1));
            }
            this.rowCalculator = new SizeCalculator(TabularLayout.this.rowSizes, numRows, TabularLayout.this.vGap);
            Iterable $this$filter$iv = components;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Component it = (Component)element$iv$iv;
                boolean bl7 = false;
                if (!it.isVisible()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Dimension size;
                Component it = (Component)element$iv;
                boolean bl8 = false;
                Object v = TabularLayout.this.constraints.get(it);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"constraints[it]!!");
                Constraint constraint = (Constraint)v;
                if (constraint.getColSpan() == 1) {
                    size = this.colCalculator.getComponentDimension(constraint.getCol(), it);
                    this.colCalculator.notifySize(constraint.getCol(), size.width);
                }
                if (constraint.getRowSpan() != 1) continue;
                size = this.rowCalculator.getComponentDimension(constraint.getRow(), it);
                this.rowCalculator.notifySize(constraint.getRow(), size.height);
            }
        }
    }
}

