/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.RangeSelectionComponent;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.BoxSelectionModel;
import com.android.tools.adtui.model.formatter.TimeFormatter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class BoxSelectionComponent
extends RangeSelectionComponent
implements MouseListener,
MouseMotionListener {
    @NotNull
    private final BoxSelectionModel myBoxSelectionModel;
    @NotNull
    private final JList<?> myList;
    private int myLastX;
    private int myLastRowIndex;

    public BoxSelectionComponent(@NotNull BoxSelectionModel model2, @NotNull JList<?> list) {
        if (model2 == null) {
            BoxSelectionComponent.$$$reportNull$$$0(0);
        }
        if (list == null) {
            BoxSelectionComponent.$$$reportNull$$$0(1);
        }
        super(model2);
        this.myLastX = 0;
        this.myLastRowIndex = -1;
        this.myBoxSelectionModel = model2;
        this.myList = list;
    }

    public void clearSelection() {
        this.getModel().clear();
        this.myList.clearSelection();
    }

    @Override
    protected void draw(Graphics2D g, Dimension size) {
        if (this.getModel().getSelectionRange().isEmpty() || this.myList.isSelectionEmpty()) {
            return;
        }
        int startX = (int)this.rangeToX(this.getModel().getSelectionRange().getMin(), size.getWidth());
        int endX = (int)this.rangeToX(this.getModel().getSelectionRange().getMax(), size.getWidth());
        Rectangle selectedCellBounds = this.myList.getCellBounds(this.myList.getMinSelectionIndex(), this.myList.getMaxSelectionIndex());
        int startY = selectedCellBounds.y;
        int endY = (int)selectedCellBounds.getMaxY();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor((Color)StudioColorsKt.getSelectionBackground());
        g.drawRect(startX, startY, endX - startX, endY - startY);
        g.setColor((Color)StudioColorsKt.getInactiveSelectionOverlayBackground());
        if (startX > 0) {
            g.fillRect(0, 0, startX, this.getHeight());
        }
        if ((double)endX < size.getWidth()) {
            g.fillRect(endX, 0, this.getWidth() - endX, this.getHeight());
        }
        if (this.myList.getMinSelectionIndex() > 0) {
            g.fillRect(startX, 0, endX - startX, startY);
        }
        if (this.myList.getMaxSelectionIndex() < this.myList.getModel().getSize() - 1) {
            g.fillRect(startX, endY, endX - startX, this.getHeight() - endY);
        }
        String measurementText = " " + TimeFormatter.getSingleUnitDurationString((long)this.getModel().getSelectionRange().getLength()) + " ";
        int textWidth = g.getFontMetrics().stringWidth(measurementText);
        int textHeight = g.getFontMetrics().getHeight();
        int textCenterX = startX + (endX - startX) / 2;
        int textStartX = textCenterX - textWidth / 2;
        int textEndX = textCenterX + textWidth / 2;
        g.setColor((Color)StudioColorsKt.getPrimaryContentBackground());
        g.fillRect(startX, endY, endX - startX, textHeight);
        g.setColor(UIUtil.getLabelForeground());
        g.drawString(measurementText, textStartX, endY + g.getFontMetrics().getAscent());
        if (textStartX > startX) {
            g.drawLine(startX, endY, startX, endY + textHeight);
            g.drawLine(endX, endY, endX, endY + textHeight);
            g.drawLine(startX, endY + textHeight / 2, textStartX, endY + textHeight / 2);
            g.drawLine(textEndX, endY + textHeight / 2, endX, endY + textHeight / 2);
        }
    }

    @Override
    protected void initListeners() {
        this.setEventHandlersEnabled(true);
    }

    public void setEventHandlersEnabled(boolean enabled) {
        if (enabled) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getModel().beginUpdate();
        this.clearSelection();
        this.myLastX = e.getX();
        this.myLastRowIndex = this.myList.locationToIndex(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.getModel().endUpdate();
        this.myLastX = 0;
        this.myLastRowIndex = -1;
        this.myBoxSelectionModel.selectionCreated((long)this.getModel().getSelectionRange().getLength(), this.myList.getLeadSelectionIndex() - this.myList.getAnchorSelectionIndex() + 1);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double pressed = this.xToRange(this.myLastX);
        double current = this.xToRange(e.getX());
        int rowIndex = this.myList.locationToIndex(e.getPoint());
        this.getModel().set(Math.min(pressed, current), Math.max(pressed, current));
        this.myList.setSelectionInterval(this.myLastRowIndex, rowIndex);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "model";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "list";
                break;
            }
        }
        objectArray[1] = "com/android/tools/adtui/BoxSelectionComponent";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

