/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerImpl;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerParameters;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereStartupExecutable;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.server.JavaeeParameters;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebSphereFullLocalHandler
extends WebSphereFullHandler {
    private static final Logger LOG = Logger.getInstance(WebSphereFullLocalHandler.class);
    private final WebSphereServerConfiguration myConfiguration;

    public WebSphereFullLocalHandler(WebSphereModel serverModel, WebSphereVersion version, WebSphereServerConfiguration configuration) {
        super(serverModel, version);
        this.myConfiguration = configuration;
    }

    @Override
    public int getLocalHttpPort() {
        return this.myConfiguration.getHttpPort();
    }

    @Override
    public int getServerPort() {
        return this.myConfiguration.getSOAPPort();
    }

    @Override
    public String getLogFilePath() {
        File logFile = this.myConfiguration.getSystemOutLogFile();
        return logFile.exists() ? logFile.getAbsolutePath() : null;
    }

    @Override
    public ExecutableObject createStartupExecutable() {
        return new WebSphereStartupExecutable(this.myConfiguration);
    }

    @Override
    public void getShutdownParameters(JavaeeParameters params, boolean debug) {
        params.add(this.myConfiguration.getProfile().getShutdownScriptFile());
        params.add(new String[]{this.myConfiguration.getServerName()});
        WebSphereModel serverModel = this.getServerModel();
        if (!StringUtil.isEmpty((String)serverModel.USERNAME) && !StringUtil.isEmpty((String)serverModel.PASSWORD)) {
            params.add(new String[]{"-username"});
            params.add(new String[]{serverModel.USERNAME});
            params.add(new String[]{"-password"});
            params.add(new String[]{serverModel.PASSWORD});
        }
    }

    @Override
    public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        this.beforeConnecting();
        return super.createServerAdmin(serverInstance);
    }

    private void beforeConnecting() {
        Map<String, String> properties = this.myConfiguration.getProfile().getProperties();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            System.setProperty(entry.getKey(), entry.getValue());
        }
    }

    @Override
    protected WebSphereAdminServerParameters getAdminServerParameters() throws RuntimeConfigurationException {
        return new WebSphereAdminServerParameters(){

            @Override
            public boolean isSecured() {
                return WebSphereFullLocalHandler.this.myConfiguration.getNode().getCell().isSecurityEnabled();
            }

            @Override
            public String getTrustStorePath() {
                return WebSphereFullLocalHandler.this.myConfiguration.getProfile().getClientTrustFile().getAbsolutePath();
            }

            @Override
            public String getTrustStorePassword() {
                return "WebAS";
            }

            @Override
            public String getKeyStorePath() {
                return WebSphereFullLocalHandler.this.myConfiguration.getProfile().getClientKeyFile().getAbsolutePath();
            }

            @Override
            public String getKeyStorePassword() {
                return "WebAS";
            }

            @Override
            public String getCellName() {
                return WebSphereFullLocalHandler.this.myConfiguration.getNode().getCell().getCellName();
            }

            @Override
            public String getNodeName() {
                return WebSphereFullLocalHandler.this.myConfiguration.getNode().getNodeName();
            }

            @Override
            public String getServerName() {
                return WebSphereFullLocalHandler.this.myConfiguration.getServerName();
            }

            @Override
            public boolean isUploadEARBeforeDeploy() {
                return false;
            }
        };
    }

    @Override
    protected boolean isDeploymentSupported() {
        return true;
    }

    @Override
    public void updateChangedFiles(Set<String> paths) {
        LOG.debug("Updating changed files: " + paths.size());
        CommonModel commonModel = this.getServerModel().getCommonModel();
        List artifactList = commonModel.getDeployedArtifacts();
        for (Artifact artifact : artifactList) {
            String appName;
            DeploymentModel deploymentModel;
            String outputPath = artifact.getOutputPath();
            if (JavaeeArtifactUtil.getInstance().isArchive(artifact.getArtifactType()) || outputPath == null || (deploymentModel = commonModel.getDeploymentModel(artifact)) == null) continue;
            WebSphereServerConfiguration configuration = this.myConfiguration;
            String cellName = configuration.getNode().getCell().getCellName();
            File installedAppsDir = new File(configuration.getProfile().getLocation().getAbsolutePath() + File.separator + "installedApps" + File.separator + cellName);
            File appDirectory = new File(installedAppsDir, appName = WebSphereAdminServerImpl.getDeploymentName(deploymentModel));
            if (!appDirectory.exists()) {
                appDirectory = new File(installedAppsDir, appName + ".ear");
            }
            if (!appDirectory.exists()) {
                LOG.info("cannot update '" + artifact.getName() + ": " + appDirectory.getAbsolutePath() + " doesn't exist");
                continue;
            }
            if (!appDirectory.isDirectory()) {
                LOG.info("cannot update '" + artifact.getName() + ": " + appDirectory.getAbsolutePath() + " is not a directory");
                continue;
            }
            LOG.debug("updating '" + artifact.getName() + "' artifact in '" + appDirectory.getAbsolutePath() + "'...");
            String artifactOutputPath = FileUtil.toSystemDependentName((String)outputPath);
            for (String path : paths) {
                try {
                    if (!FileUtil.startsWith((String)path, (String)artifactOutputPath)) continue;
                    String relativePath = FileUtil.getRelativePath((String)artifactOutputPath, (String)path, (char)File.separatorChar);
                    FileUtil.copy((File)new File(path), (File)new File(appDirectory.getAbsolutePath() + File.separator + relativePath));
                    LOG.debug(path + " updated");
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }
    }
}

