/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerImpl;
import com.intellij.j2ee.webSphere.admin.WebSphereAdminServerParameters;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.deploymentSource.LooseApplicationDeploymentSource;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereProfileHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRemoteModel;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.ui.packaging.WebApplicationArtifactType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Pattern;

public abstract class WebSphereFullHandler
implements WebSphereProfileHandler {
    private final WebSphereModel myServerModel;
    private final WebSphereVersion myVersion;

    public WebSphereFullHandler(WebSphereModel serverModel, WebSphereVersion version) {
        this.myServerModel = serverModel;
        this.myVersion = version;
    }

    protected final WebSphereModel getServerModel() {
        return this.myServerModel;
    }

    protected final WebSphereVersion getVersion() {
        return this.myVersion;
    }

    @Override
    public boolean isDetectableServerPort() {
        return true;
    }

    @Override
    public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        ProcessAgentProxyFactory agentProxyFactory = new ProcessAgentProxyFactory(serverInstance){

            protected Sdk getJdk() {
                String sdkPath = WebSphereFullHandler.this.myServerModel.getPathUnderHome("java").getAbsolutePath();
                List javaFiles = FileUtil.findFilesByMask((Pattern)Pattern.compile(SystemInfo.isWindows ? "java\\.exe" : "java"), (File)new File(sdkPath));
                File javaBinary = (File)ContainerUtil.getFirstItem((List)javaFiles);
                if (javaBinary != null) {
                    sdkPath = javaBinary.getParentFile().getParentFile().getAbsolutePath();
                }
                return JavaSdk.getInstance().createJdk("WebSphere IBM JDK", sdkPath, false);
            }

            protected void customizeParameters(JavaParameters javaParameters) {
                if (JdkUtil.useDynamicClasspath((Project)WebSphereFullHandler.this.myServerModel.getCommonModel().getProject())) {
                    javaParameters.getVMParametersList().addProperty("idea.do.not.escape.classpath.url", Boolean.TRUE.toString());
                }
            }
        };
        Consumer profileConsumer = profile -> {
            if (this.myServerModel instanceof WebSphereRemoteModel) {
                ((WebSphereRemoteModel)this.myServerModel).parseProfile((String)profile);
            }
        };
        return new WebSphereAdminServerImpl(agentProxyFactory, this.myServerModel.getLibraries(), this.myVersion, this.getAdminServerParameters(), this.isDeploymentSupported(), (Consumer<? super String>)profileConsumer);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        for (DeploymentModel deploymentModel : this.myServerModel.getCommonModel().getDeploymentModels()) {
            this.checkDeploymentSource(deploymentModel);
            Artifact artifact = deploymentModel.getArtifact();
            if (artifact == null) continue;
            this.checkArtifactType(artifact.getArtifactType());
        }
    }

    protected void checkArtifactType(ArtifactType type) throws RuntimeConfigurationException {
        if (type instanceof WebApplicationArtifactType) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("WebSphereFullHandler.error.wars.deployment.not.supported", new Object[0]));
        }
    }

    protected void checkDeploymentSource(DeploymentModel model) throws RuntimeConfigurationException {
        if (model.getDeploymentSource() instanceof LooseApplicationDeploymentSource) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("WebSphereFullHandler.error.loose.deployment.not.supported", new Object[0]));
        }
    }

    @Override
    public String getDebugEnvVarName() {
        return "DEBUG";
    }

    protected abstract WebSphereAdminServerParameters getAdminServerParameters() throws RuntimeConfigurationException;

    protected abstract boolean isDeploymentSupported();
}

