/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.server.JavaeeServerHomeProvider;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class WebSphereLibertyFilesProvider
extends JavaeeServerHomeProvider {
    private static final Logger LOG = Logger.getInstance(JavaeeServerModel.class);
    protected static final String SERVER_CONFIG_FILE = "server.xml";
    protected static final String SERVER_ENV_FILE = "server.env";
    protected static final String WLP_USER_DIR_ENV_VAR_NAME = "WLP_USER_DIR";
    protected static final String SERVERS_DIR = "/servers";

    public WebSphereLibertyFilesProvider(ApplicationServer server) {
        super(server);
    }

    public WebSphereLibertyFilesProvider(JavaeeServerModel model) {
        super(model);
    }

    protected final File getServersDir() {
        String customLocation = System.getenv(WLP_USER_DIR_ENV_VAR_NAME);
        File serverEnv = new File(this.getPathUnderHome("etc"), SERVER_ENV_FILE);
        if (serverEnv.exists()) {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(serverEnv));
                customLocation = props.getProperty(WLP_USER_DIR_ENV_VAR_NAME);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return StringUtil.isNotEmpty((String)customLocation) ? new File(customLocation, SERVERS_DIR) : this.getPathUnderHome("usr/servers");
    }

    public File getScriptPath(String script) {
        return this.getPathUnderHome("bin/" + script);
    }

    private static File getServerConfigFile(File serverDir) {
        return new File(serverDir, SERVER_CONFIG_FILE);
    }

    public List<@NlsSafe String> getServerNames() {
        ArrayList<String> result = new ArrayList<String>();
        File[] serverDirs = this.getServersDir().listFiles(file -> file.isDirectory() && WebSphereLibertyFilesProvider.getServerConfigFile(file).exists());
        if (serverDirs != null) {
            for (File serverDir : serverDirs) {
                result.add(serverDir.getName());
            }
        }
        return result;
    }
}

