/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereNode;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfile;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebSphereCell {
    private static final Logger LOG = Logger.getInstance(WebSphereCell.class);
    public static final WebSphereCell[] EMPTY_ARRAY = new WebSphereCell[0];
    @NonNls
    private static final String ENABLED_SECURITY_ATTRIBUTE = "enabled";
    private final WebSphereProfile myProfile;
    private final File myCellDirectory;
    private final String myCellName;
    private boolean mySecurityEnabled;

    public WebSphereCell(@NotNull WebSphereProfile profile, @NotNull File cellDir, @NotNull String cellName) {
        if (profile == null) {
            WebSphereCell.$$$reportNull$$$0(0);
        }
        if (cellDir == null) {
            WebSphereCell.$$$reportNull$$$0(1);
        }
        if (cellName == null) {
            WebSphereCell.$$$reportNull$$$0(2);
        }
        this.myProfile = profile;
        this.myCellDirectory = cellDir;
        this.myCellName = cellName;
        try {
            String enabled = JDOMUtil.load((File)new File(cellDir, "security.xml")).getAttributeValue(ENABLED_SECURITY_ATTRIBUTE);
            this.mySecurityEnabled = Boolean.parseBoolean(enabled);
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public File getCellDirectory() {
        return this.myCellDirectory;
    }

    public WebSphereProfile getProfile() {
        return this.myProfile;
    }

    public String getCellName() {
        return this.myCellName;
    }

    public WebSphereNode[] getNodes() {
        return WebSphereProfileUtil.getNodes(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSphereCell that = (WebSphereCell)o;
        return this.myCellDirectory.equals(that.myCellDirectory) && this.myProfile.equals(that.myProfile);
    }

    public int hashCode() {
        int result = this.myProfile.hashCode();
        result = 29 * result + this.myCellDirectory.hashCode();
        return result;
    }

    public String toString() {
        return this.myCellName;
    }

    public boolean isSecurityEnabled() {
        return this.mySecurityEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "profile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "cellDir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "cellName";
                break;
            }
        }
        objectArray[1] = "com/intellij/j2ee/webSphere/configuration/WebSphereCell";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

