/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.nodejs.cli;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.js.KotlinJSRunConfigurationDataProvider;
import org.jetbrains.kotlin.idea.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.nodejs.cli.KotlinNodeJsRunConfigurationProducer;
import org.jetbrains.kotlin.idea.nodejs.cli.NodeJsConfigData;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\nH\u0016J&\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0014R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\t\u001a\u00020\u0007*\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/nodejs/cli/KotlinNodeJsRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lcom/jetbrains/nodejs/run/NodeJsRunConfiguration;", "Lorg/jetbrains/kotlin/idea/js/KotlinJSRunConfigurationDataProvider;", "Lorg/jetbrains/kotlin/idea/nodejs/cli/NodeJsConfigData;", "()V", "isForTests", "", "()Z", "isAcceptable", "Lcom/intellij/execution/actions/ConfigurationContext;", "(Lcom/intellij/execution/actions/ConfigurationContext;)Z", "getConfigurationData", "context", "isConfigurationFromContext", "configuration", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "kotlin-ultimate.ultimate"})
final class KotlinNodeJsRunConfigurationProducer
extends RunConfigurationProducer<NodeJsRunConfiguration>
implements KotlinJSRunConfigurationDataProvider<NodeJsConfigData> {
    private final boolean isAcceptable(ConfigurationContext $this$isAcceptable) {
        ConfigurationContext configurationContext = $this$isAcceptable;
        RunConfiguration original = configurationContext != null ? configurationContext.getOriginalConfiguration(null) : null;
        return original == null || original instanceof NodeJsRunConfiguration;
    }

    public boolean isForTests() {
        return false;
    }

    @Nullable
    public NodeJsConfigData getConfigurationData(@NotNull ConfigurationContext context) {
        MainFunctionDetector detector2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.isAcceptable(context)) {
            return null;
        }
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"context.psiLocation ?: return null");
        PsiElement element = psiElement;
        Module module = context.getModule();
        if (module == null || (module = JsUtilsKt.asJsModule((Module)module)) == null) {
            return null;
        }
        Module module2 = module;
        if (MultiplatformUtilKt.isNewMPPModule((Module)module2)) {
            return null;
        }
        String string = JsUtilsKt.getJsProductionOutputFilePath((Module)module2);
        if (string == null) {
            return null;
        }
        String jsFilePath = string;
        PsiElement $this$getNonStrictParentOfType$iv = element;
        boolean $i$f$getNonStrictParentOfType = false;
        KtNamedDeclaration declaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtNamedDeclaration.class, (boolean)false);
        if (declaration instanceof KtNamedFunction ? !MainFunctionDetector.isMain$default((MainFunctionDetector)(detector2 = new MainFunctionDetector(PlatformKt.getLanguageVersionSettings((PsiElement)((PsiElement)declaration)), (Function1)getConfigurationData.detector.1.INSTANCE)), (KtNamedFunction)((KtNamedFunction)declaration), (boolean)false, (boolean)false, (int)4, null) : !TestElementPath.Companion.isModuleAssociatedDir(element, module2)) {
            return null;
        }
        return new NodeJsConfigData(element, module2, jsFilePath);
    }

    protected boolean setupConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = (PsiElement)sourceElement.get();
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        NodeJsConfigData nodeJsConfigData = this.getConfigurationData(context);
        if (nodeJsConfigData == null) {
            return false;
        }
        NodeJsConfigData configData = nodeJsConfigData;
        CharSequence charSequence = configuration.getWorkingDirectory();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            Project project = psiElement2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiElement.project");
            VirtualFile virtualFile = project.getBaseDir();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"psiElement.project.baseDir");
            configuration.setWorkingDirectory(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
        }
        configuration.setInputPath(configData.getJsOutputFilePath());
        configuration.setEnvs(NodeJsUtilKt.getNodeJsEnvironmentVars(configData.getModule(), false).getEnvs());
        configuration.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)((RunConfiguration)configuration));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull NodeJsRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NodeJsConfigData nodeJsConfigData = this.getConfigurationData(context);
        if (nodeJsConfigData == null) {
            return false;
        }
        NodeJsConfigData configData = nodeJsConfigData;
        return Intrinsics.areEqual((Object)configuration.getInputPath(), (Object)configData.getJsOutputFilePath());
    }

    public KotlinNodeJsRunConfigurationProducer() {
        NodeJsRunConfigurationType nodeJsRunConfigurationType = NodeJsRunConfigurationType.Companion.getInstance();
        if (nodeJsRunConfigurationType == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.execution.configurations.ConfigurationType");
        }
        super((ConfigurationType)nodeJsRunConfigurationType);
    }
}

