/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.util;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.EqTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;

public final class MvcTargetDialogCompletionUtils {
    private MvcTargetDialogCompletionUtils() {
    }

    public static List<LookupElement> completeClassesAndPackages(@NotNull String prefix, @NotNull GlobalSearchScope scope) {
        PsiPackage defaultPackage;
        PsiPackage p;
        if (prefix == null) {
            MvcTargetDialogCompletionUtils.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            MvcTargetDialogCompletionUtils.$$$reportNull$$$0(1);
        }
        if (scope.getProject() == null) {
            return Collections.emptyList();
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)scope.getProject());
        ArrayList<LookupElement> res = new ArrayList<LookupElement>();
        if (prefix.endsWith(".") && prefix.length() > 1 && (p = facade.findPackage(prefix.substring(0, prefix.length() - 1))) != null) {
            for (PsiClass aClass : p.getClasses(scope)) {
                String qualifiedName = aClass.getQualifiedName();
                if (qualifiedName == null) continue;
                res.add((LookupElement)LookupElementBuilder.create((Object)aClass, (String)qualifiedName));
            }
        }
        if ((defaultPackage = facade.findPackage("")) != null) {
            MvcTargetDialogCompletionUtils.collectClassesAndPackageNames(res, defaultPackage, scope);
        }
        return res;
    }

    private static void collectClassesAndPackageNames(Collection<? super LookupElement> res, @NotNull PsiPackage aPackage, GlobalSearchScope scope) {
        if (aPackage == null) {
            MvcTargetDialogCompletionUtils.$$$reportNull$$$0(2);
        }
        PsiPackage[] subPackages = aPackage.getSubPackages(scope);
        String qualifiedName = aPackage.getQualifiedName();
        if (!(qualifiedName.isEmpty() || subPackages.length != 0 && aPackage.getClasses(scope).length <= 0)) {
            res.add((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)qualifiedName), (TailType)TailType.DOT));
        }
        for (PsiPackage subPackage : subPackages) {
            MvcTargetDialogCompletionUtils.collectClassesAndPackageNames(res, subPackage, scope);
        }
    }

    public static Set<String> getAllTargetNamesInternal(@NotNull Module module) {
        if (module == null) {
            MvcTargetDialogCompletionUtils.$$$reportNull$$$0(3);
        }
        HashSet<String> result2 = new HashSet<String>();
        GrailsFramework.addAvailableSystemScripts(result2, module);
        GrailsFramework framework = GrailsFramework.getInstance(module);
        if (framework != null) {
            VirtualFile root = framework.findAppRoot(module);
            if (root != null) {
                GrailsFramework.addAvailableScripts(result2, root);
            }
            for (VirtualFile pluginRoot : framework.getAllPluginRoots(module, false)) {
                GrailsFramework.addAvailableScripts(result2, pluginRoot);
            }
        }
        MvcTargetDialogCompletionUtils.collectScriptsFromUserHome(result2);
        return result2;
    }

    private static void collectScriptsFromUserHome(Set<? super String> result2) {
        String userHome = SystemProperties.getUserHome();
        if (userHome == null) {
            return;
        }
        File scriptFolder = new File(userHome, ".grails/scripts");
        File[] files = scriptFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.getName().startsWith("IdeaPrintProjectSettings") || !MvcTargetDialogCompletionUtils.isScriptFile(file)) continue;
            String name = file.getName();
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                name = name.substring(0, idx);
            }
            result2.add(GroovyNamesUtil.camelToSnake((String)name));
        }
    }

    public static boolean isScriptFile(File file) {
        return file.isFile() && GrailsFramework.isScriptFileName(file.getName());
    }

    public static Set<String> getAllTargetNames(@NotNull Module module) {
        if (module == null) {
            MvcTargetDialogCompletionUtils.$$$reportNull$$$0(4);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(MvcTargetDialogCompletionUtils.getAllTargetNamesInternal(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/util/MvcTargetDialogCompletionUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "completeClassesAndPackages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectClassesAndPackageNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllTargetNamesInternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllTargetNames";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyTailTypeEQ
    extends EqTailType {
        public static final MyTailTypeEQ INSTANCE = new MyTailTypeEQ();

        protected boolean isSpaceAroundAssignmentOperators(Editor editor, int tailOffset) {
            return false;
        }

        public String toString() {
            return "MvcTargetDialogCompletionUtils.TailTypeEQ";
        }
    }
}

