/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;

public final class MvcPluginUtil {
    private static final Logger LOG = Logger.getInstance(MvcPluginUtil.class);
    private static final String SET_PROXY_COMMAND = "set-proxy";
    private static final String ENTER_HTTP_PROXY_HOST = "Enter HTTP proxy host";
    private static final String ENTER_HTTP_PROXY_PORT = "Enter HTTP proxy port";
    private static final String ENTER_HTTP_PROXY_USERNAME = "Enter HTTP proxy username";
    private static final String ENTER_HTTP_PROXY_PASSWORD = "Enter HTTP proxy password";
    public static final Supplier<Color> COLOR_REMOVE_PLUGIN = () -> FileStatus.DELETED_FROM_FS.getColor();
    public static final Supplier<Color> COLOR_INSTALL_PLUGIN = () -> FileStatus.ADDED.getColor();
    @NonNls
    public static final String LIST_PLUGINS_COMMAND = "list-plugins";
    private static final Key<Pair<Collection<MvcPluginDescriptor>, Long>> PLUGIN_DESCRIPTOR_KEY = Key.create((String)"MVC_PLUGIN_DESCRIPTOR_KEY");
    public static final Key<Boolean> PLUGIN_LIST_DONOT_DOWNLOADED = Key.create((String)"PLUGIN_LIST_DONOT_DOWNLOADED");

    private MvcPluginUtil() {
    }

    private static void setProxyOld(final @NotNull HttpConfigurable cfg, @NotNull OldGrailsApplication application) {
        if (cfg == null) {
            MvcPluginUtil.$$$reportNull$$$0(0);
        }
        if (application == null) {
            MvcPluginUtil.$$$reportNull$$$0(1);
        }
        try {
            GrailsCommandExecutor executor = GrailsCommandExecutor.getGrailsExecutor(application);
            if (!(executor instanceof GrailsCommandLineExecutor)) {
                return;
            }
            GeneralCommandLine commandLine = ((GrailsCommandLineExecutor)executor).createCommandLine(application, new MvcCommand(SET_PROXY_COMMAND, new String[0]));
            OSProcessHandler handler = new OSProcessHandler(commandLine);
            GrailsConsole.getInstance(application.getProject()).getConsole().attachToProcess((ProcessHandler)handler);
            final OutputStreamWriter writer = new OutputStreamWriter(handler.getProcess().getOutputStream(), StandardCharsets.UTF_8);
            writer.write(cfg.USE_HTTP_PROXY ? "y\n" : "n\n");
            writer.flush();
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    String text = event.getText();
                    try {
                        if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_HOST)) {
                            writer.append(cfg.PROXY_HOST).append('\n');
                        } else if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_PORT)) {
                            writer.write(cfg.PROXY_PORT);
                            writer.write(10);
                        } else if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_USERNAME)) {
                            writer.append(cfg.getProxyLogin()).append('\n');
                        } else if (text.contains(MvcPluginUtil.ENTER_HTTP_PROXY_PASSWORD)) {
                            writer.append(cfg.getPlainProxyPassword()).append('\n');
                        }
                        writer.flush();
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            handler.startNotify();
        }
        catch (Exception e) {
            GrailsConsole.NOTIFICATION_GROUP.createNotification(GrailsBundle.message("mvc.plugins.notification.title.process.cannot.start.set.proxy.process", new Object[0]), e.getMessage(), NotificationType.ERROR).notify(application.getProject());
            LOG.debug((Throwable)e);
        }
    }

    private static void setProxyNew(@NotNull HttpConfigurable cfg, @NotNull OldGrailsApplication application) {
        if (cfg == null) {
            MvcPluginUtil.$$$reportNull$$$0(2);
        }
        if (application == null) {
            MvcPluginUtil.$$$reportNull$$$0(3);
        }
        if (cfg.USE_HTTP_PROXY) {
            MvcCommand command = new MvcCommand("add-proxy", "IDEA_PROXY", "--host=" + cfg.PROXY_HOST, "--port=" + cfg.PROXY_PORT, "--username=" + cfg.getProxyLogin(), "--password=" + cfg.getPlainProxyPassword());
            GrailsCommandExecutorUtil.executeInModal(application, command, GrailsBundle.message("progress.text.execute.add.proxy.command", new Object[0]), () -> GrailsCommandExecutorUtil.executeInModal(application, new MvcCommand("set-proxytitle", "IDEA_PROXY"), GrailsBundle.message("progress.text.execute.set.proxy.command", new Object[0]), null, false), false);
        } else {
            GrailsCommandExecutorUtil.executeInModal(application, new MvcCommand("clear-proxy", new String[0]), GrailsBundle.message("progress.text.execute.clear.proxy.command", new Object[0]), null, false);
        }
    }

    public static void setFrameworkProxy(@NotNull HttpConfigurable cfg, @NotNull OldGrailsApplication application) {
        if (cfg == null) {
            MvcPluginUtil.$$$reportNull$$$0(4);
        }
        if (application == null) {
            MvcPluginUtil.$$$reportNull$$$0(5);
        }
        assert (!GrailsConsole.getInstance(application.getProject()).isExecuting());
        if (application.getGrailsVersion().isAtLeast("1.3.2")) {
            MvcPluginUtil.setProxyNew(cfg, application);
        } else {
            MvcPluginUtil.setProxyOld(cfg, application);
        }
    }

    public static String cleanPath(String path) {
        String pluginFilePath = path;
        if (path.endsWith("!/")) {
            pluginFilePath = path.substring(0, path.length() - "!/".length());
        } else if (path.endsWith("!")) {
            pluginFilePath = path.substring(0, path.length() - "!".length());
        }
        return pluginFilePath;
    }

    @NotNull
    public static List<MvcPluginDescriptor> refreshAndLoadPluginList(@NotNull OldGrailsApplication application) {
        if (application == null) {
            MvcPluginUtil.$$$reportNull$$$0(6);
        }
        VirtualFile sdkWorkDir = MvcModuleStructureUtil.refreshAndFind(GrailsFramework.getInstance().getSdkWorkDir(application.getModule()));
        ArrayList<MvcPluginDescriptor> res = new ArrayList<MvcPluginDescriptor>();
        if (sdkWorkDir == null) {
            LOG.warn("Grails/Griffon work directory not found.");
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                MvcPluginUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (!sdkWorkDir.isDirectory()) {
            LOG.warn("Failed to load plugin list: Grails/Griffon work directory is not a directory (" + sdkWorkDir.getPath() + ")");
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                MvcPluginUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        sdkWorkDir.refresh(false, false);
        boolean pluginListExists = false;
        for (VirtualFile file : sdkWorkDir.getChildren()) {
            if (!MvcPluginUtil.isPluginListFile(file)) continue;
            res.addAll(MvcPluginUtil.getPluginList(file));
            pluginListExists = true;
        }
        PLUGIN_LIST_DONOT_DOWNLOADED.set((UserDataHolder)application, (Object)(pluginListExists ? null : Boolean.valueOf(true)));
        ArrayList<MvcPluginDescriptor> arrayList = res;
        if (arrayList == null) {
            MvcPluginUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static boolean isPluginListFile(VirtualFile file) {
        return !file.isDirectory() && file.getName().startsWith("plugins-list") && file.getName().endsWith(".xml");
    }

    @NotNull
    public static List<MvcPluginDescriptor> loadPluginList(@NotNull Module module) {
        GrailsFramework framework;
        if (module == null) {
            MvcPluginUtil.$$$reportNull$$$0(10);
        }
        if ((framework = GrailsFramework.getInstance(module)) == null) {
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                MvcPluginUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        File dir = framework.getSdkWorkDir(module);
        if (dir == null) {
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                MvcPluginUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        VirtualFile sdkWorkDir = LocalFileSystem.getInstance().findFileByIoFile(dir);
        if (sdkWorkDir == null || !sdkWorkDir.isDirectory()) {
            List<MvcPluginDescriptor> list = Collections.emptyList();
            if (list == null) {
                MvcPluginUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList<MvcPluginDescriptor> res = new ArrayList<MvcPluginDescriptor>();
        sdkWorkDir.refresh(true, false);
        for (VirtualFile file : sdkWorkDir.getChildren()) {
            if (!MvcPluginUtil.isPluginListFile(file)) continue;
            res.addAll(MvcPluginUtil.getPluginList(file));
        }
        ArrayList<MvcPluginDescriptor> arrayList = res;
        if (arrayList == null) {
            MvcPluginUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<MvcPluginDescriptor> parsePluginList(VirtualFile file) {
        ArrayList<MvcPluginDescriptor> res = new ArrayList<MvcPluginDescriptor>();
        InputStream in = null;
        try {
            in = file.getInputStream();
            Document document = new SAXBuilder().build(in);
            Element root = document.getRootElement();
            for (Element pluginElement : root.getChildren("plugin")) {
                MvcPluginDescriptor.Release latestRelease;
                MvcPluginDescriptor plugin;
                block17: {
                    String latestVersion;
                    block16: {
                        String name = pluginElement.getAttributeValue("name");
                        if (name == null) continue;
                        plugin = new MvcPluginDescriptor(name);
                        if (!StringUtil.isNotEmpty((String)name)) continue;
                        latestVersion = pluginElement.getAttributeValue("latest-release");
                        for (Element releaseElement : pluginElement.getChildren("release")) {
                            MvcPluginDescriptor.Release release = new MvcPluginDescriptor.Release(plugin, releaseElement.getAttributeValue("version"), releaseElement.getAttributeValue("type"), releaseElement.getChildTextTrim("title"), releaseElement.getChildTextTrim("author"), releaseElement.getChildTextTrim("description"), releaseElement.getChildTextTrim("authorEmail"), releaseElement.getChildTextTrim("file"), releaseElement.getChildTextTrim("documentation"));
                            plugin.getReleases().add(release);
                        }
                        latestRelease = null;
                        if (!StringUtil.isEmpty((String)latestVersion)) break block16;
                        if (plugin.getReleases().size() <= 0) break block17;
                        latestRelease = plugin.getReleases().get(plugin.getReleases().size() - 1);
                        break block17;
                    }
                    for (MvcPluginDescriptor.Release release : plugin.getReleases()) {
                        if (!latestVersion.equals(release.getVersion())) continue;
                        latestRelease = release;
                        break;
                    }
                }
                plugin.setLastRelease(latestRelease);
                res.add(plugin);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to read plugins file:" + file.getPath(), (Throwable)e);
            Notifications.Bus.notify((Notification)new Notification("grails", GrailsBundle.message("mvc.plugins.notification.title.failed.to.load.plugin.list", new Object[0]), GrailsBundle.message("mvc.plugins.notification.content.failed.to.parse", file.getPath()), NotificationType.ERROR));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return res;
    }

    public static Collection<MvcPluginDescriptor> getPluginList(VirtualFile file) {
        Pair cachedValue = (Pair)file.getUserData(PLUGIN_DESCRIPTOR_KEY);
        if (cachedValue == null || ((Long)cachedValue.second).longValue() != file.getModificationCount()) {
            Collection<MvcPluginDescriptor> res = MvcPluginUtil.parsePluginList(file);
            cachedValue = Pair.create(res, (Object)file.getModificationCount());
            file.putUserData(PLUGIN_DESCRIPTOR_KEY, (Object)cachedValue);
        }
        return (Collection)cachedValue.first;
    }

    @Nullable
    public static MvcPluginDescriptor parsePluginXml(VirtualFile file) {
        try {
            return MvcPluginUtil.parsePluginXml(file.getInputStream());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static MvcPluginDescriptor parsePluginXml(InputStream inputStream) throws IOException {
        Element root;
        try {
            Document document = new SAXBuilder().build(inputStream);
            root = document.getRootElement();
        }
        catch (JDOMException e) {
            return null;
        }
        String name = root.getAttributeValue("name");
        if (StringUtil.isEmpty((String)name)) {
            throw new IOException("Name of plugin cannot be null.");
        }
        String version = root.getAttributeValue("version");
        MvcPluginDescriptor mvcPlugin = new MvcPluginDescriptor(name);
        MvcPluginDescriptor.Release release = new MvcPluginDescriptor.Release(mvcPlugin, version, "", root.getChildTextTrim("title"), root.getChildTextTrim("author"), root.getChildTextTrim("description"), root.getChildTextTrim("authorEmail"), root.getChildTextTrim("file"), root.getChildTextTrim("documentation"));
        mvcPlugin.getReleases().add(release);
        mvcPlugin.setLastRelease(release);
        return mvcPlugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static MvcPluginDescriptor extractPluginInfo(@NotNull String path) {
        if (path == null) {
            MvcPluginUtil.$$$reportNull$$$0(15);
        }
        try (ZipFile zipFile = new ZipFile(path);){
            ZipEntry entry = zipFile.getEntry("plugin.xml");
            if (entry == null) return null;
            MvcPluginDescriptor mvcPluginDescriptor = MvcPluginUtil.parsePluginXml(zipFile.getInputStream(entry));
            return mvcPluginDescriptor;
        }
        catch (IOException e) {
            LOG.error(path, (Throwable)e);
        }
        return null;
    }

    public static Map<String, String> getInstalledPluginVersions(@NotNull PropertiesFile applicationProperties) {
        if (applicationProperties == null) {
            MvcPluginUtil.$$$reportNull$$$0(16);
        }
        HashMap<String, String> pluginNames = new HashMap<String, String>();
        for (IProperty property : applicationProperties.getProperties()) {
            String propName = property.getName();
            if (propName == null || !(propName = propName.trim()).startsWith("plugins.")) continue;
            String pluginName = propName.substring("plugins.".length());
            String pluginVersion = property.getValue();
            if (pluginName.length() <= 0 || pluginVersion == null || (pluginVersion = pluginVersion.trim()).length() <= 0) continue;
            pluginNames.put(pluginName, pluginVersion);
        }
        return pluginNames;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/plugins/MvcPluginUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndLoadPluginList";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPluginList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setProxyOld";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProxyNew";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkProxy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndLoadPluginList";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadPluginList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "extractPluginInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledPluginVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

