/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.plugins;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginDescriptor;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;

public class InstallUninstallPluginsDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(InstallUninstallPluginsDialog.class);
    private final JPanel myMainPanel;
    @NonNls
    private static final String INSTALL_PLUGIN = "install-plugin";
    @NonNls
    private static final String UNINSTALL_PLUGIN = "uninstall-plugin";
    @NotNull
    private final OldGrailsApplication myApplication;
    private JPanel myInstallPluginsPanel;
    private JPanel myRemovePluginsPanel;
    private final Map<MvcPluginDescriptor, JComboBox> myVersionsMap;
    private final Collection<MvcPluginDescriptor> myToRemovePlugins;
    private final Collection<MvcPluginDescriptor> myToInstallCustomPlugins;
    private final Collection<MvcPluginDescriptor> myToInstallServerPlugins;
    private final Map<MvcPluginDescriptor, String> myPluginToPath;

    public InstallUninstallPluginsDialog(Collection<MvcPluginDescriptor> toInstallServerPlugins, Collection<MvcPluginDescriptor> toInstallCustomPlugins, Collection<MvcPluginDescriptor> toRemovePlugins, @NotNull OldGrailsApplication application, Map<MvcPluginDescriptor, String> pluginToPath) {
        if (application == null) {
            InstallUninstallPluginsDialog.$$$reportNull$$$0(0);
        }
        super(application.getProject(), false);
        this.myToInstallServerPlugins = toInstallServerPlugins;
        this.myToInstallCustomPlugins = toInstallCustomPlugins;
        this.myToRemovePlugins = toRemovePlugins;
        this.myApplication = application;
        this.setTitle(GrailsBundle.message("install.uninstall.plugins.dialog.title", new Object[0]));
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout(new BorderLayout());
        this.myVersionsMap = new HashMap<MvcPluginDescriptor, JComboBox>();
        if (this.myToRemovePlugins.size() > 0) {
            this.myRemovePluginsPanel = new JPanel(new GridLayout(-1, 1));
            this.configureRemovePanel(toRemovePlugins);
            this.myMainPanel.add((Component)this.myRemovePluginsPanel, "North");
        }
        this.myMainPanel.add((Component)new JLabel(" "), "Center");
        if (this.myToInstallServerPlugins.size() > 0 || this.myToInstallCustomPlugins.size() > 0) {
            this.myInstallPluginsPanel = new JPanel(new BorderLayout());
            this.configureInstallPanel();
            this.myMainPanel.add((Component)this.myInstallPluginsPanel, "South");
        }
        this.init();
        this.myPluginToPath = pluginToPath;
    }

    private void configureRemovePanel(Collection<MvcPluginDescriptor> toRemovePlugins) {
        JLabel textLabel = new JLabel();
        textLabel.setText(GrailsBundle.message("install.uninstall.plugins.dialog.to.remove", new Object[0]));
        this.myRemovePluginsPanel.add(textLabel);
        for (MvcPluginDescriptor toRemovePlugin : toRemovePlugins) {
            JLabel pluginLabel = InstallUninstallPluginsDialog.createBoldLabel();
            pluginLabel.setForeground(MvcPluginUtil.COLOR_REMOVE_PLUGIN.get());
            pluginLabel.setText(toRemovePlugin.getName());
            this.myRemovePluginsPanel.add(pluginLabel);
        }
    }

    private void configureInstallPanel() {
        JLabel label = new JLabel();
        label.setText(GrailsBundle.message("install.uninstall.plugins.dialog.to.install", new Object[0]));
        this.myInstallPluginsPanel.add((Component)label, "North");
        JPanel versionsPanel = new JPanel(new GridLayout(-1, 2));
        ArrayList<MvcPluginDescriptor> allPlugins = new ArrayList<MvcPluginDescriptor>(this.myToInstallCustomPlugins.size() + this.myToInstallServerPlugins.size());
        allPlugins.addAll(this.myToInstallCustomPlugins);
        allPlugins.addAll(this.myToInstallServerPlugins);
        for (MvcPluginDescriptor toInstallPlugin : allPlugins) {
            JLabel pluginNameLabel = InstallUninstallPluginsDialog.createBoldLabel();
            pluginNameLabel.setForeground(MvcPluginUtil.COLOR_INSTALL_PLUGIN.get());
            pluginNameLabel.setText(toInstallPlugin.getName());
            versionsPanel.add(pluginNameLabel);
            JComponent component = InstallUninstallPluginsDialog.createVersionsComponent(toInstallPlugin);
            if (component instanceof JComboBox) {
                this.myVersionsMap.put(toInstallPlugin, (JComboBox)component);
            }
            versionsPanel.add(component);
        }
        this.myInstallPluginsPanel.add((Component)versionsPanel, "Center");
    }

    private static JLabel createBoldLabel() {
        JLabel label = new JLabel();
        Font f = label.getFont();
        label.setFont(f.deriveFont(f.getStyle() | 1));
        return label;
    }

    private static JComponent createVersionsComponent(MvcPluginDescriptor mvcPlugin) {
        ComboBox comboBox = new ComboBox();
        List<MvcPluginDescriptor.Release> versions = mvcPlugin.getReleases();
        if (versions.size() == 0) {
            JLabel label2 = new JLabel();
            label2.setForeground((Color)JBColor.RED);
            label2.setText(GrailsBundle.message("install.uninstall.plugins.dialog.no.version", new Object[0]));
            return label2;
        }
        for (MvcPluginDescriptor.Release version : versions) {
            comboBox.addItem(version);
        }
        comboBox.setSelectedItem(mvcPlugin.getLastRelease());
        comboBox.setRenderer(SimpleListCellRenderer.create((label, value, index) -> {
            if ("zip".equals(value.getType())) {
                label.setText(GrailsBundle.message("install.uninstall.plugins.dialog.zip.release.version", value.getVersion()));
            } else if (value == value.getPlugin().getLastRelease()) {
                label.setText(GrailsBundle.message("install.uninstall.plugins.dialog.latest.version", value.getVersion()));
            } else {
                label.setText(value.getVersion());
            }
        }));
        return comboBox;
    }

    public void doInstallRemove() {
        this.deletePlugins();
        this.installCustomPlugins();
        for (MvcPluginDescriptor plugin : this.myToInstallServerPlugins) {
            MvcCommand mvcCommand = new MvcCommand(INSTALL_PLUGIN, plugin.getName(), this.getPluginVersion(plugin));
            GrailsCommandExecutorUtil.execute(this.myApplication, mvcCommand, null, false, new String[0]);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private void installCustomPlugins() {
        ArrayList tempPluginPaths = new ArrayList();
        for (MvcPluginDescriptor mvcPlugin : this.myToInstallCustomPlugins) {
            String pluginPath = MvcPluginUtil.cleanPath(this.myPluginToPath.get(mvcPlugin));
            VirtualFile pluginVirtualFile = VirtualFileManager.getInstance().findFileByUrl("file://" + pluginPath);
            assert (pluginVirtualFile != null);
            VirtualFile appDirVirtualFile = this.myApplication.getRoot();
            try {
                WriteAction.run(() -> tempPluginPaths.add(VfsUtilCore.copyFile((Object)((Object)this), (VirtualFile)pluginVirtualFile, (VirtualFile)appDirVirtualFile)));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        for (VirtualFile tempPluginPath : tempPluginPaths) {
            MvcCommand mvcCommand = new MvcCommand(INSTALL_PLUGIN, tempPluginPath.getName());
            GrailsCommandExecutorUtil.execute(this.myApplication, mvcCommand, () -> {
                try {
                    WriteAction.run(() -> LocalFileSystem.getInstance().deleteFile((Object)this, tempPluginPath));
                }
                catch (IOException e) {
                    LOG.error("Cannot delete file " + tempPluginPath.getPath(), (Throwable)e);
                }
            }, false, new String[0]);
        }
    }

    private String getPluginVersion(MvcPluginDescriptor plugin) {
        JComboBox versionComponent = this.myVersionsMap.get(plugin);
        if (versionComponent != null) {
            return ((MvcPluginDescriptor.Release)versionComponent.getSelectedItem()).getVersion();
        }
        return "'";
    }

    private void deletePlugins() {
        if (this.myApplication.getGrailsVersion().isAtLeast(Version.GRAILS_1_1)) {
            for (MvcPluginDescriptor plugin : this.myToRemovePlugins) {
                MvcCommand mvcCommand = new MvcCommand(UNINSTALL_PLUGIN, plugin.getName());
                GrailsCommandExecutorUtil.execute(this.myApplication, mvcCommand, null, false, new String[0]);
            }
        } else {
            Project project = this.myApplication.getProject();
            try {
                WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                    PropertiesFile properties = this.myApplication.getApplicationProperties();
                    if (properties == null) {
                        return;
                    }
                    Collection<VirtualFile> allDirs = GrailsFramework.getInstance().getCommonPluginRoots(this.myApplication.getModule(), true);
                    VirtualFile propVFile = properties.getVirtualFile();
                    Document propDocument = PsiDocumentManager.getInstance((Project)project).getDocument(properties.getContainingFile());
                    propVFile.refresh(false, false);
                    if (propDocument != null) {
                        PsiDocumentManager.getInstance((Project)project).commitDocument(propDocument);
                    }
                    for (MvcPluginDescriptor plugin : this.myToRemovePlugins) {
                        VirtualFile pluginDir = (VirtualFile)ContainerUtil.find(allDirs, file -> plugin.getName().equals(file.getName()));
                        if (pluginDir != null) {
                            pluginDir.delete((Object)this);
                        }
                        for (IProperty property : properties.findPropertiesByKey("plugins." + plugin.getName())) {
                            property.getPsiElement().delete();
                        }
                    }
                    if (propDocument != null) {
                        FileDocumentManager.getInstance().saveDocument(propDocument);
                    }
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "application", "org/jetbrains/plugins/groovy/mvc/plugins/InstallUninstallPluginsDialog", "<init>"));
    }
}

