/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MvcCommand {
    public static final Collection<String> ourEnvironments = ContainerUtil.immutableList((Object[])new String[]{"prod", "test", "dev"});
    private final Map<String, String> myEnvVariables = new HashMap<String, String>();
    private boolean myPassParentEnvs = true;
    @Nullable
    private String myEnv;
    @Nullable
    private String myCommand;
    @Nullable
    private String myVmOptions;
    private final ArrayList<String> myArgs = new ArrayList();
    private final ArrayList<String> myProperties = new ArrayList();

    public MvcCommand() {
    }

    public MvcCommand(@Nullable String command, String ... args) {
        this.myCommand = command;
        Collections.addAll(this.myArgs, args);
    }

    @Nullable
    public String getEnv() {
        return this.myEnv;
    }

    public void setEnv(@Nullable String env) {
        this.myEnv = env;
    }

    @Nullable
    public String getCommand() {
        return this.myCommand;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public MvcCommand setVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
        return this;
    }

    @NotNull
    public Map<String, String> getEnvVariables() {
        Map<String, String> map2 = this.myEnvVariables;
        if (map2 == null) {
            MvcCommand.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public MvcCommand setEnvVariables(@NotNull Map<String, String> envVariables) {
        if (envVariables == null) {
            MvcCommand.$$$reportNull$$$0(1);
        }
        if (this.myEnvVariables != envVariables) {
            this.myEnvVariables.clear();
            this.myEnvVariables.putAll(envVariables);
        }
        return this;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public MvcCommand setPassParentEnvs(boolean passParentEnv) {
        this.myPassParentEnvs = passParentEnv;
        return this;
    }

    public ArrayList<String> getArgs() {
        return this.myArgs;
    }

    public void setArgs(@NotNull List<String> args) {
        if (args == null) {
            MvcCommand.$$$reportNull$$$0(2);
        }
        if (args == this.myArgs) {
            return;
        }
        this.myArgs.clear();
        this.myArgs.addAll(args);
    }

    public ArrayList<String> getProperties() {
        return this.myProperties;
    }

    public void setProperties(@NotNull List<String> properties) {
        if (properties == null) {
            MvcCommand.$$$reportNull$$$0(3);
        }
        if (this.myProperties == properties) {
            return;
        }
        this.myProperties.clear();
        this.myProperties.addAll(properties);
    }

    public void addToParametersList(@NotNull ParametersList list) {
        if (list == null) {
            MvcCommand.$$$reportNull$$$0(4);
        }
        if (this.myEnv != null) {
            list.add(this.myEnv);
        }
        list.addAll(this.myProperties);
        if (this.myCommand != null) {
            list.add(this.myCommand);
        }
        list.addAll(this.myArgs);
    }

    @NotNull
    public static MvcCommand parse(@NotNull String cmd) {
        int i2;
        if (cmd == null) {
            MvcCommand.$$$reportNull$$$0(5);
        }
        String[] args = ParametersList.parse((String)cmd);
        MvcCommand res = new MvcCommand();
        for (i2 = 0; res.myCommand == null && i2 < args.length; ++i2) {
            String s2 = args[i2];
            if (s2.startsWith("-D")) {
                res.myProperties.add(s2);
                continue;
            }
            if (res.myEnv == null && ourEnvironments.contains(s2)) {
                res.myEnv = s2;
                continue;
            }
            res.myCommand = s2;
        }
        res.myArgs.addAll(Arrays.asList(args).subList(i2, args.length));
        MvcCommand mvcCommand = res;
        if (mvcCommand == null) {
            MvcCommand.$$$reportNull$$$0(6);
        }
        return mvcCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/mvc/MvcCommand";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVariables";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvVariables";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/mvc/MvcCommand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setEnvVariables";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setArgs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addToParametersList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

