/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.grails.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.references.constraints.GrailsConstraintsUtil;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrailsDomainAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            GrailsDomainAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            GrailsDomainAnnotator.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof GroovyFile)) {
            return;
        }
        for (GrTypeDefinition grTypeDefinition : ((GroovyFile)psiElement).getTypeDefinitions()) {
            if (!GormUtils.isGormBean((PsiClass)grTypeDefinition)) continue;
            GrailsDomainAnnotator.checkBelongsToAndHasManyRelations((PsiClass)grTypeDefinition, holder);
            GrailsDomainAnnotator.checkMappedBy((PsiClass)grTypeDefinition, holder);
            GrailsDomainAnnotator.checkConstraints(grTypeDefinition, holder);
        }
    }

    private static void checkConstraints(GrTypeDefinition domainClass, final AnnotationHolder holder) {
        GrField constraintsField = (GrField)domainClass.findFieldByName("constraints", false);
        if (constraintsField == null) {
            return;
        }
        GrExpression initializerGroovy = constraintsField.getInitializerGroovy();
        if (!(initializerGroovy instanceof GrClosableBlock)) {
            return;
        }
        final Map<String, Pair<PsiType, PsiElement>> fields = DomainDescriptor.getDescriptor((PsiClass)domainClass).getPersistentProperties();
        final HashMap constraints = new HashMap();
        initializerGroovy.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                PsiMethod method;
                if (methodCallExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (GrailsConstraintsUtil.isConstraintsMethod((PsiElement)(method = methodCallExpression.resolveMethod()))) {
                    assert (method != null);
                    String fieldName = method.getName();
                    if (fields.containsKey(fieldName)) {
                        HashMap<String, GrNamedArgument> fieldConstraints = (HashMap<String, GrNamedArgument>)constraints.get(fieldName);
                        if (fieldConstraints == null) {
                            fieldConstraints = new HashMap<String, GrNamedArgument>();
                            constraints.put(fieldName, fieldConstraints);
                        }
                        for (GrNamedArgument argument : PsiUtil.getFirstMapNamedArguments((GrCall)methodCallExpression)) {
                            String constraintType = argument.getLabelName();
                            GrNamedArgument oldConstraint = fieldConstraints.put(constraintType, argument);
                            if (oldConstraint == null) continue;
                            GrArgumentLabel oldArgumentLabel = oldConstraint.getLabel();
                            assert (oldArgumentLabel != null);
                            holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("domain.annotator.error.message.already.defined", constraintType, fieldName)).range((PsiElement)oldArgumentLabel).create();
                        }
                    }
                }
                super.visitMethodCallExpression(methodCallExpression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "org/jetbrains/plugins/groovy/grails/annotator/GrailsDomainAnnotator$1", "visitMethodCallExpression"));
            }
        });
    }

    private static void checkBelongsToAndHasManyRelations(PsiClass domainClass, AnnotationHolder holder) {
        PsiField hasMany;
        Map<String, Pair<PsiType, PsiElement>> fields = DomainDescriptor.getDescriptor(domainClass).getPersistentProperties();
        PsiField belongs = domainClass.findFieldByName("belongsTo", false);
        GrListOrMap lom = GrailsDomainAnnotator.getListOrMap(belongs);
        if (lom != null) {
            if (lom.isMap()) {
                for (GrNamedArgument argument : lom.getNamedArguments()) {
                    GrailsDomainAnnotator.checkNamedArgumentForBelongsTo(argument, fields, holder);
                }
            }
            GrailsDomainAnnotator.processDuplicates(holder, lom);
        }
        if ((lom = GrailsDomainAnnotator.getListOrMap(hasMany = domainClass.findFieldByName("hasMany", false))) != null) {
            if (!lom.isMap()) {
                holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("must.contain.map", new Object[0])).range((PsiElement)lom).create();
            }
            GrailsDomainAnnotator.processDuplicates(holder, lom);
        }
    }

    private static void checkMappedBy(PsiClass domainClass, AnnotationHolder holder) {
        PsiField mappedBy = domainClass.findFieldByName("mappedBy", false);
        if (mappedBy == null || !mappedBy.hasModifierProperty("static")) {
            return;
        }
        PsiField hasMany = domainClass.findFieldByName("hasMany", false);
        if (hasMany == null || !hasMany.hasModifierProperty("static")) {
            holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("mapped.by.is.used.without.has.many", new Object[0])).range((PsiElement)mappedBy.getNameIdentifier()).create();
            return;
        }
        GrListOrMap lom = GrailsDomainAnnotator.getListOrMap(mappedBy);
        if (lom != null) {
            if (lom.isMap()) {
                HashSet<String> names = new HashSet<String>();
                Map<String, Pair<PsiType, PsiElement>> hasManyMap = DomainDescriptor.getDescriptor(domainClass).getHasMany();
                for (GrNamedArgument argument : lom.getNamedArguments()) {
                    PsiReference ref;
                    GrArgumentLabel label = argument.getLabel();
                    if (label == null) continue;
                    String name = label.getName();
                    if (names.contains(name)) {
                        holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("duplicate.property.name", new Object[0])).range((PsiElement)label).create();
                        continue;
                    }
                    names.add(name);
                    Pair<PsiType, PsiElement> pair = hasManyMap.get(name);
                    if (pair == null) {
                        holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("property.is.absent.in.has.many", name)).range((PsiElement)label).create();
                        continue;
                    }
                    GrExpression expression = argument.getExpression();
                    if (!(expression instanceof GrLiteral) || !(((GrLiteral)expression).getValue() instanceof String) || (ref = expression.getReference()) == null) continue;
                    Object value = ((GrLiteral)expression).getValue();
                    PsiElement resolved = ref.resolve();
                    if (resolved == null) {
                        holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("property.is.absent", ((PsiType)pair.first).getPresentableText(), value)).range((PsiElement)expression).create();
                        continue;
                    }
                    PsiType propertyType = DomainClassUtils.getDCPropertyType(resolved);
                    if (propertyType instanceof PsiClassType) {
                        PsiClass resolvedClass = ((PsiClassType)propertyType).resolve();
                        if (domainClass.getManager().areElementsEquivalent((PsiElement)domainClass, (PsiElement)resolvedClass)) continue;
                        holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("property.has.wrong.type", value, propertyType.getPresentableText())).range((PsiElement)expression).create();
                        continue;
                    }
                    holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("property.has.wrong.type", value, propertyType != null ? propertyType.getPresentableText() : "null")).range((PsiElement)expression).create();
                }
            } else {
                holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("must.contain.map", new Object[0])).range((PsiElement)lom).create();
            }
        }
    }

    private static void checkNamedArgumentForBelongsTo(GrNamedArgument argument, Map<String, Pair<PsiType, PsiElement>> fields, AnnotationHolder holder) {
        GrArgumentLabel label = argument.getLabel();
        if (label != null) {
            PsiClass fieldClass;
            PsiElement element;
            GrExpression expression = argument.getExpression();
            PsiClass labelClass = null;
            if (expression instanceof GrReferenceExpression && (element = ((GrReferenceExpression)expression).resolve()) instanceof PsiClass) {
                labelClass = (PsiClass)element;
            }
            if (labelClass == null) {
                return;
            }
            if (!GormUtils.isGormBean(labelClass)) {
                holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("must.be.domain.class.name", new Object[0])).range((PsiElement)expression).create();
                return;
            }
            String name = label.getName();
            Pair<PsiType, PsiElement> pair = fields.get(name);
            if (pair != null && (fieldClass = PsiTypesUtil.getPsiClass((PsiType)((PsiType)pair.first))) != null && !fieldClass.getManager().areElementsEquivalent((PsiElement)fieldClass, (PsiElement)labelClass) && !labelClass.isInheritor(fieldClass, true)) {
                holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("property.is.abmbigous", name, fieldClass.getQualifiedName())).range((PsiElement)argument).create();
            }
        }
    }

    @Nullable
    private static GrListOrMap getListOrMap(@Nullable PsiField field) {
        GrExpression initializer;
        if (field instanceof GrField && (initializer = ((GrField)field).getInitializerGroovy()) instanceof GrListOrMap) {
            return (GrListOrMap)initializer;
        }
        return null;
    }

    private static void processDuplicates(AnnotationHolder holder, GrListOrMap lom) {
        if (lom.isMap()) {
            HashSet<String> names = new HashSet<String>();
            for (GrNamedArgument argument : lom.getNamedArguments()) {
                String name;
                GrArgumentLabel label = argument.getLabel();
                if (label == null || (name = label.getName()) == null || names.add(name)) continue;
                holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("duplicate.property.name", new Object[0])).range((PsiElement)label).create();
            }
        } else {
            HashSet<String> classNames = new HashSet<String>();
            for (GrExpression expr : lom.getInitializers()) {
                if (!(expr instanceof GrReferenceExpression)) continue;
                PsiElement element = ((GrReferenceExpression)expr).resolve();
                if (element instanceof PsiClass) {
                    String qname = ((PsiClass)element).getQualifiedName();
                    assert (qname != null);
                    if (classNames.add(qname)) continue;
                    holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("domain.annotator.duplicate.type", "list")).range((PsiElement)expr).create();
                    continue;
                }
                holder.newAnnotation(HighlightSeverity.WARNING, GrailsBundle.message("domain.annotator.class.name.expected", new Object[0])).range((PsiElement)expr).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/grails/annotator/GrailsDomainAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

