/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

class GrailsArtifactCache {
    private final MultiMap<String, VirtualFile> myVirtualFileMap;
    private final PsiManager myManager;
    private long myModificationStamp = -1L;
    private volatile MultiMap<String, GrClassDefinition> myClassMap;

    GrailsArtifactCache(MultiMap<String, VirtualFile> virtualFileMap, Project project) {
        this.myVirtualFileMap = virtualFileMap;
        this.myManager = PsiManager.getInstance((Project)project);
    }

    public MultiMap<String, VirtualFile> getVirtualFileMap() {
        return this.myVirtualFileMap;
    }

    @Nullable
    private GrClassDefinition getClassDefinition(@Nullable VirtualFile file) {
        GrTypeDefinition typeDefinition = GroovyUtils.getPublicClass((VirtualFile)file, (PsiManager)this.myManager);
        if (typeDefinition instanceof GrClassDefinition) {
            return (GrClassDefinition)typeDefinition;
        }
        return null;
    }

    @NotNull
    public List<GrClassDefinition> getClasses(@NotNull String artifactName) {
        if (artifactName == null) {
            GrailsArtifactCache.$$$reportNull$$$0(0);
        }
        if (this.myModificationStamp == this.myManager.getModificationTracker().getModificationCount()) {
            List list = (List)this.myClassMap.get((Object)artifactName);
            if (list == null) {
                GrailsArtifactCache.$$$reportNull$$$0(1);
            }
            return list;
        }
        List vfList = (List)this.myVirtualFileMap.get((Object)artifactName);
        if (vfList.isEmpty()) {
            List<GrClassDefinition> list = Collections.emptyList();
            if (list == null) {
                GrailsArtifactCache.$$$reportNull$$$0(2);
            }
            return list;
        }
        return this.getClasses(vfList);
    }

    @NotNull
    private List<GrClassDefinition> getClasses(@NotNull List<VirtualFile> vfList) {
        int size;
        if (vfList == null) {
            GrailsArtifactCache.$$$reportNull$$$0(3);
        }
        if ((size = vfList.size()) == 1) {
            GrClassDefinition classDefinition = this.getClassDefinition(vfList.get(0));
            if (classDefinition == null) {
                List<GrClassDefinition> list = Collections.emptyList();
                if (list == null) {
                    GrailsArtifactCache.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<GrClassDefinition> list = Collections.singletonList(classDefinition);
            if (list == null) {
                GrailsArtifactCache.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<GrClassDefinition> list = new ArrayList<GrClassDefinition>(size);
        for (VirtualFile virtualFile : vfList) {
            ContainerUtil.addIfNotNull(list, (Object)this.getClassDefinition(virtualFile));
        }
        ArrayList<GrClassDefinition> arrayList = list;
        if (arrayList == null) {
            GrailsArtifactCache.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    public MultiMap<String, GrClassDefinition> getClassesMap() {
        long modificationStamp = this.myManager.getModificationTracker().getModificationCount();
        if (this.myModificationStamp == modificationStamp) {
            return this.myClassMap;
        }
        MultiMap res = new MultiMap();
        for (Map.Entry entry : this.myVirtualFileMap.entrySet()) {
            List<GrClassDefinition> classes = this.getClasses((List)entry.getValue());
            if (classes.isEmpty()) continue;
            res.put((Object)((String)entry.getKey()), classes);
        }
        this.myClassMap = res;
        this.myModificationStamp = modificationStamp;
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/util/GrailsArtifactCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/util/GrailsArtifactCache";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

