/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GroovyMvcIcons;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsArtifactCache;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public class GrailsArtifact
extends Enum<GrailsArtifact> {
    public static final /* enum */ GrailsArtifact DOMAIN = new GrailsArtifact((NotNullLazyValue<Icon>)NotNullLazyValue.createValue(() -> AllIcons.Nodes.DataTables), "", "domain");
    public static final /* enum */ GrailsArtifact CONTROLLER = new GrailsArtifact((NotNullLazyValue<Icon>)NotNullLazyValue.createValue(() -> AllIcons.Nodes.Controller), "Controller", "controllers");
    public static final /* enum */ GrailsArtifact TAGLIB = new GrailsArtifact((NotNullLazyValue<Icon>)NotNullLazyValue.createValue(() -> GroovyMvcIcons.Taglib), "TagLib", "taglib");
    public static final /* enum */ GrailsArtifact SERVICE = new GrailsArtifact((NotNullLazyValue<Icon>)NotNullLazyValue.createValue(() -> AllIcons.FileTypes.Config), "Service", "services");
    public static final /* enum */ GrailsArtifact JOB = new GrailsArtifact(null, "Job", "jobs");
    public static final /* enum */ GrailsArtifact CODEC = new GrailsArtifact(null, "Codec", "utils");
    public static final /* enum */ GrailsArtifact FILTER = new GrailsArtifact(null, "Filters", "conf");
    public static final /* enum */ GrailsArtifact REALM = new GrailsArtifact(null, "Realm", "realms");
    public static final /* enum */ GrailsArtifact URLMAPPINGS = new GrailsArtifact(null, "UrlMappings", "conf", true){

        @Override
        public String getDirectory(Module module) {
            return GrailsStructure.isVersionAtLeast("3.0", module) ? "controllers" : "conf";
        }
    };
    public static final /* enum */ GrailsArtifact BOOTSTRAP = new GrailsArtifact(null, "BootStrap", "conf", true){

        @Override
        public String getDirectory(Module module) {
            return GrailsStructure.isVersionAtLeast("3.0", module) ? "init" : "conf";
        }
    };
    public static final /* enum */ GrailsArtifact RESOURCES = new GrailsArtifact(null, "Resources", "conf", true);
    public static final /* enum */ GrailsArtifact RESOURCE_MAPPER = new GrailsArtifact(null, "ResourceMapper", "resourceMappers");
    public static final /* enum */ GrailsArtifact INTERCEPTOR = new GrailsArtifact((NotNullLazyValue<Icon>)NotNullLazyValue.createValue(() -> AllIcons.General.Filter), "Interceptor", "controllers", false);
    @Nullable
    private final NotNullLazyValue<Icon> myIcon;
    public final String suffix;
    public final String fileSuffix;
    private final String myDirectoryName;
    public final boolean mayHaveEmptyName;
    private final Key<CachedValue<GrailsArtifactCache>> cacheKey;
    private static final /* synthetic */ GrailsArtifact[] $VALUES;

    public static GrailsArtifact[] values() {
        return (GrailsArtifact[])$VALUES.clone();
    }

    public static GrailsArtifact valueOf(String name) {
        return Enum.valueOf(GrailsArtifact.class, name);
    }

    private GrailsArtifact(NotNullLazyValue<Icon> icon, String suffix, String dir) {
        this(icon, suffix, dir, false);
    }

    private GrailsArtifact(NotNullLazyValue<Icon> icon, String suffix, String dir, boolean mayHaveEmptyName) {
        this.myIcon = icon;
        this.suffix = suffix;
        this.fileSuffix = suffix + ".groovy";
        this.myDirectoryName = dir;
        this.cacheKey = Key.create((String)("GrailArtifact " + dir));
        this.mayHaveEmptyName = mayHaveEmptyName;
    }

    @Nullable
    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    public String getDirectory(Module module) {
        return this.myDirectoryName;
    }

    @NotNull
    public String getDirectory(@NotNull GrailsApplication application) {
        if (application == null) {
            GrailsArtifact.$$$reportNull$$$0(0);
        }
        String string = this.myDirectoryName;
        if (string == null) {
            GrailsArtifact.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static VirtualFile getSourceRoot(@NotNull VirtualFile file, Project project) {
        VirtualFile p;
        if (file == null) {
            GrailsArtifact.$$$reportNull$$$0(2);
        }
        if (file.isDirectory()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file);
        if (sourceRoot != null) {
            VirtualFile parent = sourceRoot.getParent();
            if (parent == null || !parent.getName().equals("grails-app")) {
                return null;
            }
            return sourceRoot;
        }
        VirtualFile root = fileIndex.getContentRootForFile(file);
        if (root == null) {
            return null;
        }
        VirtualFile f = file;
        VirtualFile parent = f.getParent();
        if (parent == null) {
            return null;
        }
        while (!Comparing.equal((Object)(p = parent.getParent()), (Object)root) && p != null) {
            f = parent;
            parent = p;
        }
        if (parent.getName().equals("grails-app")) {
            return f;
        }
        return null;
    }

    private boolean endWithSuffix(String name) {
        return name.endsWith(this.suffix) && (this.mayHaveEmptyName || name.length() > this.suffix.length());
    }

    private boolean endWithFileSuffix(String name) {
        return name.endsWith(this.fileSuffix) && (this.mayHaveEmptyName || name.length() > this.fileSuffix.length());
    }

    public boolean isInstance(@Nullable VirtualFile virtualFile, @NotNull Project project) {
        if (project == null) {
            GrailsArtifact.$$$reportNull$$$0(3);
        }
        return this.getGrailsApp(virtualFile, project) != null;
    }

    @Nullable
    private VirtualFile getGrailsApp(@Nullable VirtualFile file, Project project) {
        if (file == null) {
            return null;
        }
        if (!this.endWithFileSuffix(file.getName())) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return null;
        }
        VirtualFile sourceRoot = GrailsArtifact.getSourceRoot(file, project);
        if (sourceRoot == null) {
            return null;
        }
        if (!sourceRoot.getName().equals(this.getDirectory(module))) {
            return null;
        }
        return sourceRoot.getParent();
    }

    private boolean isNameEndWithSuffix(PsiClass psiClass) {
        String className = psiClass.getName();
        return className != null && this.endWithSuffix(className);
    }

    @Nullable
    public VirtualFile getGrailsApp(@Nullable PsiClass psiClass) {
        if (!(psiClass instanceof GrClassDefinition)) {
            return null;
        }
        if (!this.isNameEndWithSuffix(psiClass) || PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiClass.class) != null) {
            return null;
        }
        return this.getGrailsApp(psiClass.getContainingFile().getOriginalFile().getVirtualFile(), psiClass.getProject());
    }

    @Nullable
    public static GrailsArtifact getType(@Nullable PsiClass psiClass) {
        if (!(psiClass instanceof GrClassDefinition)) {
            return null;
        }
        PsiFile psiFile = psiClass.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        VirtualFile sourceRoot = GrailsArtifact.getSourceRoot(virtualFile, psiFile.getProject());
        if (sourceRoot == null) {
            return null;
        }
        GrailsArtifact[] artifacts = GrailsArtifact.getSourceRootMap(module).get(sourceRoot.getName());
        if (artifacts == null) {
            return null;
        }
        String className = psiClass.getName();
        if (className == null) {
            return null;
        }
        for (GrailsArtifact candidate : artifacts) {
            if (!candidate.endWithSuffix(className)) continue;
            return candidate;
        }
        return null;
    }

    public boolean isInstance(@Nullable PsiClass psiClass) {
        return this.getGrailsApp(psiClass) != null;
    }

    @NotNull
    public String getArtifactName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GrailsArtifact.$$$reportNull$$$0(4);
        }
        String string = this.getArtifactName(psiClass.getName());
        if (string == null) {
            GrailsArtifact.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getArtifactNameByFileName(String fileName) {
        assert (this.endWithFileSuffix(fileName));
        String string = StringUtil.decapitalize((String)fileName.substring(0, fileName.length() - this.fileSuffix.length()));
        if (string == null) {
            GrailsArtifact.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getArtifactName(@NotNull String className) {
        if (className == null) {
            GrailsArtifact.$$$reportNull$$$0(7);
        }
        assert (this.endWithSuffix(className));
        String string = StringUtil.decapitalize((String)className.substring(0, className.length() - this.suffix.length()));
        if (string == null) {
            GrailsArtifact.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Deprecated
    @Nullable
    public VirtualFile findDirectory(@Nullable Module module) {
        VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(module);
        if (appDir == null) {
            return null;
        }
        return appDir.findChild(this.getDirectory(module));
    }

    @Nullable
    public VirtualFile findDirectory(@NotNull GrailsApplication application) {
        if (application == null) {
            GrailsArtifact.$$$reportNull$$$0(9);
        }
        return application.getAppRoot().findChild(this.getDirectory(application));
    }

    public MultiMap<String, VirtualFile> getVirtualFileMap(@NotNull Module module) {
        if (module == null) {
            GrailsArtifact.$$$reportNull$$$0(10);
        }
        return this.getCache(module).getVirtualFileMap();
    }

    @NotNull
    public Collection<GrClassDefinition> getInstances(@NotNull Module module, @Nullable String artefactName) {
        if (module == null) {
            GrailsArtifact.$$$reportNull$$$0(11);
        }
        if (artefactName == null) {
            List<GrClassDefinition> list = Collections.emptyList();
            if (list == null) {
                GrailsArtifact.$$$reportNull$$$0(12);
            }
            return list;
        }
        Collection<GrClassDefinition> collection = this.getInstances(module, null, artefactName);
        if (collection == null) {
            GrailsArtifact.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @NotNull
    public Collection<GrClassDefinition> getInstances(@NotNull Module module, @Nullable String packageName, @NotNull String artefactName) {
        if (module == null) {
            GrailsArtifact.$$$reportNull$$$0(14);
        }
        if (artefactName == null) {
            GrailsArtifact.$$$reportNull$$$0(15);
        }
        GrailsArtifactCache cache = this.getCache(module);
        List list = packageName == null ? cache.getClasses(artefactName) : ContainerUtil.filter(cache.getClasses(artefactName), c -> {
            String qualifiedName = c.getQualifiedName();
            return qualifiedName != null && StringUtil.getPackageName((String)qualifiedName).equals(packageName);
        });
        if (list == null) {
            GrailsArtifact.$$$reportNull$$$0(16);
        }
        return list;
    }

    private GrailsArtifactCache getCache(@NotNull Module module) {
        if (module == null) {
            GrailsArtifact.$$$reportNull$$$0(17);
        }
        Project project = module.getProject();
        return (GrailsArtifactCache)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, this.cacheKey, () -> {
            MultiMap<String, VirtualFile> map2 = this.calculateInstances(module);
            MvcModuleStructureSynchronizer synchronizer = MvcModuleStructureSynchronizer.getInstance(project);
            return CachedValueProvider.Result.create((Object)new GrailsArtifactCache(map2, project), (Object[])new Object[]{synchronizer.getFileAndRootsModificationTracker(), GrailsApplicationManager.getInstance(project)});
        }, false);
    }

    @NotNull
    public MultiMap<String, GrClassDefinition> getInstances(@NotNull Module module) {
        if (module == null) {
            GrailsArtifact.$$$reportNull$$$0(18);
        }
        MultiMap<String, GrClassDefinition> multiMap = this.getCache(module).getClassesMap();
        if (multiMap == null) {
            GrailsArtifact.$$$reportNull$$$0(19);
        }
        return multiMap;
    }

    private void calculateInstancesInDirectory(@NotNull VirtualFile contentEntry, MultiMap<String, VirtualFile> map2, ProjectFileIndex fileIndex) {
        if (contentEntry == null) {
            GrailsArtifact.$$$reportNull$$$0(20);
        }
        fileIndex.iterateContentUnderDirectory(contentEntry, fileOrDir -> {
            String name;
            if (!fileOrDir.isDirectory() && this.endWithFileSuffix(name = fileOrDir.getName())) {
                map2.putValue((Object)this.getArtifactNameByFileName(name), (Object)fileOrDir);
            }
            return true;
        });
    }

    @NotNull
    private MultiMap<String, VirtualFile> calculateInstances(@NotNull Module module) {
        if (module == null) {
            GrailsArtifact.$$$reportNull$$$0(21);
        }
        MultiMap res = new MultiMap();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        HashSet modules = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, modules);
        for (Module m : modules) {
            if (GrailsFramework.getInstance().isCommonPluginsModule(m)) {
                for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)m).getContentRoots()) {
                    VirtualFile dir;
                    VirtualFile appDirectory = virtualFile.findChild("grails-app");
                    if (appDirectory == null || (dir = appDirectory.findChild(this.getDirectory(m))) == null) continue;
                    this.calculateInstancesInDirectory(dir, (MultiMap<String, VirtualFile>)res, fileIndex);
                }
                continue;
            }
            VirtualFile directory = this.findDirectory(m);
            if (directory != null) {
                this.calculateInstancesInDirectory(directory, (MultiMap<String, VirtualFile>)res, fileIndex);
            }
            this.collectFromPluginXmls(module, (MultiMap<String, VirtualFile>)res);
        }
        MultiMap multiMap = res;
        if (multiMap == null) {
            GrailsArtifact.$$$reportNull$$$0(22);
        }
        return multiMap;
    }

    private void collectFromPluginXmls(Module module, MultiMap<String, VirtualFile> result2) {
        Project project = module.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = module.getModuleWithDependenciesAndLibrariesScope(false);
        PsiFile[] allFiles = FilenameIndex.getFilesByName((Project)project, (String)"grails-plugin.xml", (GlobalSearchScope)scope);
        JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
        for (PsiFile file : allFiles) {
            XmlTag[] subTags;
            XmlTag rootTag;
            PsiPackage pckg;
            PsiDirectory directory;
            if (!(file instanceof XmlFile) || (directory = file.getContainingDirectory()) == null || (pckg = directoryService.getPackage(directory)) == null || !pckg.getQualifiedName().equals("META-INF") || (rootTag = ((XmlFile)file).getRootTag()) == null || (subTags = rootTag.findSubTags("resources")).length != 1) continue;
            XmlTag resourcesTag = subTags[0];
            for (XmlTag tag : resourcesTag.getSubTags()) {
                String name;
                PsiClass clazz;
                XmlTagValue value;
                String fqn;
                if (!tag.getName().equals("resource") || !this.endWithSuffix(fqn = (value = tag.getValue()).getTrimmedText()) || (clazz = facade.findClass(fqn, scope)) == null || (name = clazz.getName()) == null || !this.endWithSuffix(name)) continue;
                result2.putValue((Object)this.getArtifactName(name), (Object)clazz.getContainingFile().getVirtualFile());
            }
        }
    }

    @NotNull
    private static Map<String, GrailsArtifact[]> getSourceRootMap(@Nullable Module module) {
        if (module == null) {
            Map<String, GrailsArtifact[]> map2 = Collections.emptyMap();
            if (map2 == null) {
                GrailsArtifact.$$$reportNull$$$0(23);
            }
            return map2;
        }
        Project project = module.getProject();
        Map map3 = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            MultiMap multiMap = new MultiMap();
            for (GrailsArtifact artifact : GrailsArtifact.values()) {
                multiMap.putValue((Object)artifact.getDirectory(module), (Object)artifact);
            }
            HashMap<String, GrailsArtifact[]> result2 = new HashMap<String, GrailsArtifact[]>();
            for (Map.Entry entry : multiMap.entrySet()) {
                Collection artifacts = (Collection)entry.getValue();
                result2.put((String)entry.getKey(), artifacts.toArray(new GrailsArtifact[0]));
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{MvcModuleStructureSynchronizer.getInstance(project).getFileAndRootsModificationTracker()});
        });
        if (map3 == null) {
            GrailsArtifact.$$$reportNull$$$0(24);
        }
        return map3;
    }

    static {
        $VALUES = new GrailsArtifact[]{DOMAIN, CONTROLLER, TAGLIB, SERVICE, JOB, CODEC, FILTER, REALM, URLMAPPINGS, BOOTSTRAP, RESOURCES, RESOURCE_MAPPER, INTERCEPTOR};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/util/GrailsArtifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artefactName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/util/GrailsArtifact";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactNameByFileName";
                break;
            }
            case 12: 
            case 13: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstances";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateInstances";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDirectory";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRoot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInstance";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getArtifactName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileMap";
                break;
            }
            case 11: 
            case 14: 
            case 15: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInstances";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCache";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "calculateInstancesInDirectory";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calculateInstances";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

