/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.ui;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.commands.GrailsCommandCompletionUtil;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.ui.GrailsApplicationCombobox;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.ui.EditorComboBoxWithHistory;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsRunCommandDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JBLabel myApplicationsLabel;
    private GrailsApplicationCombobox myApplications;
    private JBLabel myCommandLabel;
    private EditorComboBoxWithHistory myCommand;
    private JBLabel myVMOptionsLabel;
    private EditorComboBoxWithHistory myVMOptions;
    private final Project myProject;

    public GrailsRunCommandDialog(@NotNull Project project) {
        if (project == null) {
            GrailsRunCommandDialog.$$$reportNull$$$0(0);
        }
        super(project, false, DialogWrapper.IdeModalityType.PROJECT);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myApplicationsLabel.setLabelFor((Component)((Object)this.myApplications));
        this.myApplications.disallowEmptySelection();
        this.myApplications.setApplications(GrailsApplicationManager.getInstance(this.myProject).getApplications());
        this.myApplications.addItemListener(e -> this.checkOkAction());
        this.myCommandLabel.setLabelFor((Component)((Object)this.myCommand));
        this.myCommand.getEditorComponent().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                GrailsRunCommandDialog.this.checkOkAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$1", "documentChanged"));
            }
        });
        this.installCommandCompletion();
        this.myVMOptionsLabel.setLabelFor((Component)((Object)this.myVMOptions));
        this.installVMOptionsCompletion();
        this.setTitle(GrailsBundle.message("dialog.title.run.grails.command", new Object[0]));
        this.init();
        this.checkOkAction();
    }

    private void createUIComponents() {
        this.myCommand = new EditorComboBoxWithHistory(this.myProject, "grails.command.history");
        this.myVMOptions = new EditorComboBoxWithHistory(this.myProject, "grails.vmoptions.history");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getSelectedApplicationNullable() == null ? this.myApplications : this.myCommand;
    }

    private void checkOkAction() {
        this.setOKActionEnabled(this.isOKEnabled());
    }

    private boolean isOKEnabled() {
        GrailsApplication selectedApplication;
        return !StringUtil.isEmptyOrSpaces((String)this.getCommandString()) && (selectedApplication = this.getSelectedApplicationNullable()) != null && GrailsCommandExecutor.getGrailsExecutor(selectedApplication) != null;
    }

    @Nullable
    private GrailsApplication getSelectedApplicationNullable() {
        return this.myApplications.getSelectedApplication();
    }

    @NotNull
    public GrailsApplication getSelectedApplication() {
        GrailsApplication grailsApplication2 = Objects.requireNonNull(this.getSelectedApplicationNullable());
        if (grailsApplication2 == null) {
            GrailsRunCommandDialog.$$$reportNull$$$0(1);
        }
        return grailsApplication2;
    }

    @NotNull
    public GrailsRunCommandDialog setSelectedApplication(@Nullable GrailsApplication application) {
        this.myApplications.setSelectedApplication(application);
        GrailsRunCommandDialog grailsRunCommandDialog = this;
        if (grailsRunCommandDialog == null) {
            GrailsRunCommandDialog.$$$reportNull$$$0(2);
        }
        return grailsRunCommandDialog;
    }

    @NotNull
    public String getCommandString() {
        String string = this.myCommand.getText();
        if (string == null) {
            GrailsRunCommandDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getVMOptionsString() {
        String string = this.myVMOptions.getText();
        if (string == null) {
            GrailsRunCommandDialog.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public MvcCommand getCommand() {
        MvcCommand mvcCommand = MvcCommand.parse(this.getCommandString()).setVmOptions(this.getVMOptionsString());
        if (mvcCommand == null) {
            GrailsRunCommandDialog.$$$reportNull$$$0(5);
        }
        return mvcCommand;
    }

    protected void doOKAction() {
        this.myCommand.save();
        this.myVMOptions.save();
        super.doOKAction();
    }

    private void installCommandCompletion() {
        new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                result2.addAllElements(GrailsCommandCompletionUtil.collectVariants(GrailsRunCommandDialog.this.getSelectedApplicationNullable(), text, offset, prefix));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$2";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.apply(this.myCommand.getEditorComponent());
    }

    private void installVMOptionsCompletion() {
        new TextFieldCompletionProvider(){

            protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
                if (text == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (prefix == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (result2 == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (prefix.startsWith("-D")) {
                    result2.addAllElements((Iterable)GrailsCommandCompletionUtil.SYSTEM_PROPERTIES_VARIANTS.getValue());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "prefix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog$3";
                objectArray[2] = "addCompletionVariants";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.apply(this.myVMOptions.getEditorComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/ui/GrailsRunCommandDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedApplication";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectedApplication";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVMOptionsString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        GrailsApplicationCombobox grailsApplicationCombobox;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), 5, 5, false, false));
        jPanel.setPreferredSize(new Dimension(500, -1));
        this.myApplicationsLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsRunCommandDialog.class).getString("run.command.label.application"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myApplications = grailsApplicationCombobox = new GrailsApplicationCombobox();
        jPanel.add((Component)((Object)grailsApplicationCombobox), new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCommandLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsRunCommandDialog.class).getString("run.command.label.command"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorComboBoxWithHistory editorComboBoxWithHistory = this.myCommand;
        ((JComboBox)((Object)editorComboBoxWithHistory)).setEditable(true);
        ((JComboBox)((Object)editorComboBoxWithHistory)).setLightWeightPopupEnabled(false);
        jPanel.add((Component)((Object)editorComboBoxWithHistory), new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myVMOptionsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsRunCommandDialog.class).getString("run.command.label.vm.options"));
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorComboBoxWithHistory editorComboBoxWithHistory2 = this.myVMOptions;
        ((JComboBox)((Object)editorComboBoxWithHistory2)).setEditable(true);
        ((JComboBox)((Object)editorComboBoxWithHistory2)).setLightWeightPopupEnabled(false);
        jPanel.add((Component)((Object)editorComboBoxWithHistory2), new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

