/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullLazyValue;
import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;

public abstract class GrailsApplicationBackgroundTask
extends Task.Backgroundable {
    @NotNull
    protected final NotNullLazyValue<Collection<GrailsApplication>> myApplicationsComputable;

    public GrailsApplicationBackgroundTask(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String title) {
        if (project == null) {
            GrailsApplicationBackgroundTask.$$$reportNull$$$0(0);
        }
        if (title == null) {
            GrailsApplicationBackgroundTask.$$$reportNull$$$0(1);
        }
        this(project, title, (NotNullLazyValue<Collection<GrailsApplication>>)NotNullLazyValue.lazy((Supplier)new GrailsApplicationsGetter(project)));
    }

    protected GrailsApplicationBackgroundTask(@NotNull Project project, @NotNull @NlsContexts.ProgressTitle String title, @NotNull NotNullLazyValue<Collection<GrailsApplication>> computable) {
        if (project == null) {
            GrailsApplicationBackgroundTask.$$$reportNull$$$0(2);
        }
        if (title == null) {
            GrailsApplicationBackgroundTask.$$$reportNull$$$0(3);
        }
        if (computable == null) {
            GrailsApplicationBackgroundTask.$$$reportNull$$$0(4);
        }
        super(project, title, false);
        this.myApplicationsComputable = computable;
    }

    public final void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            GrailsApplicationBackgroundTask.$$$reportNull$$$0(5);
        }
        Collection applications = (Collection)this.myApplicationsComputable.getValue();
        for (GrailsApplication application : applications) {
            indicator.checkCanceled();
            if (!application.isValid()) continue;
            indicator.setText(GrailsBundle.message("progress.indicator.text.0.in.1", this.getTitle(), application.getName()));
            this.run(application, indicator);
        }
    }

    protected abstract void run(@NotNull GrailsApplication var1, @NotNull ProgressIndicator var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class GrailsApplicationsGetter
    implements Supplier<Collection<GrailsApplication>> {
        @NotNull
        private final Project myProject;

        private GrailsApplicationsGetter(@NotNull Project project) {
            if (project == null) {
                GrailsApplicationsGetter.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        @NotNull
        public Collection<GrailsApplication> get() {
            Collection collection = (Collection)ReadAction.compute(() -> GrailsApplicationManager.getInstance(this.myProject).getApplications());
            if (collection == null) {
                GrailsApplicationsGetter.$$$reportNull$$$0(1);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask$GrailsApplicationsGetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask$GrailsApplicationsGetter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

