/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.UtilKt;

public class GrailsApplicationCombobox
extends ComboBox<GrailsApplication> {
    private final SortedComboBoxModel<GrailsApplication> myModel;
    private boolean myEmptySelectionAllowed = true;

    public GrailsApplicationCombobox() {
        this((SortedComboBoxModel<GrailsApplication>)new SortedComboBoxModel(UtilKt.COMPARATOR));
    }

    private GrailsApplicationCombobox(SortedComboBoxModel<GrailsApplication> model) {
        super(model);
        this.myModel = model;
        new ComboboxSpeedSearch((JComboBox)((Object)this)){

            protected String getElementText(Object element) {
                if (element instanceof Module) {
                    return ((Module)element).getName();
                }
                if (element == null) {
                    return "";
                }
                return super.getElementText(element);
            }
        };
        this.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, grailsApplication2, index) -> {
            if (grailsApplication2 == null) {
                label.setText(GrailsBundle.message("combobox.label.none.selected", new Object[0]));
            } else {
                label.setIcon(grailsApplication2.getIcon());
                @NlsSafe String applicationName = grailsApplication2.getName();
                label.setText(applicationName);
                @NlsSafe String path = grailsApplication2.getRoot().getPath();
                label.setToolTipText(path);
            }
        }));
    }

    public void disallowEmptySelection() {
        this.myEmptySelectionAllowed = false;
    }

    public void setApplications(@NotNull Collection<GrailsApplication> grailsApplications) {
        if (grailsApplications == null) {
            GrailsApplicationCombobox.$$$reportNull$$$0(0);
        }
        this.myModel.clear();
        if (this.myEmptySelectionAllowed) {
            this.myModel.add(null);
        }
        this.myModel.setAll(grailsApplications);
    }

    @Nullable
    public GrailsApplication getSelectedApplication() {
        return (GrailsApplication)this.myModel.getSelectedItem();
    }

    public void setSelectedApplication(@Nullable GrailsApplication grailsApplication2) {
        this.myModel.setSelectedItem((Object)grailsApplication2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grailsApplications", "org/jetbrains/plugins/grails/runner/ui/GrailsApplicationCombobox", "setApplications"));
    }
}

