/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.JdomKt;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.runner.GrailsRunConfiguration;
import org.jetbrains.plugins.grails.runner.GrailsRunConfigurationExtension;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditor;
import org.jetbrains.plugins.grails.runner.ui.GrailsRunConfigurationEditorWithListener;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.structure.impl.Grails2Application;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsInstallationCommandExecutor
extends GrailsCommandLineExecutor
implements GrailsRunConfigurationExtension<Boolean>,
GrailsInstallationExecutor {
    private static final Key<Boolean> DATA_KEY = Key.create((String)(GrailsInstallationCommandExecutor.class.getName() + " data key"));
    private static final String DEPS_CLASSPATH = "depsClasspath";

    @Override
    public boolean isApplicable(@NotNull GrailsApplication grailsApplication2) {
        if (grailsApplication2 == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(0);
        }
        return grailsApplication2 instanceof OldGrailsApplication && GrailsSDKManager.getGrailsSdk(grailsApplication2) != null;
    }

    @Override
    public boolean isApplicable(@NotNull GrailsSDK grailsSdk) {
        if (grailsSdk == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(1);
        }
        return grailsSdk.getVersion().isLessThan(Version.GRAILS_3_0);
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication2, @NotNull MvcCommand command) throws ExecutionException {
        if (grailsApplication2 == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(2);
        }
        if (command == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(3);
        }
        JavaParameters javaParameters = this.createJavaParameters((OldGrailsApplication)grailsApplication2, command, false);
        if (javaParameters == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(4);
        }
        return javaParameters;
    }

    @Override
    public void addListener(@NotNull JavaParameters params, @NotNull String listener) {
        if (params == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(5);
        }
        if (listener == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(6);
        }
        super.addListener(params, listener);
        String listenerJar = PathUtil.getJarPathForClass(GrailsRtMarker.class);
        List programParams = params.getProgramParametersList().getList();
        int cpIndex = programParams.indexOf("--classpath");
        if (cpIndex != -1 && cpIndex < programParams.size() - 1) {
            PathsList pathsList = new PathsList();
            pathsList.add((String)programParams.get(cpIndex + 1));
            pathsList.add(listenerJar);
            params.getProgramParametersList().replaceOrAppend((String)programParams.get(cpIndex + 1), pathsList.getPathsString());
        } else {
            params.getProgramParametersList().addAt(0, "--classpath");
            params.getProgramParametersList().addAt(1, listenerJar);
        }
    }

    @Override
    @NotNull
    public Key<Boolean> getKey() {
        Key<Boolean> key = DATA_KEY;
        if (key == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(7);
        }
        return key;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication2, @NotNull MvcCommand command, @Nullable Boolean depsClassPath) throws ExecutionException {
        if (grailsApplication2 == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(8);
        }
        if (command == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(9);
        }
        if (grailsApplication2 instanceof OldGrailsApplication) {
            JavaParameters javaParameters = this.createJavaParameters((OldGrailsApplication)grailsApplication2, command, depsClassPath != null && depsClassPath != false);
            if (javaParameters == null) {
                GrailsInstallationCommandExecutor.$$$reportNull$$$0(10);
            }
            return javaParameters;
        }
        throw new IllegalStateException("Should not get here");
    }

    @Override
    @Nullable
    public SettingsEditor<GrailsRunConfiguration> createExtensionEditor() {
        return new GrailsRunConfigurationEditorWithListener(){
            private final JCheckBox myDepsClassPath = new JCheckBox();

            protected void resetEditorFrom(@NotNull GrailsRunConfiguration s2) {
                Boolean depsClassPath;
                if (s2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myDepsClassPath.setSelected((depsClassPath = (Boolean)s2.getUserData(GrailsInstallationCommandExecutor.this.getKey())) != null && depsClassPath != false);
            }

            protected void applyEditorTo(@NotNull GrailsRunConfiguration s2) {
                if (s2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                s2.putUserData(GrailsInstallationCommandExecutor.this.getKey(), this.myDepsClassPath.isEnabled() && this.myDepsClassPath.isSelected());
            }

            @NotNull
            protected JComponent createEditor() {
                JCheckBox jCheckBox = this.myDepsClassPath;
                if (jCheckBox == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jCheckBox;
            }

            @Override
            public void applicationChanged(GrailsApplication application) {
                if (application instanceof Grails2Application) {
                    String presentable;
                    Module module = ((Grails2Application)application).getModule();
                    String depsClasspath = GrailsFramework.getInstance().getApplicationClassPath(module).getPathsString();
                    boolean hasClasspath = StringUtil.isNotEmpty((String)depsClasspath);
                    if (hasClasspath) {
                        String classpath = depsClasspath.length() > 70 ? depsClasspath.substring(0, 70) + "..." : depsClasspath;
                        presentable = GrailsBundle.message("runner.configuration.label.text.add.classpath", classpath);
                    } else {
                        presentable = GrailsBundle.message("runner.configuration.label.text.add.empty.classpath", new Object[0]);
                    }
                    this.myDepsClassPath.setText(presentable);
                    this.myDepsClassPath.setToolTipText(GrailsBundle.message("checkbox.tooltip.text.html.nbsp.0.html", StringUtil.replace((String)depsClasspath, (String)File.pathSeparator, (String)"<br>&nbsp;")));
                    GrailsRunConfigurationEditor.setCBEnabled(hasClasspath, this.myDepsClassPath);
                    this.myDepsClassPath.setVisible(true);
                } else {
                    GrailsRunConfigurationEditor.setCBEnabled(false, this.myDepsClassPath);
                    this.myDepsClassPath.setVisible(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "resetEditorFrom";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "applyEditorTo";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @Nullable
    public Boolean readAdditionalConfiguration(@NotNull Element element) {
        if (element == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(11);
        }
        return Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)DEPS_CLASSPATH));
    }

    @Override
    public void writeAdditionalConfiguration(@NotNull Boolean depsClassPath, @NotNull Element element) {
        if (depsClassPath == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(12);
        }
        if (element == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(13);
        }
        JdomKt.addOptionTag((Element)element, (String)DEPS_CLASSPATH, (String)Boolean.toString(depsClassPath), (String)"setting");
    }

    public JavaParameters createJavaParameters(@NotNull OldGrailsApplication grailsApplication2, @NotNull MvcCommand command, boolean classPathFromDependencies) throws ExecutionException {
        GrailsSDK grailsSdk;
        if (grailsApplication2 == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(14);
        }
        if (command == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(15);
        }
        if ((grailsSdk = GrailsSDKManager.getGrailsSdk(grailsApplication2)) == null) {
            throw new ExecutionException(GrailsBundle.message("dialog.message.grails.sdk.not.defined", new Object[0]));
        }
        Module module = grailsApplication2.getModule();
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        if (sdk == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"no.jdk.for.module.error.message", (Object[])new Object[]{module.getName()}));
        }
        JavaParameters params = this.createJavaParameters(sdk, grailsSdk, command);
        VirtualFile rootFile = grailsApplication2.getRoot();
        String workDir = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile).getAbsolutePath();
        params.getVMParametersList().addProperty("base.dir", workDir);
        params.setWorkingDirectory(workDir);
        params.setDefaultCharset(grailsApplication2.getProject());
        if (classPathFromDependencies) {
            GrailsInstallationCommandExecutor.addToClassPath(params, GrailsFramework.getInstance().getApplicationClassPath(module).getVirtualFiles());
        }
        return params;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Sdk sdk, @NotNull GrailsSDK grailsSdk, @NotNull MvcCommand command) {
        File springLoadedJar;
        String grailsOpts;
        String pathStr;
        File bootStrapJar;
        if (sdk == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(16);
        }
        if (grailsSdk == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(17);
        }
        if (command == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(18);
        }
        JavaParameters params = new JavaParameters();
        params.setUseClasspathJar(true);
        String grailsSdkHomePath = grailsSdk.getPath();
        params.setJdk(sdk);
        params.setupEnvs(command.getEnvVariables(), command.isPassParentEnvs());
        params.addEnv("GRAILS_HOME", FileUtil.toSystemDependentName((String)grailsSdkHomePath));
        GrailsFramework.addJavaHome(sdk, params);
        File groovyJar = GrailsInstallationCommandExecutor.findGroovyJar(grailsSdkHomePath);
        if (groovyJar != null) {
            params.getClassPath().add(groovyJar.getAbsolutePath());
        }
        if ((bootStrapJar = GrailsInstallationCommandExecutor.findBootStrapJar(grailsSdkHomePath)) != null) {
            params.getClassPath().add(bootStrapJar.getAbsolutePath());
        }
        params.setMainClass("org.codehaus.groovy.grails.cli.support.GrailsStarter");
        params.getVMParametersList().addProperty("grails.home", grailsSdkHomePath);
        SdkTypeId sdkType = sdk.getSdkType();
        if (sdkType instanceof JavaSdkType) {
            params.getVMParametersList().addProperty("tools.jar", ((JavaSdkType)sdkType).getToolsPath(sdk));
        }
        String confPath = grailsSdkHomePath + "/conf/groovy-starter.conf";
        params.getVMParametersList().addProperty("groovy.starter.conf", confPath);
        params.getProgramParametersList().add("--main");
        params.getProgramParametersList().add("org.codehaus.groovy.grails.cli.GrailsScriptRunner");
        params.getProgramParametersList().add("--conf");
        params.getProgramParametersList().add(confPath);
        Version version = grailsSdk.getVersion();
        PathsList cp = new PathsList();
        if (version.compareTo(Version.GRAILS_1_1) < 0) {
            cp.add(".");
        }
        if ((pathStr = cp.getPathsString()).length() > 0) {
            params.getProgramParametersList().add("--classpath");
            params.getProgramParametersList().add(pathStr);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(grailsOpts = System.getenv("GRAILS_OPTS")))) {
            params.getVMParametersList().addParametersString(grailsOpts);
        }
        params.getVMParametersList().addParametersString(command.getVmOptions());
        String parametersString = params.getVMParametersList().getParametersString();
        if (!JavaSdk.getInstance().isOfVersionOrHigher(sdk, JavaSdkVersion.JDK_1_8)) {
            if (version.compareTo(Version.GRAILS_2_0) >= 0) {
                if (GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xmx", "768M")) {
                    GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xms", "768M");
                }
                if (GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:MaxPermSize=", "256m")) {
                    GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:PermSize=", "256m");
                }
            } else {
                GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-Xmx", "512M");
                GrailsInstallationCommandExecutor.addMemoryConstraintIfNotExists(parametersString, params, "-XX:MaxPermSize=", "192m");
            }
        }
        GrailsExecutionUtils.addCommonJvmOptions(params);
        ParametersList grailsCommand = new ParametersList();
        command.addToParametersList(grailsCommand);
        if (!grailsCommand.hasParameter("-plain-output") && version.compareTo(Version.GRAILS_2_0) >= 0) {
            grailsCommand.add("-plain-output");
        }
        params.getProgramParametersList().add(grailsCommand.getParametersString());
        if (GrailsInstallationCommandExecutor.enableReloader(grailsCommand) && (springLoadedJar = GrailsInstallationCommandExecutor.findSpringLoadedJar(grailsSdkHomePath)) != null) {
            params.getVMParametersList().add("-javaagent:" + springLoadedJar.getAbsolutePath());
            params.getVMParametersList().add("-noverify");
            if (!params.getVMParametersList().hasProperty("springloaded")) {
                params.getVMParametersList().addProperty("springloaded", "profile=grails;cacheDir=.");
            }
        }
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(19);
        }
        return javaParameters;
    }

    private static boolean addMemoryConstraintIfNotExists(String existedParams, JavaParameters javaParameters, String paramName, String value) {
        if (!existedParams.contains(paramName)) {
            javaParameters.getVMParametersList().add(paramName + value);
            return true;
        }
        return false;
    }

    private static boolean enableReloader(@NotNull ParametersList grailsCommand) {
        if (grailsCommand == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(20);
        }
        return grailsCommand.hasParameter("-reloading") || grailsCommand.hasParameter("run-app") && !grailsCommand.hasParameter("-noreloading");
    }

    @Nullable
    private static File findGroovyJar(@NotNull String grailsSdkHomePath) {
        File groovyJar;
        if (grailsSdkHomePath == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(21);
        }
        if ((groovyJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/org.codehaus.groovy/groovy-all", "groovy-all-")) != null) {
            return groovyJar;
        }
        File[] files = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsSdkHomePath + "/lib"), (String)"groovy-all-\\d[^-]*\\.jar");
        if (files.length > 0) {
            groovyJar = files[0];
        }
        return groovyJar;
    }

    @Nullable
    private static File findBootStrapJar(@NotNull String grailsSdkHomePath) {
        File[] bootstrapFiles;
        if (grailsSdkHomePath == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(22);
        }
        if ((bootstrapFiles = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsSdkHomePath + "/dist/"), (String)"grails-bootstrap-\\d[^-]*(?:-SNAPSHOT)?\\.jar")).length > 0) {
            return bootstrapFiles[0];
        }
        File[] cliFiles = GroovyUtils.getFilesInDirectoryByPattern((String)(grailsSdkHomePath + "/dist/"), (String)"grails-cli-\\d[^-]*(?:-SNAPSHOT)?\\.jar");
        if (cliFiles.length > 0) {
            return cliFiles[0];
        }
        return null;
    }

    @Nullable
    private static File findSpringLoadedJar(@NotNull String grailsSdkHomePath) {
        File springLoadedJar;
        if (grailsSdkHomePath == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(23);
        }
        if ((springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/org.springframework/springloaded", "springloaded-")) == null) {
            springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/org.springsource.springloaded/springloaded-core", "springloaded-core-");
        }
        if (springLoadedJar == null) {
            springLoadedJar = GrailsUtils.findLatestJarInIvyRepository(grailsSdkHomePath + "/lib/com.springsource.springloaded/springloaded-core", "springloaded-core-");
        }
        return springLoadedJar;
    }

    private static void addToClassPath(@NotNull JavaParameters params, Collection<VirtualFile> files) {
        List programParams;
        int cpIndex;
        if (params == null) {
            GrailsInstallationCommandExecutor.$$$reportNull$$$0(24);
        }
        if ((cpIndex = (programParams = params.getProgramParametersList().getList()).indexOf("--classpath")) != -1 && cpIndex < programParams.size() - 1) {
            PathsList pathsList = new PathsList();
            pathsList.add((String)programParams.get(cpIndex + 1));
            pathsList.addVirtualFiles(files);
            params.getProgramParametersList().replaceOrAppend((String)programParams.get(cpIndex + 1), pathsList.getPathsString());
        } else {
            PathsList pathsList = new PathsList();
            pathsList.addVirtualFiles(files);
            params.getProgramParametersList().addAt(0, "--classpath");
            params.getProgramParametersList().addAt(1, pathsList.getPathsString());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsApplication";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsSdk";
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depsClassPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsCommand";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsSdkHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/impl/GrailsInstallationCommandExecutor";
                break;
            }
            case 4: 
            case 10: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 19: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readAdditionalConfiguration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeAdditionalConfiguration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "enableReloader";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findGroovyJar";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findBootStrapJar";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findSpringLoadedJar";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addToClassPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

