/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner.impl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.runner.GrailsCommandLineExecutor;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.runner.SetupKt;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.structure.Grails3Application;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class Grails3InstallationCommandExecutor
extends GrailsCommandLineExecutor
implements GrailsInstallationExecutor {
    @Override
    public boolean isApplicable(@NotNull GrailsApplication grailsApplication2) {
        if (grailsApplication2 == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(0);
        }
        return grailsApplication2 instanceof Grails3Application && GrailsSDKManager.getGrailsSdk(grailsApplication2) != null;
    }

    @Override
    public boolean isApplicable(@NotNull GrailsSDK grailsSdk) {
        if (grailsSdk == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(1);
        }
        return grailsSdk.getVersion().isAtLeast(Version.GRAILS_3_0);
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull GrailsApplication grailsApplication2, @NotNull MvcCommand command) throws ExecutionException {
        GrailsSDK grailsSdk;
        if (grailsApplication2 == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(2);
        }
        if (command == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(3);
        }
        if ((grailsSdk = GrailsSDKManager.getGrailsSdk(grailsApplication2)) == null) {
            throw new ExecutionException(GrailsBundle.message("dialog.message.grails.sdk.not.defined", new Object[0]));
        }
        Sdk sdk = ProjectRootManager.getInstance((Project)grailsApplication2.getProject()).getProjectSdk();
        if (sdk == null) {
            throw new ExecutionException(GrailsBundle.message("dialog.message.grails.sdk.not.defined", new Object[0]));
        }
        JavaParameters params = this.createJavaParameters(sdk, grailsSdk, command);
        params.setWorkingDirectory(VfsUtilCore.virtualToIoFile((VirtualFile)grailsApplication2.getRoot()));
        params.setDefaultCharset(grailsApplication2.getProject());
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(4);
        }
        return javaParameters;
    }

    @Override
    @NotNull
    public JavaParameters createJavaParameters(@NotNull Sdk sdk, @NotNull GrailsSDK grailsSdk, @NotNull MvcCommand command) throws ExecutionException {
        if (sdk == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(5);
        }
        if (grailsSdk == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(6);
        }
        if (command == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(7);
        }
        JavaParameters params = new JavaParameters();
        params.setJdk(sdk);
        params.getVMParametersList().addAll(new String[]{"-XX:+TieredCompilation", "-XX:TieredStopAtLevel=1", "-XX:CICompilerCount=3"});
        params.getVMParametersList().addParametersString(command.getVmOptions());
        GrailsExecutionUtils.addCommonJvmOptions(params);
        params.getClassPath().addAllFiles(Grails3InstallationCommandExecutor.runClassPath(new File(grailsSdk.getPath())));
        params.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
        params.setMainClass("org.grails.cli.GrailsCli");
        command.addToParametersList(params.getProgramParametersList());
        SetupKt.addPlainOutput(params.getProgramParametersList());
        params.setUseClasspathJar(true);
        JavaParameters javaParameters = params;
        if (javaParameters == null) {
            Grails3InstallationCommandExecutor.$$$reportNull$$$0(8);
        }
        return javaParameters;
    }

    private static List<File> runClassPath(File grailsSDKHome) {
        File grailsSDKDist = new File(grailsSDKHome.getAbsolutePath() + "/dist");
        File grailsSDKLib = new File(grailsSDKHome.getAbsolutePath() + "/lib");
        if (!grailsSDKDist.exists() || !grailsSDKLib.exists()) {
            return Collections.emptyList();
        }
        ArrayList<File> result2 = new ArrayList<File>();
        FileUtil.processFilesRecursively((File)grailsSDKHome, file -> {
            String fileName = file.getName();
            if (fileName.endsWith(".jar") && !fileName.endsWith("-sources.jar") && !fileName.endsWith("-javadoc.jar") && !fileName.matches("javaee-(web-)?api(-\\d(\\.\\d)*)?.jar")) {
                result2.add((File)file);
            }
            return true;
        });
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsApplication";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsSdk";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/impl/Grails3InstallationCommandExecutor";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createJavaParameters";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

