/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.filter;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.controller.ActionReference;
import org.jetbrains.plugins.grails.references.controller.ControllerReference;
import org.jetbrains.plugins.grails.references.filter.GrailsFilterUtil;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.resolve.GroovyStringLiteralManipulator;

public class FilterReferenceProvider
extends PsiReferenceProvider {
    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        GrNamedArgument namedArgument;
        GrArgumentLabel label;
        if (element == null) {
            FilterReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FilterReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((label = (namedArgument = (GrNamedArgument)element.getParent()).getLabel()) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FilterReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String key = label.getName();
        boolean isAction = "action".equals(key);
        if (!isAction && !"controller".equals(key)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FilterReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement arguments = namedArgument.getParent();
        if (arguments instanceof GrListOrMap) {
            arguments = arguments.getParent();
        }
        if (!(arguments instanceof GrArgumentList)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FilterReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement eMethodCall = arguments.getParent();
        if (!GrailsFilterUtil.isFilterDefinitionMethod(eMethodCall)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                FilterReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<ControllerReference> res = new ArrayList<ControllerReference>();
        String text = element.getText();
        assert (element instanceof GrLiteralImpl);
        TextRange rangeInLiteral = GroovyStringLiteralManipulator.getLiteralRange((String)text);
        String value = rangeInLiteral.substring(text);
        int index = 0;
        while (index <= value.length()) {
            int end = index;
            if (index < value.length() && Character.isJavaIdentifierStart(value.charAt(index))) {
                while (++end < value.length() && Character.isJavaIdentifierPart(value.charAt(end))) {
                }
            }
            TextRange range = new TextRange(rangeInLiteral.getStartOffset() + index, rangeInLiteral.getStartOffset() + end);
            index = end + 1;
            Object ref = isAction ? new ActionReference(element, range, false, ControllerResolver.INSTANCE) : new ControllerReference(element, range, false);
            res.add((ControllerReference)((Object)ref));
        }
        PsiReference[] psiReferenceArray = res.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            FilterReferenceProvider.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/filter/FilterReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/filter/FilterReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ControllerResolver
    implements Function<PsiElement, Map<String, PsiMethod>> {
        private static final Function<PsiElement, Map<String, PsiMethod>> INSTANCE = new ControllerResolver();
        private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

        private ControllerResolver() {
        }

        public Map<String, PsiMethod> fun(PsiElement element) {
            Module module;
            Object oText;
            GrExpression expression;
            PsiElement parent = element.getParent();
            if (!(parent instanceof GrNamedArgument)) {
                return Collections.emptyMap();
            }
            GrNamedArgument namedArgument = (GrNamedArgument)parent;
            GrNamedArgument controllerNamedArgument = ((GrNamedArgumentsOwner)namedArgument.getParent()).findNamedArgument("controller");
            List<String> controllerNames = Collections.emptyList();
            if (controllerNamedArgument != null && (expression = controllerNamedArgument.getExpression()) instanceof GrLiteralImpl && (oText = ((GrLiteralImpl)expression).getValue()) instanceof String) {
                Matcher matcher = IDENTIFIER_PATTERN.matcher((String)oText);
                controllerNames = new ArrayList<String>();
                while (matcher.find()) {
                    controllerNames.add(matcher.group());
                }
            }
            if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
                return Collections.emptyMap();
            }
            MultiMap<String, GrClassDefinition> multiMap = GrailsArtifact.CONTROLLER.getInstances(module);
            if (controllerNames.isEmpty()) {
                return GrailsUtils.getControllerActions(multiMap.values(), module);
            }
            ArrayList controllers = new ArrayList();
            for (String controllerName : controllerNames) {
                controllers.addAll(multiMap.get((Object)controllerName));
            }
            return GrailsUtils.getControllerActions(controllers, module);
        }
    }
}

