/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import gnu.trove.THashSet;
import icons.JetgroovyIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.DomainMembersProvider;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.detachedCriteria.DetachedCriteriaUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class GormDynamicFinderCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private static final Logger LOG = Logger.getInstance(GormDynamicFinderCompletionProvider.class);

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiClass domainClass;
        GrReferenceExpression refExpr;
        GrExpression qualifier;
        if (parameters == null) {
            GormDynamicFinderCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GormDynamicFinderCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            GormDynamicFinderCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((qualifier = (refExpr = (GrReferenceExpression)parameters.getPosition().getParent()).getQualifierExpression()) == null) {
            return;
        }
        PsiType type = GroovyCompletionUtil.getQualifierType((PsiElement)qualifier);
        if (!(type instanceof PsiClassType)) {
            return;
        }
        if (GormDynamicFinderCompletionProvider.isStaticMemberReference(qualifier)) {
            domainClass = ((PsiClassType)type).resolve();
            if (!GormUtils.isGormBean(domainClass)) {
                return;
            }
            assert (domainClass != null);
        } else {
            domainClass = DetachedCriteriaUtil.getDomainClassByDetachedCriteriaExpression(type);
            if (domainClass == null) {
                return;
            }
        }
        if (refExpr.getReferenceName() != null) {
            DomainDescriptor descriptor = DomainDescriptor.getDescriptor(domainClass);
            GormDynamicFinderCompletionProvider.addDynamicFinderMethods(result2, descriptor, result2.getPrefixMatcher().getPrefix());
        }
    }

    public static boolean isStaticMemberReference(GrExpression qual) {
        PsiReference ref = qual.getReference();
        if (ref == null) {
            return false;
        }
        return ref.resolve() instanceof PsiClass;
    }

    private static void addDynamicFinderMethods(CompletionResultSet result2, DomainDescriptor descriptor, String pref) {
        String[] names = ArrayUtilRt.toStringArray(descriptor.getPersistentProperties().keySet());
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = StringUtil.capitalize((String)names[i2]);
        }
        String p = GormDynamicFinderCompletionProvider.findPrefix(pref, 0, DomainClassUtils.FINDER_PREFIXES);
        if (p == null) {
            for (String prefix : DomainClassUtils.FINDER_PREFIXES) {
                GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, prefix, descriptor);
            }
            return;
        }
        int offset = p.length();
        if (p.equals("findOrCreateBy") || p.equals("findOrSaveBy")) {
            GormDynamicFinderCompletionProvider.completeFindOrSave(result2, pref, offset, names, descriptor);
            return;
        }
        boolean isGrails2_0 = true;
        GrailsStructure structure = GrailsStructure.getInstance((PsiElement)descriptor.getDomainClass());
        if (structure != null) {
            isGrails2_0 = structure.isAtLeastGrails1_4();
        }
        String[] expressions = isGrails2_0 ? DomainClassUtils.DOMAIN_FINDER_EXPRESSIONS_2_0 : DomainClassUtils.DOMAIN_FINDER_EXPRESSIONS_OLD;
        String connector = null;
        while (true) {
            if ((p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, names)) == null) {
                for (String name : names) {
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, pref.substring(0, offset) + name, descriptor);
                }
                break;
            }
            offset += p.length();
            int notLength = 0;
            p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, expressions);
            if (p == null && pref.startsWith("Not", offset)) {
                notLength = "Not".length();
                p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset + 3, expressions);
            }
            if (p == null) {
                if (GormDynamicFinderCompletionProvider.findPrefix(pref, offset, DomainClassUtils.DOMAIN_CONNECTIVES) == null) {
                    String start = pref.substring(0, offset);
                    GormDynamicFinderCompletionProvider.addCompletedLookup(result2, start, descriptor);
                    for (String expression : expressions) {
                        if (expression.equals("Equal")) continue;
                        if (expression.equals("NotEqual")) {
                            GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + expression, descriptor);
                            continue;
                        }
                        GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + expression, descriptor);
                        GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + "Not" + expression, descriptor);
                    }
                    if (connector == null) {
                        for (String c : DomainClassUtils.DOMAIN_CONNECTIVES) {
                            GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + c, descriptor);
                        }
                        break;
                    }
                    if (!isGrails2_0) break;
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + connector, descriptor);
                    break;
                }
            } else {
                offset += p.length() + notLength;
            }
            if ((p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, DomainClassUtils.DOMAIN_CONNECTIVES)) == null) {
                String start = pref.substring(0, offset);
                GormDynamicFinderCompletionProvider.addCompletedLookup(result2, start, descriptor);
                if (connector == null) {
                    for (String name : names) {
                        for (String c : DomainClassUtils.DOMAIN_CONNECTIVES) {
                            GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + c + name, descriptor);
                        }
                    }
                } else {
                    if (!isGrails2_0) break;
                    for (String name : names) {
                        GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + connector + name, descriptor);
                    }
                }
                break;
            }
            if (connector == null) {
                connector = p;
            } else if (!isGrails2_0) {
                GormDynamicFinderCompletionProvider.addCompletedLookup(result2, pref.substring(0, offset), descriptor);
                break;
            }
            offset += p.length();
        }
    }

    private static void completeFindOrSave(CompletionResultSet result2, String pref, int offset, String[] names, @NotNull DomainDescriptor descriptor) {
        if (descriptor == null) {
            GormDynamicFinderCompletionProvider.$$$reportNull$$$0(3);
        }
        THashSet alreadyUsed = new THashSet();
        while (true) {
            String p;
            if ((p = GormDynamicFinderCompletionProvider.findPrefix(pref, offset, names)) == null) {
                for (String name : names) {
                    if (alreadyUsed.contains(name)) continue;
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, pref.substring(0, offset) + name, descriptor);
                }
                break;
            }
            alreadyUsed.add(p);
            if (pref.startsWith("Equal", offset += p.length())) {
                offset += "Equal".length();
            }
            if (!pref.startsWith("And", offset)) {
                String start = pref.substring(0, offset);
                GormDynamicFinderCompletionProvider.addCompletedLookup(result2, start, descriptor);
                for (String name : names) {
                    if (alreadyUsed.contains(name)) continue;
                    GormDynamicFinderCompletionProvider.addIncompleteLookup(result2, start + "And" + name, descriptor);
                }
                return;
            }
            offset += "And".length();
        }
    }

    @Nullable
    private static String findPrefix(String s2, int offset, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!s2.startsWith(prefix, offset)) continue;
            return prefix;
        }
        return null;
    }

    private static void addCompletedLookup(CompletionResultSet result2, String text, @NotNull DomainDescriptor descriptor) {
        GrLightMethodBuilder method;
        if (descriptor == null) {
            GormDynamicFinderCompletionProvider.$$$reportNull$$$0(4);
        }
        if ((method = DomainMembersProvider.parseFinderMethod(text, descriptor)) == null) {
            LOG.error("Invalid method name generated: " + text);
            return;
        }
        GrParameter[] parameters = method.getParameters();
        if (parameters.length > 0 && parameters[parameters.length - 1].isOptional()) {
            method.getParameterList().removeParameter(parameters.length - 1);
        }
        result2.addElement(GroovyCompletionUtil.createLookupElement((PsiNamedElement)method));
    }

    private static void addIncompleteLookup(CompletionResultSet result2, String text, @NotNull DomainDescriptor descriptor) {
        if (descriptor == null) {
            GormDynamicFinderCompletionProvider.$$$reportNull$$$0(5);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)text).withIcon(JetgroovyIcons.Groovy.Method);
        Object typeText = "";
        if (text.startsWith("findAll")) {
            typeText = "List<" + descriptor.getDomainClass().getName() + ">";
        } else if (text.startsWith("count")) {
            typeText = "int";
        } else if (text.startsWith("find")) {
            typeText = descriptor.getDomainClass().getName();
        }
        element = element.withTypeText((String)typeText);
        element = element.withTailText("...", true);
        element = element.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                context.setLaterRunnable(() -> new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider$1";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        result2.addElement((LookupElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/GormDynamicFinderCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "completeFindOrSave";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletedLookup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addIncompleteLookup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

