/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.gorm.GormVersion;
import org.jetbrains.plugins.grails.gorm.GormVersionKt;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.util.GrailsArtifactTransformerUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightField;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.transformations.AstTransformationSupport;
import org.jetbrains.plugins.groovy.transformations.TransformationContext;

public class GormAstTransformationContributor
implements AstTransformationSupport {
    private static final Collection<String> EXCLUDED_FROM_VALIDATION_API = Arrays.asList("setErrors", "getErrors", "getBeforeValidateHelper", "setBeforeValidateHelper", "getValidator", "setValidator");

    public void applyTransformation(@NotNull TransformationContext context) {
        PsiClass validationApi;
        PsiClass staticApi;
        GlobalSearchScope resolveScope;
        GrTypeDefinition aClass;
        if (context == null) {
            GormAstTransformationContributor.$$$reportNull$$$0(0);
        }
        if (!GormUtils.isGormBean((PsiClass)(aClass = context.getCodeClass())) || !GormAstTransformationContributor.shouldInject((PsiClass)aClass)) {
            return;
        }
        GormAstTransformationContributor.injectIdVersion(context);
        context.addMethod((PsiMethod)new GrLightMethodBuilder(aClass));
        PsiClassType myMapType = TypesUtil.createTypeByFQClassName((String)"java.util.Map", (PsiElement)aClass);
        context.addMethod((PsiMethod)new GrLightMethodBuilder(aClass).addParameter("namedArgs", (PsiType)myMapType));
        GormVersion version = GormVersionKt.getGormVersion((PsiElement)aClass);
        if (version != GormVersion.BELOW_4) {
            return;
        }
        ArrayList methods = new ArrayList();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        PsiClass instanceApi = facade.findClass("org.grails.datastore.gorm.GormInstanceApi", resolveScope = aClass.getResolveScope());
        if (instanceApi != null) {
            GrailsArtifactTransformerUtils.enhanceAst(instanceApi, context, methods, false, new GormAstTransformationMethodFilter(){

                @Override
                public boolean value(PsiMethod method) {
                    if (!super.value(method)) {
                        return false;
                    }
                    String name = method.getName();
                    if (GroovyPropertyUtils.isGetterName((String)name)) {
                        return method.getParameterList().getParametersCount() != 1;
                    }
                    if (GroovyPropertyUtils.isSetterName((String)name)) {
                        return method.getParameterList().getParametersCount() != 2;
                    }
                    return true;
                }
            });
        }
        if ((staticApi = facade.findClass("org.grails.datastore.gorm.GormStaticApi", resolveScope)) != null) {
            GrailsArtifactTransformerUtils.enhanceAst(staticApi, context, methods, true, new GormAstTransformationMethodFilter(){

                @Override
                public boolean value(PsiMethod method) {
                    if (!super.value(method)) {
                        return false;
                    }
                    String name = method.getName();
                    if (GroovyPropertyUtils.isGetterName((String)name)) {
                        return method.getParameterList().getParametersCount() != 1;
                    }
                    if (GroovyPropertyUtils.isSetterName((String)name)) {
                        return method.getParameterList().getParametersCount() != 2;
                    }
                    return true;
                }
            });
        }
        if ((validationApi = facade.findClass("org.grails.datastore.gorm.GormValidationApi", resolveScope)) != null) {
            GrailsArtifactTransformerUtils.enhanceAst(validationApi, context, methods, false, new GormAstTransformationMethodFilter(){

                @Override
                public boolean value(PsiMethod method) {
                    if (!super.value(method)) {
                        return false;
                    }
                    return !EXCLUDED_FROM_VALIDATION_API.contains(method.getName());
                }
            });
        }
        for (PsiMethod method : methods) {
            ((GrLightMethodBuilder)method).setMethodKind(DomainDescriptor.DOMAIN_DYNAMIC_METHOD);
        }
        context.addMethods(methods);
    }

    private static void injectIdVersion(@NotNull TransformationContext context) {
        GrLightField field;
        GrLightField id;
        GrTypeDefinition aClass;
        Map allFields;
        if (context == null) {
            GormAstTransformationContributor.$$$reportNull$$$0(1);
        }
        if (!(allFields = CollectClassMembersUtil.getAllFields((PsiClass)(aClass = context.getCodeClass()), (boolean)false)).containsKey("id")) {
            id = new GrLightField((PsiClass)aClass, "id", "java.lang.Long");
            context.addField((GrField)id);
        }
        if (!allFields.containsKey("version")) {
            id = new GrLightField((PsiClass)aClass, "version", "java.lang.Long");
            context.addField((GrField)id);
        }
        Function<PsiClass, PsiClass> superClass = c -> c == aClass ? context.getSuperClass() : c.getSuperClass();
        Set existingFieldNames = allFields.keySet();
        HashMap<String, Pair<PsiType, PsiElement>> setTypeFields = new HashMap<String, Pair<PsiType, PsiElement>>();
        DomainDescriptor.findAllPropertiesFromField(setTypeFields, "hasMany", aClass, superClass);
        DomainDescriptor.findAllPropertiesFromField(setTypeFields, "relatesToMany", aClass, superClass);
        for (Map.Entry entry : setTypeFields.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (existingFieldNames.contains(fieldName)) continue;
            PsiType type = TypesUtil.createSetType((PsiElement)aClass, (PsiType)((PsiType)((Pair)entry.getValue()).first));
            field = new GrLightField((PsiClass)aClass, fieldName, type, (PsiElement)((Pair)entry.getValue()).second);
            context.addField((GrField)field);
        }
        existingFieldNames = ContainerUtil.union(existingFieldNames, setTypeFields.keySet());
        HashMap<String, Pair<PsiType, PsiElement>> regularTypeFields = new HashMap<String, Pair<PsiType, PsiElement>>();
        DomainDescriptor.findAllPropertiesFromField(regularTypeFields, "hasOne", aClass, superClass);
        DomainDescriptor.findAllPropertiesFromField(regularTypeFields, "belongsTo", aClass, superClass);
        for (Map.Entry entry : regularTypeFields.entrySet()) {
            String fieldName = (String)entry.getKey();
            if (existingFieldNames.contains(fieldName)) continue;
            field = new GrLightField((PsiClass)aClass, fieldName, (PsiType)((Pair)entry.getValue()).first, (PsiElement)((Pair)entry.getValue()).second);
            context.addField((GrField)field);
        }
    }

    private static boolean shouldInject(PsiClass aClass) {
        if (aClass.isEnum()) {
            return false;
        }
        VirtualFile virtualFile = aClass.getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile folder = virtualFile.getParent();
        return folder == null || folder.findChild(aClass.getName() + ".hbm.xml") == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/GormAstTransformationContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyTransformation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "injectIdVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GormAstTransformationMethodFilter
    extends GrailsArtifactTransformerUtils.DefaultFilter {
        public static final GormAstTransformationMethodFilter INSTANCE = new GormAstTransformationMethodFilter();
        private static final Set<String> EXCLUDED_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"setProperty", "getProperty", "getMetaClass", "setMetaClass", "invokeMethod", "getMethods", "getExtendedMethods", "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll", "setTransactionManager"});

        private GormAstTransformationMethodFilter() {
        }

        @Override
        public boolean value(PsiMethod method) {
            return super.value(method) && !EXCLUDED_METHODS.contains(method.getName());
        }
    }
}

