/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.MemberProvider;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.grails.references.domain.DomainDescriptor;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.domain.namedQuery.NamedQueryDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStaticChecker;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class DomainMembersProvider
extends MemberProvider {
    public static final Object FINDER_METHOD_MARKER = new Object();
    public static final String[] MODIFIERS_PUBLIC_STATIC = new String[]{"public", "static"};

    @Override
    public void processMembers(PsiScopeProcessor processor, PsiClass psiClass, PsiElement place) {
        if (place instanceof GrReferenceExpression) {
            GrReferenceExpression refExpr = (GrReferenceExpression)place;
            DomainMembersProvider.multiResolve(refExpr, psiClass, processor);
        } else {
            DomainMembersProvider.processSimpleMembers(psiClass, processor);
        }
    }

    private static boolean processSimpleMembers(PsiClass domainClass, PsiScopeProcessor processor) {
        String name = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)((ElementClassHint)processor.getHint(ElementClassHint.KEY)))) {
            DomainDescriptor descriptor = DomainDescriptor.getDescriptor(domainClass);
            if (!descriptor.processStaticMethods(processor, name, ResolveState.initial())) {
                return false;
            }
            if (!descriptor.processDynamicMethods(processor, name, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private static boolean executeNamedQueryDescriptor(PsiScopeProcessor processor, NamedQueryDescriptor descr, ElementClassHint classHint) {
        if (ResolveUtil.shouldProcessProperties((ElementClassHint)classHint) && !processor.execute((PsiElement)descr.getVariable(), ResolveState.initial())) {
            return false;
        }
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)classHint)) {
            for (PsiMethod method : descr.getMethods()) {
                if (processor.execute((PsiElement)method, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean multiResolve(GrReferenceExpression myRefExpr, PsiClass domainClass, PsiScopeProcessor processor) {
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        String name = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        boolean isInStaticContext = GrStaticChecker.isInStaticContext((PsiElement)myRefExpr, (PsiClass)domainClass);
        DomainDescriptor descriptor = DomainDescriptor.getDescriptor(domainClass);
        if (GormUtils.isNamedQueryDeclaration((PsiElement)myRefExpr)) {
            return true;
        }
        if (!DomainMembersProvider.processNamedQueries(processor, descriptor, name, classHint)) {
            return false;
        }
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)classHint)) {
            if (!descriptor.processStaticMethods(processor, name, ResolveState.initial())) {
                return false;
            }
            if (!isInStaticContext && !descriptor.processDynamicMethods(processor, name, ResolveState.initial())) {
                return false;
            }
            if (!DomainMembersProvider.testForStaticFinderMethod(myRefExpr, descriptor, processor)) {
                return false;
            }
        }
        return true;
    }

    public static boolean processNamedQueries(PsiScopeProcessor processor, DomainDescriptor descriptor, String nameHint, ElementClassHint classHint) {
        if (nameHint == null) {
            for (NamedQueryDescriptor descr : descriptor.getNamedQueries().values()) {
                if (DomainMembersProvider.executeNamedQueryDescriptor(processor, descr, classHint)) continue;
                return false;
            }
        } else {
            NamedQueryDescriptor descr = descriptor.getNamedQueries().get(nameHint);
            if (descr != null && !DomainMembersProvider.executeNamedQueryDescriptor(processor, descr, classHint)) {
                return false;
            }
        }
        return true;
    }

    private static boolean testForStaticFinderMethod(GrReferenceExpression refExpr, DomainDescriptor descriptor, PsiScopeProcessor processor) {
        GrLightMethodBuilder finderMethod;
        String name = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (name == null) {
            PsiClassType returnType = TypesUtil.createListType((PsiClass)descriptor.getDomainClass());
            for (String fieldName : descriptor.getPersistentProperties().keySet()) {
                GrLightMethodBuilder builder = new GrLightMethodBuilder(descriptor.getDomainClass().getManager(), "listOrderBy" + StringUtil.capitalize((String)fieldName));
                builder.setModifiers(MODIFIERS_PUBLIC_STATIC);
                builder.setReturnType((PsiType)returnType);
                builder.addOptionalParameter("args", "java.util.Map");
                builder.setMethodKind(FINDER_METHOD_MARKER);
                if (processor.execute((PsiElement)builder, ResolveState.initial())) continue;
                return false;
            }
            return true;
        }
        if (name.startsWith("listOrderBy")) {
            if (descriptor.getPersistentProperties().containsKey(StringUtil.decapitalize((String)name.substring("listOrderBy".length())))) {
                PsiClassType returnType = TypesUtil.createListType((PsiClass)descriptor.getDomainClass());
                GrLightMethodBuilder builder = new GrLightMethodBuilder(descriptor.getDomainClass().getManager(), name);
                builder.setModifiers(MODIFIERS_PUBLIC_STATIC);
                builder.setReturnType((PsiType)returnType);
                builder.addOptionalParameter("args", "java.util.Map");
                builder.setMethodKind(FINDER_METHOD_MARKER);
                builder.setContainingClass(descriptor.getDomainClass());
                if (!processor.execute((PsiElement)builder, ResolveState.initial())) {
                    return false;
                }
            }
            return true;
        }
        name = refExpr.getReferenceName();
        return name == null || (finderMethod = DomainMembersProvider.parseFinderMethod(name, descriptor)) == null || processor.execute((PsiElement)finderMethod, ResolveState.initial());
    }

    @Nullable
    public static GrLightMethodBuilder parseFinderMethod(@NotNull String name, @NotNull DomainDescriptor descriptor) {
        PsiPrimitiveType returnType;
        DomainClassUtils.FinderMethod finderMethod;
        if (name == null) {
            DomainMembersProvider.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            DomainMembersProvider.$$$reportNull$$$0(1);
        }
        if ((finderMethod = DomainClassUtils.parseFinderMethod(name)) == null) {
            return null;
        }
        String prefix = finderMethod.getPrefix();
        if (prefix.equals("countBy")) {
            returnType = PsiType.INT;
        } else if (prefix.equals("findBy") || prefix.equals("findOrCreateBy") || prefix.equals("findOrSaveBy")) {
            returnType = PsiTypesUtil.getClassType((PsiClass)descriptor.getDomainClass());
        } else {
            assert (prefix.equals("findAllBy"));
            returnType = TypesUtil.createListType((PsiClass)descriptor.getDomainClass());
        }
        GrLightMethodBuilder builder = new GrLightMethodBuilder(descriptor.getDomainClass().getManager(), name);
        builder.setModifiers(MODIFIERS_PUBLIC_STATIC);
        builder.setReturnType((PsiType)returnType);
        builder.setContainingClass(descriptor.getDomainClass());
        Map<String, Pair<PsiType, PsiElement>> properties = descriptor.getPersistentProperties();
        for (DomainClassUtils.Condition condition : finderMethod.getConditions()) {
            String finderExpr = condition.getFinderExpr();
            String capitalizedName = condition.getFieldName();
            Object fieldName = StringUtil.decapitalize((String)capitalizedName);
            Pair<PsiType, PsiElement> pair = properties.get(fieldName);
            if (pair == null) {
                if (((String)fieldName).length() > 1 && Character.isUpperCase(((String)fieldName).charAt(0))) {
                    fieldName = Character.toLowerCase(((String)fieldName).charAt(0)) + ((String)fieldName).substring(1);
                    pair = properties.get(fieldName);
                }
                if (pair == null) {
                    return null;
                }
            }
            PsiType propertyType = (PsiType)pair.getFirst();
            if (finderExpr == null || DomainClassUtils.DOMAIN_FINDER_EXPRESSIONS_WITH_ONE_PARAMETER.contains(finderExpr)) {
                builder.addParameter((String)fieldName, propertyType);
                continue;
            }
            if (finderExpr.equals("InList")) {
                builder.addParameter("list", "java.util.List");
                continue;
            }
            if (finderExpr.equals("InRange")) {
                builder.addParameter("range", "groovy.lang.Range");
                continue;
            }
            if (!finderExpr.equals("Between")) continue;
            builder.addParameter("lower" + capitalizedName, propertyType);
            builder.addParameter("upper" + capitalizedName, propertyType);
        }
        builder.addOptionalParameter("paginateParams", "java.util.Map");
        builder.setMethodKind(FINDER_METHOD_MARKER);
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/grails/references/domain/DomainMembersProvider";
        objectArray[2] = "parseFinderMethod";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

