/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.domain;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class DomainClassUtils {
    @NonNls
    public static final String DOMAIN_FIND = "findBy";
    @NonNls
    public static final String DOMAIN_FIND_ALL = "findAllBy";
    @NonNls
    public static final String DOMAIN_COUNT = "countBy";
    @NonNls
    public static final String DOMAIN_FIND_OR_CREATE = "findOrCreateBy";
    @NonNls
    public static final String DOMAIN_FIND_OR_SAVE = "findOrSaveBy";
    @NonNls
    public static final String DOMAIN_LIST_ORDER = "listOrderBy";
    @NonNls
    public static final String[] DOMAIN_CONNECTIVES = new String[]{"Or", "And"};
    public static final String[] DOMAIN_FINDER_EXPRESSIONS_2_0 = new String[]{"Equal", "NotEqual", "InList", "InRange", "Between", "Like", "Ilike", "Rlike", "GreaterThanEquals", "LessThanEquals", "GreaterThan", "LessThan", "IsNull", "IsNotNull", "IsEmpty", "IsNotEmpty"};
    public static final String[] DOMAIN_FINDER_EXPRESSIONS_OLD = new String[]{"LessThanEquals", "LessThan", "GreaterThanEquals", "GreaterThan", "Between", "Like", "Ilike", "Rlike", "IsNotNull", "IsNull", "NotEqual", "InList"};
    public static final Set<String> DOMAIN_FINDER_EXPRESSIONS_WITH_ONE_PARAMETER = ContainerUtil.newHashSet((Object[])new String[]{"LessThan", "LessThanEquals", "GreaterThan", "GreaterThanEquals", "Like", "Ilike", "Rlike", "NotEqual", "Equal"});
    public static final String[] FINDER_PREFIXES = new String[]{"countBy", "findBy", "findAllBy", "findOrCreateBy", "findOrSaveBy"};
    private static final Pattern FINDER_METHOD_PART_PATTERN = Pattern.compile("(\\w+?)(?:(Not)?(" + StringUtil.join((String[])DOMAIN_FINDER_EXPRESSIONS_2_0, (String)"|") + "))?");
    private static final Pattern[] AND_OPERATOR = new Pattern[]{Pattern.compile("\\w+(And)\\p{Upper}")};
    private static final Pattern[] OPERATOR_PATTERNS = new Pattern[]{AND_OPERATOR[0], Pattern.compile("\\w+(Or)\\p{Upper}")};

    private DomainClassUtils() {
    }

    private static PsiFile @NotNull [] getDomainClasses(Project project, @Nullable VirtualFile domainDirectory) {
        if (domainDirectory == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                DomainClassUtils.$$$reportNull$$$0(0);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        PsiDirectory domainPsiDirectory = PsiManager.getInstance((Project)project).findDirectory(domainDirectory);
        return DomainClassUtils.getAllDomainClasses(domainPsiDirectory);
    }

    private static PsiFile @NotNull [] getAllDomainClasses(PsiDirectory domainDirectory) {
        ArrayList<PsiFile> children = new ArrayList<PsiFile>();
        List<PsiFile> list = DomainClassUtils.getAllChildrenRecursively(domainDirectory, children);
        PsiFile[] psiFileArray = PsiUtilCore.toPsiFileArray(list);
        if (psiFileArray == null) {
            DomainClassUtils.$$$reportNull$$$0(1);
        }
        return psiFileArray;
    }

    private static List<PsiFile> getAllChildrenRecursively(PsiDirectory domainDirectory, List<PsiFile> children) {
        PsiFile[] files;
        for (PsiFile psiFile : files = domainDirectory.getFiles()) {
            if (!(psiFile instanceof GroovyFile) || ((GroovyFile)psiFile).isScript()) continue;
            children.add(psiFile);
        }
        for (PsiFile psiFile : domainDirectory.getSubdirectories()) {
            DomainClassUtils.getAllChildrenRecursively((PsiDirectory)psiFile, children);
        }
        return children;
    }

    public static Map<DomainClassNode, List<DomainClassRelationsInfo>> buildNodesAndEdges(Project project, @Nullable VirtualFile domainDirectory) {
        if (project.isDisposed()) {
            return Collections.emptyMap();
        }
        PsiFile[] domainClasses = DomainClassUtils.getDomainClasses(project, domainDirectory);
        HashMap<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges = new HashMap<DomainClassNode, List<DomainClassRelationsInfo>>();
        for (PsiFile domainClass : domainClasses) {
            GrTypeDefinition[] typeDefinitions;
            if (!(domainClass instanceof GroovyFile)) continue;
            GroovyFile groovyDomainClass = (GroovyFile)domainClass;
            for (GrTypeDefinition typeDefinition : typeDefinitions = groovyDomainClass.getTypeDefinitions()) {
                if (typeDefinition.getQualifiedName() == null) continue;
                DomainClassUtils.buildMapForTypeDefinition(sourcesToOutEdges, typeDefinition);
            }
        }
        for (DomainClassNode node : sourcesToOutEdges.keySet()) {
            DomainClassUtils.processRightsRelationOfThisClass(node.getTypeDefinition(), sourcesToOutEdges);
        }
        return sourcesToOutEdges;
    }

    public static void buildMapForTypeDefinition(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, GrTypeDefinition typeDefinition) {
        GrTypeDefinitionBody body = typeDefinition.getBody();
        HashSet<String> transients = new HashSet<String>();
        if (body == null) {
            return;
        }
        GrField[] fields = body.getFields();
        DomainClassUtils.buildTransients(fields, transients);
        sourcesToOutEdges.put(new DomainClassNode((PsiClass)typeDefinition), new ArrayList());
        DomainClassUtils.buildSourceToOutEdgesMapByFields(fields, sourcesToOutEdges, transients);
    }

    private static boolean isTransient(String varName, Set<String> transients) {
        return transients.contains(varName);
    }

    private static void buildTransients(GrField[] fields, Set<String> transients) {
        for (GrField field : fields) {
            GrModifierList modifierList = field.getModifierList();
            assert (modifierList != null);
            if (!modifierList.hasModifierProperty("static") || !"transients".equals(field.getName())) continue;
            GrExpression initializer = field.getInitializerGroovy();
            if (!(initializer instanceof GrListOrMap)) {
                return;
            }
            GrListOrMap list = (GrListOrMap)initializer;
            for (GrExpression expression : list.getInitializers()) {
                if (expression instanceof GrString) {
                    String varNameStr = expression.getText();
                    String varName = varNameStr.substring(1, varNameStr.length() - 2);
                    transients.add(varName);
                    continue;
                }
                transients.add(expression.getText());
            }
        }
    }

    private static boolean buildSourceToOutEdgesMapByFields(GrField[] fields, Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, Set<String> transients) {
        boolean wasAdded = false;
        for (GrField field : fields) {
            if (DomainClassUtils.isTransient(field.getName(), transients)) continue;
            if (DomainClassUtils.isBelongsToField(field)) {
                DomainClassUtils.buildBelongsToSourcesToOutEdges(sourcesToOutEdges, field);
                wasAdded = true;
                continue;
            }
            if (!DomainClassUtils.isHasManyField(field)) continue;
            DomainClassUtils.buildHasManySourcesToOutEdgesMap(sourcesToOutEdges, field);
            wasAdded = true;
        }
        for (GrField field : fields) {
            if (DomainClassUtils.isTransient(field.getName(), transients) || DomainClassUtils.isBelongsToField(field) || DomainClassUtils.isHasManyField(field)) continue;
            PsiClass thisClass = field.getContainingClass();
            List<DomainClassRelationsInfo> outEdges = DomainClassUtils.getOutEdgesByTypeDef(thisClass, sourcesToOutEdges);
            String typeCanonicalString = field.getType().getCanonicalText();
            String fieldName = field.getName();
            boolean isStrong = true;
            if (outEdges != null) {
                for (DomainClassRelationsInfo edge : outEdges) {
                    if (DomainClassRelationsInfo.Relation.BELONGS_TO == edge.getRelation() && typeCanonicalString.equals(edge.getTarget().getTypeDefinition().getQualifiedName())) {
                        isStrong = false;
                        break;
                    }
                    if (fieldName == null) {
                        return false;
                    }
                    if (DomainClassRelationsInfo.Relation.HAS_MANY != edge.getRelation() || !typeCanonicalString.equals(edge.getTarget().getTypeDefinition().getQualifiedName()) || !fieldName.equals(edge.getVarName())) continue;
                    isStrong = false;
                    break;
                }
            }
            if (isStrong) {
                DomainClassUtils.buildStrongSourceToOutEdgesMap(sourcesToOutEdges, field);
                wasAdded = true;
                continue;
            }
            wasAdded = false;
        }
        return wasAdded;
    }

    private static void processRightsRelationOfThisClass(PsiClass thisClass, Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges) {
        DomainClassUtils.processRightRelationsInNode(sourcesToOutEdges, thisClass);
        DomainClassUtils.processRightRelationsBetweenNodes(sourcesToOutEdges, thisClass);
    }

    private static synchronized void processRightRelationsBetweenNodes(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, PsiClass thisClass) {
        DomainClassNode thisClassNode = new DomainClassNode(thisClass);
        List<DomainClassRelationsInfo> thisOutEdges = sourcesToOutEdges.get(thisClassNode);
        if (thisOutEdges == null) {
            return;
        }
        Iterator<DomainClassRelationsInfo> thisOutEdgeIterator = thisOutEdges.iterator();
        block0: while (thisOutEdgeIterator.hasNext()) {
            List<DomainClassRelationsInfo> backs;
            DomainClassRelationsInfo thisOutEdge = thisOutEdgeIterator.next();
            DomainClassNode target = thisOutEdge.getTarget();
            if (target.equals(thisClassNode) || (backs = sourcesToOutEdges.get(target)) == null) continue;
            Iterator<DomainClassRelationsInfo> backIt = backs.iterator();
            while (backIt.hasNext()) {
                DomainClassRelationsInfo back = backIt.next();
                if (!thisClassNode.equals(back.getTarget())) continue;
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.STRONG && back.getRelation() == DomainClassRelationsInfo.Relation.STRONG) {
                    back.setRelation(DomainClassRelationsInfo.Relation.DOUBLESTRONG);
                    thisOutEdgeIterator.remove();
                    continue block0;
                }
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.STRONG && back.getRelation() == DomainClassRelationsInfo.Relation.BELONGS_TO) {
                    backIt.remove();
                    continue;
                }
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.BELONGS_TO && back.getRelation() == DomainClassRelationsInfo.Relation.STRONG) {
                    thisOutEdgeIterator.remove();
                    continue block0;
                }
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.BELONGS_TO && back.getRelation() == DomainClassRelationsInfo.Relation.BELONGS_TO) {
                    thisOutEdgeIterator.remove();
                    backIt.remove();
                    continue block0;
                }
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.HAS_MANY && back.getRelation() == DomainClassRelationsInfo.Relation.HAS_MANY) {
                    back.setRelation(DomainClassRelationsInfo.Relation.MANY_TO_MANY);
                    thisOutEdgeIterator.remove();
                    continue block0;
                }
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.MANY_TO_MANY) {
                    backIt.remove();
                    continue block0;
                }
                if (back.getRelation() == DomainClassRelationsInfo.Relation.MANY_TO_MANY) {
                    thisOutEdgeIterator.remove();
                    continue block0;
                }
                if (thisOutEdge.getRelation() == DomainClassRelationsInfo.Relation.HAS_MANY) {
                    backIt.remove();
                    continue block0;
                }
                if (back.getRelation() != DomainClassRelationsInfo.Relation.HAS_MANY) continue;
                thisOutEdgeIterator.remove();
                continue block0;
            }
        }
    }

    private static synchronized void processRightRelationsInNode(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, PsiClass thisClass) {
        List<DomainClassRelationsInfo> outEdges = sourcesToOutEdges.get(new DomainClassNode(thisClass));
        if (outEdges == null) {
            return;
        }
        block0: for (int i2 = 0; i2 < outEdges.size(); ++i2) {
            DomainClassRelationsInfo edge1 = outEdges.get(i2);
            for (int j = i2 + 1; j < outEdges.size(); ++j) {
                DomainClassRelationsInfo edge2 = outEdges.get(j);
                if (!edge1.getTarget().equals(edge2.getTarget())) continue;
                if (edge1.getRelation() == DomainClassRelationsInfo.Relation.HAS_MANY && (edge2.getRelation() == DomainClassRelationsInfo.Relation.BELONGS_TO || edge2.getRelation() == DomainClassRelationsInfo.Relation.STRONG)) {
                    outEdges.remove(edge2);
                    continue;
                }
                if (edge2.getRelation() != DomainClassRelationsInfo.Relation.HAS_MANY || edge1.getRelation() != DomainClassRelationsInfo.Relation.BELONGS_TO && edge1.getRelation() != DomainClassRelationsInfo.Relation.STRONG) continue;
                outEdges.remove(edge1);
                continue block0;
            }
        }
    }

    private static List<DomainClassRelationsInfo> getOutEdgesByTypeDef(PsiClass thisClass, Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges) {
        for (DomainClassNode node : sourcesToOutEdges.keySet()) {
            if (!node.getTypeDefinition().equals(thisClass)) continue;
            return sourcesToOutEdges.get(node);
        }
        return new ArrayList<DomainClassRelationsInfo>();
    }

    public static boolean isBelongsToField(GrField field) {
        return field.hasModifierProperty("static") && "belongsTo".equals(field.getName());
    }

    public static boolean isHasManyField(GrField field) {
        return field.hasModifierProperty("static") && "hasMany".equals(field.getName());
    }

    private static void buildStrongSourceToOutEdgesMap(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, GrField field) {
        PsiClass sourceClass = field.getContainingClass();
        String varName = field.getName();
        GrTypeElement type = field.getTypeElementGroovy();
        if (type == null) {
            return;
        }
        if (!(type instanceof GrClassTypeElement)) {
            return;
        }
        GrCodeReferenceElement targetClass = ((GrClassTypeElement)type).getReferenceElement();
        PsiElement psiClass = targetClass.resolve();
        if (!(psiClass instanceof PsiClass)) {
            return;
        }
        if (!GormUtils.isGormBean((PsiClass)psiClass)) {
            return;
        }
        DomainClassUtils.addEdgeWithName(sourcesToOutEdges, varName, (PsiReference)targetClass, DomainClassRelationsInfo.Relation.STRONG, sourceClass);
    }

    public static void buildBelongsToSourcesToOutEdges(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, GrField field) {
        GrExpression expression = field.getInitializerGroovy();
        if (expression == null) {
            return;
        }
        PsiClass sourceClass = field.getContainingClass();
        if (sourceClass.getQualifiedName() == null) {
            return;
        }
        if (expression instanceof GrListOrMap) {
            DomainClassUtils.buildSourcesToOutEdgesMapFromListOrMap(sourcesToOutEdges, field.getInitializerGroovy(), DomainClassRelationsInfo.Relation.BELONGS_TO, sourceClass);
        } else {
            DomainClassUtils.findVarNameAndAddEdge(sourcesToOutEdges, expression, DomainClassRelationsInfo.Relation.BELONGS_TO, sourceClass);
        }
    }

    public static void buildHasManySourcesToOutEdgesMap(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, GrField field) {
        PsiClass psiClass = field.getContainingClass();
        if (psiClass.getQualifiedName() == null) {
            return;
        }
        DomainClassUtils.buildSourcesToOutEdgesMapFromListOrMap(sourcesToOutEdges, field.getInitializerGroovy(), DomainClassRelationsInfo.Relation.HAS_MANY, psiClass);
    }

    private static void buildSourcesToOutEdgesMapFromListOrMap(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, GrExpression initializer, DomainClassRelationsInfo.Relation relation, PsiClass sourceClass) {
        GrNamedArgument[] grNamedArguments;
        GrExpression[] expressions;
        if (!(initializer instanceof GrListOrMap)) {
            return;
        }
        GrListOrMap list = (GrListOrMap)initializer;
        for (GrExpression expression : expressions = list.getInitializers()) {
            DomainClassUtils.findVarNameAndAddEdge(sourcesToOutEdges, expression, relation, sourceClass);
        }
        for (GrNamedArgument namedArgument : grNamedArguments = list.getNamedArguments()) {
            GrArgumentLabel argumentLabel = namedArgument.getLabel();
            if (argumentLabel == null) {
                return;
            }
            String varName = argumentLabel.getName();
            if (varName == null) {
                return;
            }
            GrExpression grExpression = namedArgument.getExpression();
            if (grExpression == null) {
                return;
            }
            DomainClassUtils.addEdgeWithName(sourcesToOutEdges, varName, grExpression.getReference(), relation, sourceClass);
        }
    }

    private static void findVarNameAndAddEdge(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, GrExpression expression, DomainClassRelationsInfo.Relation relation, PsiClass containingClass) {
        PsiReference reference = expression.getReference();
        if (reference == null) {
            return;
        }
        PsiElement targetClass = reference.resolve();
        if (!(targetClass instanceof PsiClass) || ((PsiClass)targetClass).getQualifiedName() == null) {
            return;
        }
        DomainClassNode target = new DomainClassNode((PsiClass)targetClass);
        String varName = DomainClassUtils.findBelongsToItemFieldName(containingClass, target.getUniqueName());
        DomainClassUtils.addEdgeWithName(sourcesToOutEdges, varName, expression.getReference(), relation, containingClass);
    }

    private static void addEdgeWithName(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, String varName, PsiReference domainClassReference, DomainClassRelationsInfo.Relation relation, PsiClass sourceClass) {
        DomainClassNode source = new DomainClassNode(sourceClass);
        if (domainClassReference == null) {
            return;
        }
        PsiElement targetClass = domainClassReference.resolve();
        if (!(targetClass instanceof PsiClass)) {
            return;
        }
        DomainClassNode target = new DomainClassNode((PsiClass)targetClass);
        DomainClassRelationsInfo outEdge = new DomainClassRelationsInfo(source, target, relation);
        outEdge.setVarName(varName);
        DomainClassUtils.addOutEdgeToSourceMap(sourcesToOutEdges, source, outEdge);
    }

    private static String findBelongsToItemFieldName(PsiClass typeDefinition, String type) {
        PsiField[] fields;
        for (PsiField field : fields = typeDefinition.getFields()) {
            if (!field.getType().equalsToText(type)) continue;
            return field.getName();
        }
        return type;
    }

    private static void addOutEdgeToSourceMap(Map<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges, DomainClassNode source, DomainClassRelationsInfo outEdge) {
        List<DomainClassRelationsInfo> outEdges = sourcesToOutEdges.get(source);
        if (outEdges == null) {
            outEdges = new ArrayList<DomainClassRelationsInfo>();
        }
        outEdges.add(outEdge);
        sourcesToOutEdges.put(source, outEdges);
    }

    public static boolean endsWithDomainConnectivity(String name) {
        for (String connective : DOMAIN_CONNECTIVES) {
            if (!name.endsWith(connective)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiType getDCPropertyType(PsiElement property) {
        if (property instanceof GrField) {
            return ((GrField)property).getType();
        }
        if (property instanceof PsiMethod) {
            return PsiUtil.getSmartReturnType((PsiMethod)((PsiMethod)property));
        }
        if (property instanceof GrArgumentLabel) {
            PsiElement namedArgument = property.getParent();
            if (!(namedArgument instanceof GrNamedArgument)) {
                return null;
            }
            GrExpression expression = ((GrNamedArgument)namedArgument).getExpression();
            if (!(expression instanceof GrReferenceExpression)) {
                return null;
            }
            PsiElement resolved = ((GrReferenceExpression)expression).resolve();
            if (!(resolved instanceof PsiClass)) {
                return null;
            }
            return JavaPsiFacade.getElementFactory((Project)property.getProject()).createType((PsiClass)resolved);
        }
        return null;
    }

    @Nullable
    public static FinderMethod parseFinderMethod(@NotNull String methodName) {
        if (methodName == null) {
            DomainClassUtils.$$$reportNull$$$0(2);
        }
        String prefix = null;
        for (String p : FINDER_PREFIXES) {
            if (!methodName.startsWith(p)) continue;
            prefix = p;
            break;
        }
        if (prefix == null) {
            return null;
        }
        String queryText = methodName.substring(prefix.length());
        boolean saveOrCreate = prefix.equals(DOMAIN_FIND_OR_CREATE) || prefix.equals(DOMAIN_FIND_OR_SAVE);
        for (Pattern operatorPattern : saveOrCreate ? AND_OPERATOR : OPERATOR_PATTERNS) {
            Matcher matcher = operatorPattern.matcher(queryText);
            if (!matcher.find()) continue;
            String operator = matcher.group(1);
            String[] conditionsText = queryText.split(operator);
            Condition[] conditions = new Condition[conditionsText.length];
            for (int i2 = 0; i2 < conditionsText.length; ++i2) {
                Condition condition = Condition.createFromText(conditionsText[i2]);
                if (condition == null) {
                    return null;
                }
                if (saveOrCreate && (condition.isNegative() || condition.getFinderExpr() != null && !"Equal".equals(condition.getFinderExpr()))) {
                    return null;
                }
                conditions[i2] = condition;
            }
            return new FinderMethod(prefix, operator, conditions);
        }
        Condition condition = Condition.createFromText(queryText);
        if (condition == null) {
            return null;
        }
        return new FinderMethod(prefix, condition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/domain/DomainClassUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDomainClasses";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/DomainClassUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseFinderMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Condition {
        private String myFieldName;
        private boolean myNegative;
        private final String myFinderExpr;

        public Condition(@NotNull String fieldName, boolean negative, @Nullable String myFinderExpr) {
            if (fieldName == null) {
                Condition.$$$reportNull$$$0(0);
            }
            assert (!negative || myFinderExpr != null);
            this.myFieldName = fieldName;
            this.myNegative = negative;
            this.myFinderExpr = myFinderExpr;
        }

        @Nullable
        private static Condition createFromText(String text) {
            Matcher m = FINDER_METHOD_PART_PATTERN.matcher(text);
            if (!m.matches()) {
                return null;
            }
            return new Condition(m.group(1), m.group(2) != null, m.group(3));
        }

        public int getLength() {
            return this.myFieldName.length() + (this.myNegative ? 3 : 0) + (this.myFinderExpr == null ? 0 : this.myFinderExpr.length());
        }

        @NotNull
        public String getFieldName() {
            String string = this.myFieldName;
            if (string == null) {
                Condition.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void setFieldName(@NotNull String fieldName) {
            if (fieldName == null) {
                Condition.$$$reportNull$$$0(2);
            }
            this.myFieldName = fieldName;
        }

        public boolean isNegative() {
            return this.myNegative;
        }

        public void setNegative(boolean negative) {
            this.myNegative = negative;
        }

        @Nullable
        public String getFinderExpr() {
            return this.myFinderExpr;
        }

        public void appendTo(StringBuilder sb) {
            sb.append(this.myFieldName);
            if (this.myNegative) {
                sb.append("Not");
            }
            if (this.myFinderExpr != null) {
                sb.append(this.myFinderExpr);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/references/domain/DomainClassUtils$Condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/references/domain/DomainClassUtils$Condition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFieldName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFieldName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class FinderMethod {
        private final String myPrefix;
        private final Condition[] myConditions;
        private String myOperator;

        public FinderMethod(@NotNull String prefix, @NotNull Condition condition) {
            if (prefix == null) {
                FinderMethod.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                FinderMethod.$$$reportNull$$$0(1);
            }
            this.myPrefix = prefix;
            this.myConditions = new Condition[]{condition};
        }

        public FinderMethod(@NotNull String prefix, @NotNull String operator, Condition @NotNull [] conditions) {
            if (prefix == null) {
                FinderMethod.$$$reportNull$$$0(2);
            }
            if (operator == null) {
                FinderMethod.$$$reportNull$$$0(3);
            }
            if (conditions == null) {
                FinderMethod.$$$reportNull$$$0(4);
            }
            assert (operator.equals("Or") || operator.equals("And"));
            assert (conditions.length > 1);
            this.myPrefix = prefix;
            this.myConditions = conditions;
            this.myOperator = operator;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public Condition[] getConditions() {
            return this.myConditions;
        }

        public String getOperator() {
            return this.myOperator;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.myPrefix);
            this.myConditions[0].appendTo(sb);
            if (this.myOperator != null) {
                for (int i2 = 1; i2 < this.myConditions.length; ++i2) {
                    sb.append(this.myOperator);
                    this.myConditions[i2].appendTo(sb);
                }
            } else assert (this.myConditions.length == 1);
            return sb.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "conditions";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/references/domain/DomainClassUtils$FinderMethod";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

