/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.constraints;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.plugins.grails.references.constraints.GrailsConstraintsUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

final class GrailsConstraintsClosureMemberProvider
extends ClosureMissingMethodContributor {
    GrailsConstraintsClosureMemberProvider() {
    }

    public boolean processMembers(GrClosableBlock closure, PsiScopeProcessor processor, GrReferenceExpression refExpr, ResolveState state) {
        PsiElement eField = closure.getParent();
        if (!(eField instanceof GrField)) {
            return true;
        }
        GrField field = (GrField)eField;
        String fieldName = field.getName();
        if (!"constraints".equals(fieldName) || !field.hasModifierProperty("static")) {
            return true;
        }
        PsiClass aClass = field.getContainingClass();
        if (aClass == null || !GrailsUtils.isValidatedClass(aClass)) {
            return true;
        }
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (nameHint == null) {
            for (PsiField psiField : aClass.getAllFields()) {
                PsiMethod method;
                if (psiField.hasModifierProperty("static") || processor.execute((PsiElement)(method = GrailsConstraintsUtil.createMethod(psiField.getName(), (PsiElement)psiField, psiField.getType(), aClass)), ResolveState.initial())) continue;
                return false;
            }
        } else {
            PsiMethod method;
            PsiField psiField = aClass.findFieldByName(nameHint, true);
            if (psiField != null && !psiField.hasModifierProperty("static") && !processor.execute((PsiElement)(method = GrailsConstraintsUtil.createMethod(nameHint, (PsiElement)psiField, psiField.getType(), aClass)), ResolveState.initial())) {
                return false;
            }
        }
        return GrailsConstraintsUtil.processImportFromMethod(processor, state, (PsiElement)aClass, nameHint);
    }
}

