/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.references.common.GspTagWrapper;
import org.jetbrains.plugins.grails.references.common.PluginSupportFileReferenceSet;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class TemplateFileReferenceSet
extends PluginSupportFileReferenceSet {
    private static final Pattern TEMPLATE_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_\\-]+");
    private static final String WEB_APP = "web-app";
    private final String myControllerName;
    private final GspTagWrapper myTagWrapper;

    public TemplateFileReferenceSet(@Nullable String controllerName, @NotNull String str, @NotNull PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed, @Nullable GspTagWrapper tagWrapper) {
        if (str == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(1);
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed, false);
        this.myControllerName = controllerName;
        this.myTagWrapper = tagWrapper;
        this.reparse();
    }

    @Nullable
    private FileReference getContextPathReference() {
        if (this.myTagWrapper == null) {
            return null;
        }
        PsiElement contextPathElement = this.myTagWrapper.getAttributeValue("contextPath");
        if (contextPathElement != null) {
            for (PsiReference ref : contextPathElement.getReferences()) {
                if (!(ref instanceof FileReference)) continue;
                return ((FileReference)ref).getLastFileReference();
            }
        }
        return null;
    }

    @Override
    public PluginSupportFileReferenceSet.MyFileReference createNonPluginFileReference(TextRange range, int index, String text) {
        FileReference contextPathRef;
        FileReference prevRef = null;
        if (index == 0 && (contextPathRef = this.getContextPathReference()) instanceof PluginSupportFileReferenceSet.PluginDirReference) {
            prevRef = contextPathRef;
        }
        return new TmplFileReference(range, index, text, this, prevRef);
    }

    private void addRoot(List<PsiFileSystemItem> res, VirtualFile root) {
        if (!this.isAbsolutePathReference() && this.myControllerName != null && (root = root.findChild(this.myControllerName)) == null) {
            return;
        }
        PsiDirectory dir = this.getElement().getManager().findDirectory(root);
        if (dir == null) {
            return;
        }
        res.add((PsiFileSystemItem)dir);
    }

    private void addRootAndGrailsApp(List<PsiFileSystemItem> res, @Nullable VirtualFile root) {
        if (root != null) {
            VirtualFile webAppRoot;
            VirtualFile viewDir;
            VirtualFile grailsApp = root.findChild("grails-app");
            if (grailsApp != null && (viewDir = grailsApp.findChild("views")) != null) {
                this.addRoot(res, viewDir);
            }
            if ((webAppRoot = root.findChild(WEB_APP)) != null) {
                this.addRoot(res, webAppRoot);
            }
            this.addRoot(res, root);
        }
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement pluginElement;
        VirtualFile file = this.getElement().getContainingFile().getOriginalFile().getVirtualFile();
        if (file == null) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                TemplateFileReferenceSet.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<PsiFileSystemItem> res = new ArrayList<PsiFileSystemItem>();
        PsiElement psiElement = pluginElement = this.myTagWrapper == null ? null : this.myTagWrapper.getAttributeValue("plugin");
        if (pluginElement != null) {
            PsiDirectory psiPluginRoot;
            PsiReference pluginRef = pluginElement.getReference();
            if (pluginRef != null && (psiPluginRoot = (PsiDirectory)pluginRef.resolve()) != null) {
                this.addRootAndGrailsApp(res, psiPluginRoot.getVirtualFile());
            }
            ArrayList<PsiFileSystemItem> arrayList = res;
            if (arrayList == null) {
                TemplateFileReferenceSet.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        FileReference contextPathRef = this.getContextPathReference();
        if (contextPathRef != null) {
            if (contextPathRef instanceof PluginSupportFileReferenceSet.PluginDirReference) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    TemplateFileReferenceSet.$$$reportNull$$$0(4);
                }
                return list;
            }
            for (ResolveResult resolveResult : contextPathRef.multiResolve(false)) {
                PsiElement item = resolveResult.getElement();
                if (!(item instanceof PsiFileSystemItem)) continue;
                this.addRootAndGrailsApp(res, ((PsiFileSystemItem)item).getVirtualFile());
            }
            ArrayList<PsiFileSystemItem> arrayList = res;
            if (arrayList == null) {
                TemplateFileReferenceSet.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        VirtualFile root = GrailsUtils.findParent(file, "grails-app");
        if (root != null) {
            root = root.getParent();
        }
        this.addRootAndGrailsApp(res, root);
        ArrayList<PsiFileSystemItem> arrayList = res;
        if (arrayList == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    protected boolean isAcceptToCompletion(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(7);
        }
        return super.isAcceptToCompletion(fileOrDir) || GrailsUtils.getTemplateName(fileOrDir.getName()) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptToCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TmplFileReference
    extends PluginSupportFileReferenceSet.MyFileReference {
        private final FileReference previousRef;

        TmplFileReference(TextRange range, int index, String text, FileReferenceSet set, FileReference previousRef) {
            super(set, range, index, text);
            this.previousRef = previousRef;
        }

        @Override
        public FileReference getPreviousReference() {
            if (this.previousRef != null) {
                return this.previousRef;
            }
            return super.getPreviousReference();
        }

        public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, @NotNull Collection<ResolveResult> result2, boolean caseSensitive) {
            if (text == null) {
                TmplFileReference.$$$reportNull$$$0(0);
            }
            if (context == null) {
                TmplFileReference.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                TmplFileReference.$$$reportNull$$$0(2);
            }
            super.innerResolveInContext(this.isLast() ? GrailsUtils.getFileNameByTemplateName(text) : text, context, result2, caseSensitive);
        }

        protected Object createLookupItem(PsiElement candidate) {
            if (candidate instanceof GspFile) {
                PsiFile file = (PsiFile)candidate;
                String templateName = GrailsUtils.getTemplateName(file.getName());
                assert (templateName != null);
                return LookupElementBuilder.create((String)templateName).withIcon(file.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }

        @Override
        @Nullable
        protected String pathToString(@NotNull String path) {
            int index;
            if (path == null) {
                TmplFileReference.$$$reportNull$$$0(3);
            }
            if ((index = path.lastIndexOf(47)) == -1) {
                return GrailsUtils.getTemplateName(path);
            }
            String templateName = GrailsUtils.getTemplateName(path.substring(index + 1));
            if (templateName == null) {
                return null;
            }
            return path.substring(0, index + 1) + templateName;
        }

        public LocalQuickFix[] getQuickFixes() {
            if (!this.isLast()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            String text = this.getText();
            if (!TEMPLATE_NAME_PATTERN.matcher(text).matches()) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            VirtualFile context = null;
            for (PsiFileSystemItem item : this.getContexts()) {
                VirtualFile virtualFile = item.getVirtualFile();
                if (virtualFile == null || !virtualFile.isDirectory()) continue;
                if (context == null) {
                    context = virtualFile;
                    continue;
                }
                if (VfsUtilCore.isAncestor((VirtualFile)context, (VirtualFile)virtualFile, (boolean)false)) {
                    context = virtualFile;
                    continue;
                }
                if (VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)context, (boolean)false) || virtualFile.getName().equals(TemplateFileReferenceSet.WEB_APP)) continue;
                return LocalQuickFix.EMPTY_ARRAY;
            }
            if (context == null) {
                return LocalQuickFix.EMPTY_ARRAY;
            }
            final String templateName = GrailsUtils.getFileNameByTemplateName(text);
            final VirtualFile finalContext = context;
            return new LocalQuickFix[]{new LocalQuickFix(){

                @NotNull
                public String getFamilyName() {
                    String string = GrailsBundle.message("quick.fix.family.name.create.template.0", templateName);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    VirtualFile createdFile;
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    try {
                        createdFile = finalContext.createChildData((Object)project, templateName);
                    }
                    catch (IOException ignored) {
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(createdFile);
                    if (psiFile == null) {
                        return;
                    }
                    psiFile.navigate(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "project";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "descriptor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFamilyName";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "applyFix";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }};
        }

        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getUnresolvedMessagePattern() {
            if (this.isLast()) {
                String string = GrailsBundle.message("unresolved.pattern.cannot.resolve.template.0.gsp", this.getCanonicalText());
                if (string == null) {
                    TmplFileReference.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = super.getUnresolvedMessagePattern();
            if (string == null) {
                TmplFileReference.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/grails/references/common/TemplateFileReferenceSet$TmplFileReference";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "innerResolveInContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "pathToString";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

