/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.common;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.references.common.GrailsFileReferenceSetBase;

public class GrailsRootBasedFileReferenceSet
extends GrailsFileReferenceSetBase {
    private static final Pattern ABSOLUTE_PATH_PATTERN = Pattern.compile("(/|[a-zA-Z]:/).*");

    public GrailsRootBasedFileReferenceSet(@NotNull String str, PsiElement element, int startInElement, PsiReferenceProvider provider, boolean isCaseSensitive, boolean endingSlashNotAllowed) {
        if (str == null) {
            GrailsRootBasedFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(str, element, startInElement, provider, isCaseSensitive, endingSlashNotAllowed);
    }

    @Override
    protected VirtualFile getDefaultContext(boolean isAbsolute) {
        if (isAbsolute) {
            int rootIndex = this.getPathString().indexOf(47);
            if (rootIndex == -1) {
                return null;
            }
            return LocalFileSystem.getInstance().findFileByPath(this.getPathString().substring(0, rootIndex + 1));
        }
        PsiFile file = this.getElement().getContainingFile().getOriginalFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex().getContentRootForFile(virtualFile);
    }

    public boolean isAbsolutePathReference() {
        return ABSOLUTE_PATH_PATTERN.matcher(this.getPathString()).matches();
    }

    @Override
    protected String makePathAbsolute(String path) {
        Matcher matcher = ABSOLUTE_PATH_PATTERN.matcher(this.getPathString());
        matcher.matches();
        return matcher.group(1) + path;
    }

    public static PsiReference[] createReferences(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            GrailsRootBasedFileReferenceSet.$$$reportNull$$$0(1);
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        int offset = range.getStartOffset();
        String text = range.substring(psiElement.getText());
        String trimedUrl = PathReference.trimPath((String)text);
        if (trimedUrl.trim().length() == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        GrailsRootBasedFileReferenceSet set = new GrailsRootBasedFileReferenceSet(text, psiElement, offset, null, true, true);
        return set.getAllReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/references/common/GrailsRootBasedFileReferenceSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

