/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.pluginSupport.shiro.GrailsShiroAccessControlMethodProvider;
import org.jetbrains.plugins.grails.references.domain.GormConstraintMethodProvider;
import org.jetbrains.plugins.grails.references.domain.GormMappingMethodProvider;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.references.filter.FilterClosureMemberProvider;
import org.jetbrains.plugins.grails.references.jobs.JobClosureMethodProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;

public final class GrailsClosureMemberContributor
extends ClosureMissingMethodContributor {
    private static final Map<String, Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>> map = new HashMap<String, Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>>();

    public boolean processMembers(GrClosableBlock closure, PsiScopeProcessor processor, GrReferenceExpression refExpr, ResolveState state) {
        PsiElement eField = closure.getParent();
        if (!(eField instanceof GrField)) {
            return true;
        }
        GrField field = (GrField)eField;
        String fieldName = field.getName();
        Trinity<GrailsArtifact, Boolean, ? extends MethodProvider> trinity = map.get(fieldName);
        if (trinity == null) {
            return true;
        }
        PsiClass aClass = field.getContainingClass();
        if (!(((GrailsArtifact)((Object)trinity.first)).isInstance(aClass) || trinity.first == GrailsArtifact.DOMAIN && GormUtils.isStandaloneGormBean(aClass))) {
            return true;
        }
        if (((Boolean)trinity.second).booleanValue() && !field.hasModifierProperty("static")) {
            return true;
        }
        return ((MethodProvider)trinity.third).processMembers(closure, aClass, processor, refExpr, state);
    }

    static {
        map.put("triggers", (Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>)Trinity.create((Object)((Object)GrailsArtifact.JOB), (Object)true, (Object)new JobClosureMethodProvider()));
        map.put("filters", (Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>)Trinity.create((Object)((Object)GrailsArtifact.FILTER), (Object)false, (Object)new FilterClosureMemberProvider()));
        map.put("constraints", (Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>)Trinity.create((Object)((Object)GrailsArtifact.DOMAIN), (Object)true, (Object)new GormConstraintMethodProvider()));
        map.put("mapping", (Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>)Trinity.create((Object)((Object)GrailsArtifact.DOMAIN), (Object)true, (Object)new GormMappingMethodProvider()));
        map.put("accessControl", (Trinity<GrailsArtifact, Boolean, ? extends MethodProvider>)Trinity.create((Object)((Object)GrailsArtifact.CONTROLLER), (Object)true, (Object)new GrailsShiroAccessControlMethodProvider()));
    }

    public static interface MethodProvider {
        public boolean processMembers(@NotNull GrClosableBlock var1, PsiClass var2, PsiScopeProcessor var3, GrReferenceExpression var4, ResolveState var5);
    }
}

