/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.graph;

import com.intellij.CommonBundle;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.perspectives.create.CreateNewRelation;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;

public class DomainClassesRelationsDataModel
extends GraphDataModel<DomainClassNode, DomainClassRelationsInfo> {
    private Set<DomainClassNode> myNodes = new HashSet<DomainClassNode>();
    private Set<DomainClassRelationsInfo> myEdges = new HashSet<DomainClassRelationsInfo>();
    private final Project myProject;
    private final VirtualFile myDomainDirectory;
    private Map<DomainClassNode, List<DomainClassRelationsInfo>> myNodesToOutsMap;

    public DomainClassesRelationsDataModel(@Nullable VirtualFile domainDirectory, Project project) {
        this.myDomainDirectory = domainDirectory;
        this.myProject = project;
    }

    public Map<DomainClassNode, List<DomainClassRelationsInfo>> getNodesToOutsMap() {
        return this.myNodesToOutsMap;
    }

    @NotNull
    public Collection<DomainClassNode> getNodes() {
        this.refreshDataModel();
        Set<DomainClassNode> set = this.myNodes;
        if (set == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(0);
        }
        return set;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    private void updateDataModel() {
        this.myNodesToOutsMap = DomainClassUtils.buildNodesAndEdges(this.myProject, this.myDomainDirectory);
        this.myNodes = this.myNodesToOutsMap.keySet();
        this.myEdges = new HashSet<DomainClassRelationsInfo>(ContainerUtil.flatten(this.myNodesToOutsMap.values()));
    }

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
    }

    @NotNull
    public Collection<DomainClassRelationsInfo> getEdges() {
        this.refreshDataModel();
        Set<DomainClassRelationsInfo> set = this.myEdges;
        if (set == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public DomainClassNode getSourceNode(DomainClassRelationsInfo domainClassRelationsInfo) {
        DomainClassNode domainClassNode = domainClassRelationsInfo.getSource();
        if (domainClassNode == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(2);
        }
        return domainClassNode;
    }

    @NotNull
    public DomainClassNode getTargetNode(DomainClassRelationsInfo domainClassRelationsInfo) {
        DomainClassNode domainClassNode = domainClassRelationsInfo.getTarget();
        if (domainClassNode == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(3);
        }
        return domainClassNode;
    }

    @NotNull
    public String getNodeName(DomainClassNode domainClassNode) {
        String string = domainClassNode.getUniqueName();
        if (string == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getEdgeName(DomainClassRelationsInfo domainClassRelationsInfo) {
        String string = domainClassRelationsInfo.getEdgeLabel();
        if (string == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public DomainClassRelationsInfo createEdge(@NotNull DomainClassNode source, @NotNull DomainClassNode target) {
        int exitCode;
        if (source == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(6);
        }
        if (target == null) {
            DomainClassesRelationsDataModel.$$$reportNull$$$0(7);
        }
        PsiClass targetClass = target.getTypeDefinition();
        String targetQualifiedName = targetClass.getQualifiedName();
        PsiClass psiClass = source.getTypeDefinition();
        String sourceQualifiedName = psiClass.getQualifiedName();
        if (sourceQualifiedName != null && sourceQualifiedName.contains(".") && targetQualifiedName != null && !targetQualifiedName.contains(".") && (exitCode = Messages.showDialog((Project)this.myProject, (String)GrailsBundle.message("destination.class.cannot.be.resolved", new Object[0]), (String)GrailsBundle.message("Warning", new Object[0]), (String[])new String[]{CommonBundle.message((String)"button.ok", (Object[])new Object[0]), CommonBundle.message((String)"button.cancel", (Object[])new Object[0])}, (int)1, (Icon)Messages.getWarningIcon())) == 1) {
            return null;
        }
        CreateNewRelation dialogWrapper = new CreateNewRelation(source, target, this.myProject);
        dialogWrapper.show();
        DomainClassRelationsInfo.Relation relationType = dialogWrapper.getEdgeRelationType();
        if (relationType != null && DomainClassRelationsInfo.Relation.UNKNOWN != relationType) {
            this.myEdges.add(new DomainClassRelationsInfo(source, target, relationType));
        }
        return new DomainClassRelationsInfo(source, target, relationType);
    }

    public void dispose() {
    }

    public Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/perspectives/graph/DomainClassesRelationsDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

