/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.delete;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrNamedArgumentsOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class RelationDeleteProvider
extends DeleteProvider<DomainClassNode, DomainClassRelationsInfo> {
    private final Project myProject;

    public RelationDeleteProvider(Project project) {
        this.myProject = project;
    }

    public boolean canDeleteNode(@NotNull DomainClassNode node) {
        if (node == null) {
            RelationDeleteProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean canDeleteEdge(@NotNull DomainClassRelationsInfo edge) {
        if (edge == null) {
            RelationDeleteProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    public boolean deleteNode(@NotNull DomainClassNode node) {
        if (node == null) {
            RelationDeleteProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    public boolean deleteEdge(@NotNull DomainClassRelationsInfo edge) {
        if (edge == null) {
            RelationDeleteProvider.$$$reportNull$$$0(3);
        }
        DomainClassNode targetCLassNode = edge.getTarget();
        DomainClassNode sourceClassNode = edge.getSource();
        String varName = edge.getVarName();
        DomainClassRelationsInfo.Relation relationType = edge.getRelation();
        Runnable runnable = DomainClassRelationsInfo.Relation.BELONGS_TO == relationType ? this.deleteBelongsToRelation(targetCLassNode, sourceClassNode) : (DomainClassRelationsInfo.Relation.HAS_MANY == relationType ? this.deleteHasManyRelation(varName, sourceClassNode) : (DomainClassRelationsInfo.Relation.STRONG == relationType ? this.deleteStrongRelation(varName, sourceClassNode) : EmptyRunnable.getInstance()));
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(runnable), GrailsBundle.message("command.name.foo", new Object[0]), null);
        return false;
    }

    private Runnable deleteStrongRelation(String varName, DomainClassNode sourceClassNode) {
        return () -> this.deleteStrongField(sourceClassNode.getTypeDefinition(), varName);
    }

    private Runnable deleteBelongsToRelation(DomainClassNode targetCLassNode, DomainClassNode sourceClassNode) {
        return () -> {
            PsiClass sourceTypeDefinition = sourceClassNode.getTypeDefinition();
            GrField belongsToField = (GrField)sourceTypeDefinition.findFieldByName("belongsTo", true);
            assert (belongsToField != null);
            ASTNode belongsToNode = belongsToField.getNode();
            assert (belongsToNode != null);
            GrExpression initializerGroovy = belongsToField.getInitializerGroovy();
            String fieldBelongsToItemType = "";
            if (initializerGroovy instanceof GrListOrMap) {
                GrListOrMap belongsToList = (GrListOrMap)initializerGroovy;
                GrExpression[] refExpressions = belongsToList.getInitializers();
                String name = targetCLassNode.getTypeDefinition().getName();
                assert (name != null);
                for (GrExpression initializer : refExpressions) {
                    assert (initializer instanceof GrReferenceExpression);
                    if (!name.equals(initializer.getText())) continue;
                    ASTNode node = initializer.getParent().getNode();
                    fieldBelongsToItemType = ((GrReferenceExpression)initializer).getReferenceName();
                    assert (node != null);
                    node.removeChild(initializer.getNode());
                    break;
                }
                if ((refExpressions = belongsToList.getInitializers()).length == 0) {
                    ((GrTypeDefinition)sourceTypeDefinition).getBody().removeVariable((GrVariable)belongsToField);
                } else {
                    this.removesSurplusCommas(belongsToList, GrReferenceExpression.class);
                }
            } else if (initializerGroovy instanceof GrReferenceExpression) {
                fieldBelongsToItemType = initializerGroovy.getText();
                ((GrTypeDefinition)sourceTypeDefinition).getBody().removeVariable((GrVariable)belongsToField);
            } else {
                return;
            }
            this.deleteBelongsToItemField(sourceTypeDefinition, fieldBelongsToItemType);
            PsiUtil.reformatCode((PsiElement)sourceClassNode.getTypeDefinition());
        };
    }

    private void deleteBelongsToItemField(PsiClass sourceTypeDefinition, String fieldBelongsToItemType) {
        GrField[] fields;
        if (!(sourceTypeDefinition instanceof GrTypeDefinition)) {
            return;
        }
        for (GrField field : fields = ((GrTypeDefinition)sourceTypeDefinition).getFields()) {
            if (!fieldBelongsToItemType.equals(field.getType().getPresentableText())) continue;
            ((GrTypeDefinition)sourceTypeDefinition).getBody().removeVariable((GrVariable)field);
        }
    }

    private void deleteStrongField(PsiClass sourceTypeDefinition, String strongFieldName) {
        GrField[] fields;
        if (!(sourceTypeDefinition instanceof GrTypeDefinition)) {
            return;
        }
        for (GrField field : fields = ((GrTypeDefinition)sourceTypeDefinition).getFields()) {
            if (!strongFieldName.equals(field.getName())) continue;
            ((GrTypeDefinition)sourceTypeDefinition).getBody().removeVariable((GrVariable)field);
        }
    }

    private Runnable deleteHasManyRelation(String varName, DomainClassNode sourceClassNode) {
        return () -> {
            PsiClass sourceTypeDefinition = sourceClassNode.getTypeDefinition();
            GrField hasManyField = (GrField)sourceTypeDefinition.findFieldByName("hasMany", true);
            if (hasManyField == null || !(hasManyField.getInitializerGroovy() instanceof GrListOrMap)) {
                return;
            }
            GrExpression initializerGroovy = hasManyField.getInitializerGroovy();
            if (!(initializerGroovy instanceof GrListOrMap)) {
                return;
            }
            GrListOrMap hasManyList = (GrListOrMap)initializerGroovy;
            GrNamedArgument[] namedArguments = hasManyList.getNamedArguments();
            assert (varName != null);
            for (GrNamedArgument namedArgument : namedArguments) {
                GrArgumentLabel argumentLabel = namedArgument.getLabel();
                assert (argumentLabel != null);
                if (!varName.equals(argumentLabel.getName())) continue;
                ASTNode node = namedArgument.getParent().getNode();
                if (node == null) {
                    return;
                }
                node.removeChild(namedArgument.getNode());
            }
            if (!PsiImplUtil.hasNamedArguments((GrNamedArgumentsOwner)hasManyList)) {
                ((GrTypeDefinition)sourceTypeDefinition).getBody().removeVariable((GrVariable)hasManyField);
            } else {
                this.removesSurplusCommas(hasManyList, GrNamedArgument.class);
            }
            PsiUtil.reformatCode((PsiElement)sourceClassNode.getTypeDefinition());
        };
    }

    private void removesSurplusCommas(GrListOrMap hasManyList, Class listElementClass) {
        ArrayList<PsiElement> children = new ArrayList<PsiElement>();
        for (PsiElement tempChild = hasManyList.getFirstChild(); tempChild != null; tempChild = tempChild.getNextSibling()) {
            if (tempChild instanceof PsiWhiteSpace) continue;
            children.add(tempChild);
        }
        int i2 = 1;
        while (i2 < children.size() - 1) {
            PsiElement child = (PsiElement)children.get(i2);
            ASTNode node = child.getNode();
            assert (node != null);
            if (GroovyTokenTypes.mCOMMA.equals(node.getElementType())) {
                PsiElement prevSibling = (PsiElement)children.get(i2 - 1);
                PsiElement nextSibling = (PsiElement)children.get(i2 + 1);
                if (!listElementClass.isAssignableFrom(prevSibling.getClass()) || !listElementClass.isAssignableFrom(nextSibling.getClass())) {
                    node.getTreeParent().removeChild(node);
                    children.remove(i2);
                    continue;
                }
            }
            ++i2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/perspectives/delete/RelationDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteEdge";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteEdge";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

