/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives.create;

import com.intellij.CommonBundle;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiClass;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.StringComboboxEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.perspectives.create.RelationsCreationsProvider;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.references.domain.DomainClassUtils;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;

public class CreateNewRelation
extends DialogWrapper {
    private JPanel myContentPane;
    private JRadioButton myBelongsToRadioButton;
    private ComboBox myNameComboBox;
    private JRadioButton myHasManyRadioButton;
    private JLabel myRelationFieldNameLable;
    private JRadioButton myStableRadioButton;
    private final EventListenerList myListenerList;
    private final DomainClassNode mySource;
    private final Project myProject;
    private DomainClassRelationsInfo.Relation edgeRelationType;
    @NotNull
    private final String newNodeShortTypeText;
    private final GrTypeDefinition mySourceTypeDefinition;
    private final PsiClass myTargetTypeDefinition;

    public CreateNewRelation(DomainClassNode source, DomainClassNode target, Project project) {
        super(project, true);
        this.$$$setupUI$$$();
        this.myListenerList = new EventListenerList();
        this.mySource = source;
        this.myProject = project;
        this.setModal(true);
        this.myTargetTypeDefinition = target.getTypeDefinition();
        this.newNodeShortTypeText = this.myTargetTypeDefinition.getName();
        this.mySourceTypeDefinition = (GrTypeDefinition)this.mySource.getTypeDefinition();
        assert (this.newNodeShortTypeText != null);
        this.setUpLabel(this.myRelationFieldNameLable);
        this.setUpNameComboBox();
        this.setTitle(GrailsBundle.message("create.relation", new Object[0]));
        this.init();
        this.updateOkStatus();
        this.myContentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)CreateNewRelation.this.myNameComboBox, true));
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    private void setUpLabel(JLabel relationFieldNameLabel) {
        relationFieldNameLabel.setText(GrailsBundle.message("add.field.to.class", this.mySource.getTypeDefinition().getName()));
    }

    protected void doOKAction() {
        assert (this.mySource != null);
        String enteredName = this.getEnteredName();
        if (enteredName == null) {
            return;
        }
        RelationsCreationsProvider creationsProvider = new RelationsCreationsProvider(this.myTargetTypeDefinition.getQualifiedName(), this.mySourceTypeDefinition, this.myProject, enteredName);
        int exitCode = 0;
        if (this.myBelongsToRadioButton.isSelected()) {
            if (!creationsProvider.canCreateBelongsToRelation()) {
                exitCode = Messages.showDialog((Project)this.myProject, (String)GrailsBundle.message("Relation.already.defined.Could.you.create.it.in.any.way", new Object[0]), (String)GrailsBundle.message("such.relation.already.defined", new Object[0]), (String[])new String[]{CommonBundle.message((String)"button.ok", (Object[])new Object[0]), CommonBundle.message((String)"button.cancel", (Object[])new Object[0])}, (int)1, (Icon)AllIcons.General.TodoQuestion);
            }
            switch (exitCode) {
                case 0: {
                    creationsProvider.createBelongsToRelation();
                    break;
                }
            }
        } else if (this.myHasManyRadioButton.isSelected()) {
            if (!creationsProvider.canCreateHasManyRelation()) {
                exitCode = Messages.showDialog((Component)this.getContentPane(), (String)GrailsBundle.message("Relation.already.defined.Could.you.create.it.in.any.way", new Object[0]), (String)GrailsBundle.message("such.relation.already.defined", new Object[0]), (String[])new String[]{CommonBundle.message((String)"button.ok", (Object[])new Object[0]), CommonBundle.message((String)"button.cancel", (Object[])new Object[0])}, (int)1, (Icon)AllIcons.General.TodoQuestion);
            }
            switch (exitCode) {
                case 0: {
                    creationsProvider.createHasManyRelation();
                    break;
                }
            }
        } else if (this.myStableRadioButton.isSelected()) {
            if (!creationsProvider.canCreateStrongRelation()) {
                exitCode = Messages.showDialog((Component)this.getContentPane(), (String)GrailsBundle.message("Relation.already.defined.Could.you.create.it.in.any.way", new Object[0]), (String)GrailsBundle.message("such.relation.already.defined", new Object[0]), (String[])new String[]{CommonBundle.message((String)"button.ok", (Object[])new Object[0]), CommonBundle.message((String)"button.cancel", (Object[])new Object[0])}, (int)1, (Icon)AllIcons.General.TodoQuestion);
            }
            switch (exitCode) {
                case 0: {
                    creationsProvider.createStrongRelation();
                    break;
                }
            }
        }
        this.edgeRelationType = this.myBelongsToRadioButton.isSelected() ? DomainClassRelationsInfo.Relation.BELONGS_TO : (this.myHasManyRadioButton.isSelected() ? DomainClassRelationsInfo.Relation.HAS_MANY : (this.myStableRadioButton.isSelected() ? DomainClassRelationsInfo.Relation.STRONG : DomainClassRelationsInfo.Relation.UNKNOWN));
        super.doOKAction();
    }

    private void setUpNameComboBox() {
        StringComboboxEditor comboEditor = new StringComboboxEditor(this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE, this.myNameComboBox);
        this.myNameComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myNameComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)comboEditor));
        this.myNameComboBox.setEditable(true);
        this.myNameComboBox.setMaximumRowCount(8);
        this.myListenerList.add(DataChangedListener.class, new DataChangedListener());
        this.myNameComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateNewRelation.this.fireNameDataChanged();
            }
        });
        ((EditorTextField)this.myNameComboBox.getEditor().getEditorComponent()).addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                CreateNewRelation.this.fireNameDataChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/grails/perspectives/create/CreateNewRelation$3", "documentChanged"));
            }
        });
        this.myNameComboBox.addItem((Object)this.findSuitableName(this.mySourceTypeDefinition, this.firstLetterToLowerCase(this.newNodeShortTypeText), 1));
        this.myHasManyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CreateNewRelation.this.myNameComboBox.removeAllItems();
                CreateNewRelation.this.myNameComboBox.addItem((Object)CreateNewRelation.this.findSuitableName(CreateNewRelation.this.mySourceTypeDefinition, StringUtil.pluralize((String)StringUtil.toLowerCase((String)CreateNewRelation.this.newNodeShortTypeText)), 1));
            }
        });
        this.myBelongsToRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CreateNewRelation.this.myNameComboBox.removeAllItems();
                CreateNewRelation.this.myNameComboBox.addItem((Object)CreateNewRelation.this.findSuitableName(CreateNewRelation.this.mySourceTypeDefinition, StringUtil.decapitalize((String)CreateNewRelation.this.newNodeShortTypeText), 1));
            }
        });
        this.myStableRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CreateNewRelation.this.myNameComboBox.removeAllItems();
                CreateNewRelation.this.myNameComboBox.addItem((Object)CreateNewRelation.this.findSuitableName(CreateNewRelation.this.mySourceTypeDefinition, StringUtil.decapitalize((String)CreateNewRelation.this.newNodeShortTypeText), 1));
            }
        });
    }

    @NlsSafe
    private String findSuitableName(GrTypeDefinition typeDefinition, String baseName, int counter) {
        GrField[] fields;
        if (baseName == null) {
            return "";
        }
        for (GrField field : fields = typeDefinition.getFields()) {
            List thisOutEdges;
            if ((baseName + counter).equals(field.getName())) {
                return this.findSuitableName(typeDefinition, baseName, ++counter);
            }
            HashMap<DomainClassNode, List<DomainClassRelationsInfo>> sourcesToOutEdges = new HashMap<DomainClassNode, List<DomainClassRelationsInfo>>();
            if (DomainClassUtils.isHasManyField(field)) {
                DomainClassUtils.buildHasManySourcesToOutEdgesMap(sourcesToOutEdges, field);
                thisOutEdges = (List)sourcesToOutEdges.get(new DomainClassNode((PsiClass)typeDefinition));
                if (thisOutEdges == null) break;
                for (DomainClassRelationsInfo outEdge : thisOutEdges) {
                    if (!(baseName + counter).equals(outEdge.getVarName())) continue;
                    return this.findSuitableName(typeDefinition, baseName, ++counter);
                }
            }
            if (!DomainClassUtils.isBelongsToField(field)) continue;
            sourcesToOutEdges.clear();
            DomainClassUtils.buildBelongsToSourcesToOutEdges(sourcesToOutEdges, field);
            thisOutEdges = (List)sourcesToOutEdges.get(new DomainClassNode((PsiClass)typeDefinition));
            if (thisOutEdges == null) break;
            for (DomainClassRelationsInfo outEdge : thisOutEdges) {
                if (!(baseName + counter).equals(outEdge.getVarName())) continue;
                return this.findSuitableName(typeDefinition, baseName, ++counter);
            }
        }
        return baseName + counter;
    }

    @Nullable
    private String firstLetterToLowerCase(String newNodeTypeText) {
        if (newNodeTypeText == null) {
            return null;
        }
        return StringUtil.toLowerCase((String)String.valueOf(newNodeTypeText.charAt(0))) + newNodeTypeText.substring(1);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameComboBox;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void updateOkStatus() {
        String text = this.getEnteredName();
        this.setOKActionEnabled(GroovyNamesUtil.isIdentifier((String)text) && !this.newNodeShortTypeText.equals(text));
    }

    @Nullable
    public String getEnteredName() {
        if (this.myNameComboBox.getEditor().getItem() instanceof String && ((String)this.myNameComboBox.getEditor().getItem()).length() > 0) {
            return (String)this.myNameComboBox.getEditor().getItem();
        }
        return null;
    }

    private void fireNameDataChanged() {
        Object[] list;
        for (Object aList : list = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChangedListener)) continue;
            ((DataChangedListener)aList).dataChanged();
        }
    }

    public DomainClassRelationsInfo.Relation getEdgeRelationType() {
        return this.edgeRelationType;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBelongsToRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/GrailsBundle", CreateNewRelation.class).getString("relation.form.checkbox.belongsto"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(75, 22), null));
        this.myHasManyRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/GrailsBundle", CreateNewRelation.class).getString("relation.form.checkbox.hasmany"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStableRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/GrailsBundle", CreateNewRelation.class).getString("relation.form.checkbox.strong"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRelationFieldNameLable = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/GrailsBundle", CreateNewRelation.class).getString("form.label.variable.name"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameComboBox = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel3.add((Component)comboBox, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    class DataChangedListener
    implements EventListener {
        DataChangedListener() {
        }

        void dataChanged() {
            CreateNewRelation.this.updateOkStatus();
        }
    }
}

