/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.perspectives;

import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.builder.renderer.GradientFilledPanel;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewChangeListener;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import icons.JetgroovyIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.perspectives.graph.DataModelAndSelectionModificationTracker;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassNode;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassRelationsInfo;
import org.jetbrains.plugins.grails.perspectives.graph.DomainClassesRelationsDataModel;

public class DomainClassNodeRenderer
extends AbstractColoredNodeCellRenderer {
    private final GraphBuilder<DomainClassNode, DomainClassRelationsInfo> myBuilder;
    private final DomainClassesRelationsDataModel myDataModel;
    private final Color myBackgroundColor;
    private final Color myCaptionBackgroundColor;
    private List<Edge> selectedEdges;
    ViewChangeListener myViewChangeListener;

    public DomainClassNodeRenderer(@NotNull GraphBuilder<DomainClassNode, DomainClassRelationsInfo> builder, DataModelAndSelectionModificationTracker modificationTracker, DomainClassesRelationsDataModel dataModel) {
        if (builder == null) {
            DomainClassNodeRenderer.$$$reportNull$$$0(0);
        }
        super((ModificationTracker)modificationTracker);
        this.myBackgroundColor = new JBColor(new Color(252, 250, 209), UIUtil.getToolTipBackground());
        this.myCaptionBackgroundColor = new JBColor(new Color(215, 213, 172), new Color(4539169));
        this.selectedEdges = new ArrayList<Edge>();
        this.myBuilder = builder;
        this.myDataModel = dataModel;
        this.myBuilder.getView().getGraph2D().addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent event) {
                if (event.isEdgeSelection()) {
                    DomainClassNodeRenderer.this.selectedEdges = GraphSelectionService.getInstance().getSelectedEdges(event.getGraph2D());
                }
            }
        });
        this.myBuilder.getView().getGraph2D().addGraph2DSelectionListener((Graph2DSelectionListener)modificationTracker);
    }

    public void tuneNode(NodeRealizer realizer, JPanel wrapper) {
        Icon entityIcon = JetgroovyIcons.Groovy.Class;
        Icon varNameIcon = JetgroovyIcons.Groovy.Property;
        Node node = realizer.getNode();
        DomainClassNode domainClassNode = (DomainClassNode)this.myBuilder.getNodeObject(node);
        @NlsSafe String nodeName = this.myBuilder.getNodeName((Object)domainClassNode);
        JLabel nodeNameLabel = new JLabel(nodeName, entityIcon, 0);
        nodeNameLabel.setBorder(JBUI.Borders.empty((int)3));
        nodeNameLabel.setHorizontalAlignment(2);
        GradientFilledPanel namePanel = new GradientFilledPanel(this.myCaptionBackgroundColor);
        namePanel.setLayout((LayoutManager)new BorderLayout());
        namePanel.add((Component)nodeNameLabel, (Object)"Center");
        namePanel.setBorder(BorderFactory.createLineBorder((Color)JBColor.WHITE, 1));
        namePanel.setGradientColor((Color)new JBColor(new Color(186, 222, 193), LightColors.SLIGHTLY_GREEN));
        nodeNameLabel.setForeground(JBColor.foreground());
        wrapper.add((Component)namePanel, "North");
        assert (domainClassNode != null);
        List<DomainClassRelationsInfo> outEdges = this.myDataModel.getNodesToOutsMap().get(domainClassNode);
        if (outEdges != null) {
            Iterator<DomainClassRelationsInfo> iterator = outEdges.iterator();
            CellRendererPanel relationsPanel = new CellRendererPanel((LayoutManager)new GridBagLayout());
            relationsPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5));
            relationsPanel.setBackground(this.myBackgroundColor);
            if (!outEdges.isEmpty()) {
                while (iterator.hasNext()) {
                    DomainClassRelationsInfo edge = iterator.next();
                    boolean isBold = this.selectedEdges.contains(this.myBuilder.getEdge((Object)edge));
                    @NlsSafe String varName = edge.getVarName();
                    JLabel varNamePanel = new JLabel(varName);
                    if (isBold) {
                        varNamePanel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
                    }
                    varNamePanel.setIcon(varNameIcon);
                    String type = edge.getTarget().getTypeDefinition().getName();
                    JLabel typeLabel = new JLabel(type);
                    if (isBold) {
                        typeLabel.setFont(StartupUiUtil.getLabelFont().deriveFont(1));
                    }
                    CellRendererPanel typePanel = new CellRendererPanel((LayoutManager)new BorderLayout());
                    typePanel.add((Component)typeLabel, "East");
                    relationsPanel.add((Component)varNamePanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 21, 1, (Insets)JBUI.insets((int)2), 0, 0));
                    relationsPanel.add((Component)typePanel, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 22, 1, (Insets)JBUI.insets((int)2), 0, 0));
                }
                Dimension preferredSize = relationsPanel.getPreferredSize();
                relationsPanel.setPreferredSize(new Dimension((int)preferredSize.getWidth() + 20, (int)preferredSize.getHeight()));
            } else {
                Dimension preferredSize = nodeNameLabel.getPreferredSize();
                nodeNameLabel.setPreferredSize(new Dimension((int)preferredSize.getWidth() + 25, (int)preferredSize.getHeight()));
            }
            wrapper.add((Component)relationsPanel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/plugins/grails/perspectives/DomainClassNodeRenderer", "<init>"));
    }
}

