/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.resolve.taglib;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.search.AllClassesSearchExecutor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;

public final class GspTagLibUtil {
    private static final Set<String> NOT_TAGS = ContainerUtil.newHashSet((Object[])new String[]{"grailsApplication", "out", "grailsUrlMappingsHolder", "typeConverter", "renderNoSelectionOption"});
    @NonNls
    public static final String DEFAULT_TAGLIB_PREFIX = "g";
    @NonNls
    public static final String DYNAMIC_TAGLIB_PACKAGE = "org.codehaus.groovy.grails.plugins.web.taglib";
    @NonNls
    public static final String NAMESPACE_FIELD = "namespace";
    private static final Map<String, String> TAG_2_FQN_1_2;
    private static final Map<String, String> TAG_2_FQN_3;
    private static final Map<String, String> FQN_2_TAG;
    public static final Map<String, String> TAGLIB_PREFEXES;

    private GspTagLibUtil() {
    }

    public static Set<String> getExcludedTags(String prefix) {
        return DEFAULT_TAGLIB_PREFIX.equals(prefix) ? NOT_TAGS : Collections.emptySet();
    }

    public static TagLibNamespaceDescriptor getTagLibClasses(@NotNull PsiElement place, @NotNull String tagLibPrefix) {
        if (place == null) {
            GspTagLibUtil.$$$reportNull$$$0(0);
        }
        if (tagLibPrefix == null) {
            GspTagLibUtil.$$$reportNull$$$0(1);
        }
        return GspTagLibUtil.getTagLibClasses(place).get(tagLibPrefix);
    }

    public static Map<String, TagLibNamespaceDescriptor> getTagLibClasses(@NotNull PsiElement place) {
        Module module;
        if (place == null) {
            GspTagLibUtil.$$$reportNull$$$0(2);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) == null) {
            return Collections.emptyMap();
        }
        return GspTagLibUtil.getTagLibClasses(module);
    }

    public static Map<String, TagLibNamespaceDescriptor> getTagLibClasses(@NotNull Module module) {
        if (module == null) {
            GspTagLibUtil.$$$reportNull$$$0(3);
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(GspTagLibUtil.computeCustomTaglibClasses(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static Map<String, TagLibNamespaceDescriptor> computeCustomTaglibClasses(Module module) {
        HashMap<String, TagLibNamespaceDescriptor> res = new HashMap<String, TagLibNamespaceDescriptor>();
        res.put(DEFAULT_TAGLIB_PREFIX, new TagLibNamespaceDescriptor(DEFAULT_TAGLIB_PREFIX, module));
        LinkedHashSet<GrClassDefinition> taglibs = new LinkedHashSet<GrClassDefinition>();
        taglibs.addAll(GrailsArtifact.TAGLIB.getInstances(module).values());
        taglibs.addAll(GspTagLibUtil.searchTaglibsInClassPath(module));
        for (GrClassDefinition classDefinition : taglibs) {
            String prefix = GspTagLibUtil.getPrefixByTagLibClass(classDefinition);
            TagLibNamespaceDescriptor descr = (TagLibNamespaceDescriptor)res.get(prefix);
            if (descr == null) {
                descr = new TagLibNamespaceDescriptor(prefix, module);
                res.put(prefix, descr);
            }
            descr.addClass((PsiClass)classDefinition);
        }
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage(DYNAMIC_TAGLIB_PACKAGE);
        if (psiPackage != null) {
            for (PsiClass tagLibClass : psiPackage.getClasses(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module))) {
                TagLibNamespaceDescriptor descr;
                String name = tagLibClass.getName();
                if (name == null || !name.endsWith(GrailsArtifact.TAGLIB.suffix)) continue;
                String prefix = TAGLIB_PREFEXES.get(tagLibClass.getQualifiedName());
                if (prefix == null) {
                    prefix = DEFAULT_TAGLIB_PREFIX;
                }
                if ((descr = (TagLibNamespaceDescriptor)res.get(prefix)) == null) {
                    descr = new TagLibNamespaceDescriptor(prefix, module);
                    res.put(prefix, descr);
                }
                descr.addClass(tagLibClass);
            }
        }
        return res;
    }

    @NotNull
    private static Collection<GrClassDefinition> searchTaglibsInClassPath(@NotNull Module module) {
        if (module == null) {
            GspTagLibUtil.$$$reportNull$$$0(4);
        }
        Project project = module.getProject();
        Collection collection = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(GspTagLibUtil.doSearchTaglibsInClassPath(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, MvcModuleStructureSynchronizer.getInstance(project).getFileAndRootsModificationTracker()}));
        if (collection == null) {
            GspTagLibUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Collection<GrClassDefinition> doSearchTaglibsInClassPath(@NotNull Module module) {
        if (module == null) {
            GspTagLibUtil.$$$reportNull$$$0(6);
        }
        Project project = module.getProject();
        GlobalSearchScope scope = module.getModuleRuntimeScope(false);
        ArrayList taglibNames = new ArrayList();
        AllClassesSearchExecutor.processClassNames((Project)project, (GlobalSearchScope)scope, fqn -> {
            if (fqn.endsWith(GrailsArtifact.TAGLIB.suffix)) {
                taglibNames.add(fqn);
            }
            return true;
        });
        PsiShortNamesCache namesCache = PsiShortNamesCache.getInstance((Project)project);
        LinkedHashSet<GrClassDefinition> taglibs = new LinkedHashSet<GrClassDefinition>();
        for (String name : taglibNames) {
            PsiClass[] classes;
            for (PsiClass clazz : classes = namesCache.getClassesByName(name, scope)) {
                PsiElement mirror;
                if (!(clazz instanceof PsiCompiledElement) || !((mirror = clazz.getNavigationElement()) instanceof GrClassDefinition)) continue;
                taglibs.add((GrClassDefinition)mirror);
            }
        }
        LinkedHashSet<GrClassDefinition> linkedHashSet = taglibs;
        if (linkedHashSet == null) {
            GspTagLibUtil.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    public static boolean isSdkTagLib(@NotNull PsiClass aClass) {
        String name;
        if (aClass == null) {
            GspTagLibUtil.$$$reportNull$$$0(8);
        }
        return FQN_2_TAG.containsKey(name = aClass.getQualifiedName()) || DYNAMIC_TAGLIB_PACKAGE.equals(ClassUtil.extractPackageName((String)name));
    }

    @Nullable
    public static String getTagNameByClass(@NotNull String className) {
        if (className == null) {
            GspTagLibUtil.$$$reportNull$$$0(9);
        }
        return FQN_2_TAG.get(className);
    }

    @NotNull
    public static String getPrefixByTagLibClass(GrClassDefinition clazz) {
        Object value;
        GrExpression initializer;
        PsiElement source;
        PsiField field = clazz.findCodeFieldByName(NAMESPACE_FIELD, true);
        GrField grField = null;
        if (field instanceof GrField) {
            grField = (GrField)field;
        } else if (field != null && (source = field.getNavigationElement()) instanceof GrField) {
            grField = (GrField)source;
        }
        if (grField == null) {
            return DEFAULT_TAGLIB_PREFIX;
        }
        if (grField.hasModifierProperty("static") && (initializer = grField.getInitializerGroovy()) != null && (value = JavaPsiFacade.getInstance((Project)clazz.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)initializer)) instanceof String) {
            String res = ((String)value).trim();
            String string = res.length() == 0 ? DEFAULT_TAGLIB_PREFIX : res;
            if (string == null) {
                GspTagLibUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        return DEFAULT_TAGLIB_PREFIX;
    }

    @NotNull
    private static Map<String, String> getTag2Fqn(@NotNull PsiElement place) {
        GrailsApplication application;
        if (place == null) {
            GspTagLibUtil.$$$reportNull$$$0(11);
        }
        Map<String, String> map2 = (application = GrailsApplicationManager.findApplication(place)) == null || application.getGrailsVersion().isLessThan(Version.GRAILS_3_0) ? TAG_2_FQN_1_2 : TAG_2_FQN_3;
        if (map2 == null) {
            GspTagLibUtil.$$$reportNull$$$0(12);
        }
        return map2;
    }

    public static void processBuiltInTagClasses(@Nullable String tagName, @NotNull PsiElement place, @NotNull PairProcessor<? super String, ? super PsiClass> processor) {
        if (place == null) {
            GspTagLibUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            GspTagLibUtil.$$$reportNull$$$0(14);
        }
        Map<String, String> tag2Fqn = GspTagLibUtil.getTag2Fqn(place);
        if (tagName == null) {
            GspTagLibUtil.processBuiltInTagClasses(tag2Fqn, place, processor);
        } else {
            PsiClass builtInClass = GspTagLibUtil.getBuiltInTagByName(tag2Fqn, tagName, place);
            if (builtInClass == null) {
                return;
            }
            processor.process((Object)tagName, (Object)builtInClass);
        }
    }

    @Nullable
    private static PsiClass getBuiltInTagByName(@NotNull Map<String, String> tag2Fqn, @NotNull String tagName, @NotNull PsiElement place) {
        String fqn;
        if (tag2Fqn == null) {
            GspTagLibUtil.$$$reportNull$$$0(15);
        }
        if (tagName == null) {
            GspTagLibUtil.$$$reportNull$$$0(16);
        }
        if (place == null) {
            GspTagLibUtil.$$$reportNull$$$0(17);
        }
        if ((fqn = tag2Fqn.get(tagName)) == null) {
            return null;
        }
        PsiClass builtInClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass(fqn, place.getResolveScope());
        if (builtInClass != null) {
            return builtInClass;
        }
        return null;
    }

    private static void processBuiltInTagClasses(@NotNull Map<String, String> tag2Fqn, @NotNull PsiElement place, @NotNull PairProcessor<? super String, ? super PsiClass> processor) {
        if (tag2Fqn == null) {
            GspTagLibUtil.$$$reportNull$$$0(18);
        }
        if (place == null) {
            GspTagLibUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            GspTagLibUtil.$$$reportNull$$$0(20);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)place.getProject());
        GlobalSearchScope resolveScope = place.getResolveScope();
        for (Map.Entry<String, String> entry : tag2Fqn.entrySet()) {
            PsiClass builtInClass = facade.findClass(entry.getValue(), resolveScope);
            if (builtInClass == null || processor.process((Object)entry.getKey(), (Object)builtInClass)) continue;
            return;
        }
    }

    public static boolean processGrailsTags(PsiScopeProcessor processor, PsiElement ref, ResolveState state, @Nullable String name, @Nullable ElementClassHint classHint) {
        return GspTagLibUtil.processGrailsTags(processor, ref, state, name, classHint, GspTagLibUtil.getTagLibClasses(ref));
    }

    public static boolean processGrailsTags(PsiScopeProcessor processor, PsiElement ref, ResolveState state, @Nullable String name, @Nullable ElementClassHint classHint, Map<String, TagLibNamespaceDescriptor> tagClassMap) {
        TagLibNamespaceDescriptor descriptor;
        if (ResolveUtil.shouldProcessProperties((ElementClassHint)classHint)) {
            PsiVariable variable;
            if (name == null) {
                for (TagLibNamespaceDescriptor descriptor2 : tagClassMap.values()) {
                    PsiVariable variable2 = descriptor2.getDummyClassVariable();
                    if (variable2 == null || processor.execute((PsiElement)variable2, ResolveState.initial())) continue;
                    return false;
                }
            } else if (ref.getParent() instanceof GrReferenceExpression && (descriptor = tagClassMap.get(name)) != null && (variable = descriptor.getDummyClassVariable()) != null && !processor.execute((PsiElement)variable, ResolveState.initial())) {
                return false;
            }
        }
        return !ResolveUtil.shouldProcessMethods((ElementClassHint)classHint) || (descriptor = tagClassMap.get(DEFAULT_TAGLIB_PREFIX)) == null || descriptor.processTags(processor, state, name);
    }

    public static Pair<Map<String, XmlAttributeDescriptor>, Set<String>> getAttributesDescriptorsFromJavadocs(PsiElement place) {
        PsiElement element = place.getNavigationElement().getNavigationElement();
        return (Pair)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            PsiDocTag[] attrs;
            PsiDocComment docComment;
            Map<String, XmlAttributeDescriptor> javaDocAttrMap = null;
            if (element instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)element).getDocComment()) != null && (attrs = docComment.findTagsByName("attr")).length > 0) {
                javaDocAttrMap = new HashMap();
                for (PsiDocTag attr : attrs) {
                    XmlAttributeDescriptor descriptor = GspTagLibUtil.createDescriptorByDoc(attr);
                    if (descriptor == null) continue;
                    javaDocAttrMap.put(descriptor.getName(), descriptor);
                }
            }
            if (javaDocAttrMap == null) {
                javaDocAttrMap = Collections.emptyMap();
            }
            Set sourceAttrName = null;
            if (element instanceof GrField) {
                for (String attrName : ((GrField)element).getNamedParameters().keySet()) {
                    if (javaDocAttrMap.containsKey(attrName) || "tagName".equals(attrName) || "type".equals(attrName) || "remove".equals(attrName)) continue;
                    if (sourceAttrName == null) {
                        sourceAttrName = new HashSet();
                    }
                    sourceAttrName.add(attrName);
                }
            }
            if (sourceAttrName == null) {
                sourceAttrName = Collections.emptySet();
            }
            return CachedValueProvider.Result.create((Object)Pair.create(javaDocAttrMap, sourceAttrName), (Object[])new Object[]{element});
        });
    }

    @Nullable
    private static XmlAttributeDescriptor createDescriptorByDoc(PsiDocTag docTag) {
        final PsiDocTagValue valueElement = docTag.getValueElement();
        if (valueElement == null) {
            return null;
        }
        String name = valueElement.getText().trim();
        if (name.isEmpty()) {
            return null;
        }
        PsiElement[] dataElements = docTag.getDataElements();
        final boolean isRequired = dataElements.length > 1 && StringUtil.startsWithIgnoreCase((String)dataElements[1].getText().trim(), (String)"required");
        return new AnyXmlAttributeDescriptor(name){

            public boolean isRequired() {
                return isRequired;
            }

            public PsiElement getDeclaration() {
                return valueElement;
            }
        };
    }

    static {
        HashMap<String, String> tag2Fqn12 = new HashMap<String, String>(11);
        tag2Fqn12.put("renderInput", "org.codehaus.groovy.grails.web.taglib.RenderInputTag");
        tag2Fqn12.put("each", "org.codehaus.groovy.grails.web.taglib.GroovyEachTag");
        tag2Fqn12.put("if", "org.codehaus.groovy.grails.web.taglib.GroovyIfTag");
        tag2Fqn12.put("unless", "org.codehaus.groovy.grails.web.taglib.GroovyUnlessTag");
        tag2Fqn12.put("else", "org.codehaus.groovy.grails.web.taglib.GroovyElseTag");
        tag2Fqn12.put("elseif", "org.codehaus.groovy.grails.web.taglib.GroovyElseIfTag");
        tag2Fqn12.put("findAll", "org.codehaus.groovy.grails.web.taglib.GroovyFindAllTag");
        tag2Fqn12.put("collect", "org.codehaus.groovy.grails.web.taglib.GroovyCollectTag");
        tag2Fqn12.put("grep", "org.codehaus.groovy.grails.web.taglib.GroovyGrepTag");
        tag2Fqn12.put("while", "org.codehaus.groovy.grails.web.taglib.GroovyWhileTag");
        tag2Fqn12.put("def", "org.codehaus.groovy.grails.web.taglib.GroovyDefTag");
        HashMap<String, String> tag2Fqn3 = new HashMap<String, String>(10);
        tag2Fqn3.put("each", "org.grails.gsp.compiler.tags.GroovyEachTag");
        tag2Fqn3.put("if", "org.grails.gsp.compiler.tags.GroovyIfTag");
        tag2Fqn3.put("unless", "org.grails.gsp.compiler.tags.GroovyUnlessTag");
        tag2Fqn3.put("else", "org.grails.gsp.compiler.tags.GroovyElseTag");
        tag2Fqn3.put("elseif", "org.grails.gsp.compiler.tags.GroovyElseIfTag");
        tag2Fqn3.put("findAll", "org.grails.gsp.compiler.tags.GroovyFindAllTag");
        tag2Fqn3.put("collect", "org.grails.gsp.compiler.tags.GroovyCollectTag");
        tag2Fqn3.put("grep", "org.grails.gsp.compiler.tags.GroovyGrepTag");
        tag2Fqn3.put("while", "org.grails.gsp.compiler.tags.GroovyWhileTag");
        tag2Fqn3.put("def", "org.grails.gsp.compiler.tags.GroovyDefTag");
        HashMap<String, String> fqn2Tag = new HashMap<String, String>(tag2Fqn12.size() + tag2Fqn3.size());
        fqn2Tag.putAll(ContainerUtil.reverseMap(tag2Fqn12));
        fqn2Tag.putAll(ContainerUtil.reverseMap(tag2Fqn3));
        TAG_2_FQN_1_2 = tag2Fqn12;
        TAG_2_FQN_3 = tag2Fqn3;
        FQN_2_TAG = fqn2Tag;
        TAGLIB_PREFEXES = new HashMap<String, String>();
        TAGLIB_PREFEXES.put("org.codehaus.groovy.grails.plugins.web.taglib.PluginTagLib", "plugin");
        TAGLIB_PREFEXES.put("org.codehaus.groovy.grails.plugins.web.taglib.SitemeshTagLib", "sitemesh");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagLibPrefix";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag2Fqn";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/resolve/taglib/GspTagLibUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "searchTaglibsInClassPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doSearchTaglibsInClassPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixByTagLibClass";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTag2Fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTagLibClasses";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "searchTaglibsInClassPath";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSearchTaglibsInClassPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSdkTagLib";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTagNameByClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTag2Fqn";
                break;
            }
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processBuiltInTagClasses";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltInTagByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

