/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.html.impl;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.html.ScriptSupportUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.xml.XmlFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.addins.js.JavaScriptIntegrationUtil;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.gspIndex.GspIncludeIndex;
import org.jetbrains.plugins.grails.lang.gsp.gspIndex.GspIncludeInfo;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.psi.GspPsiUtil;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.api.GspLikeFile;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GspHtmlFileImpl
extends XmlFileImpl
implements GspTokenTypesEx,
GspLikeFile {
    private static final int MAX_RESOLVED_INCLUDING = 1;
    private static final int MAX_ATTEMPTS_OF_FILE_REFERENCE_RESOLVE = 4;

    public GspHtmlFileImpl(FileViewProvider fileViewProvider) {
        super(fileViewProvider, (IElementType)GSP_HTML_TEMPLATE_ROOT);
    }

    public XmlDocument getDocument() {
        return (XmlDocument)this.findChildByClass(XmlDocument.class);
    }

    @Override
    @NotNull
    public GspFile getGspLanguageRoot() {
        GspFile gspFile = (GspFile)this.getViewProvider().getPsi((Language)GspLanguage.INSTANCE);
        if (gspFile == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(0);
        }
        return gspFile;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.getViewProvider().getFileType();
        if (fileType == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(1);
        }
        return fileType;
    }

    public String toString() {
        return "GspHtmlFileImpl";
    }

    @NotNull
    public PsiFile getOriginalFile() {
        GspFile gspFile;
        PsiFile original = super.getOriginalFile();
        if (original == this && (gspFile = GspPsiUtil.getGspFile((PsiElement)this)) != null) {
            PsiFile gspOriginal = gspFile.getOriginalFile();
            PsiFile psiFile = gspOriginal.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE);
            if (psiFile == null) {
                GspHtmlFileImpl.$$$reportNull$$$0(2);
            }
            return psiFile;
        }
        PsiFile psiFile = original;
        if (psiFile == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    private static List<GspFile> getIncludingFiles(GspFile gspFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)gspFile);
        if (module == null) {
            return Collections.emptyList();
        }
        String key = StringUtil.trimEnd((String)gspFile.getName(), (String)".gsp");
        GlobalSearchScope scope = module.getModuleContentScope();
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection containingFiles = index.getContainingFiles(GspIncludeIndex.NAME, (Object)key, scope);
        int gspFileCount = 0;
        for (VirtualFile containingFile : containingFiles) {
            if (!FileTypeRegistry.getInstance().isFileOfType(containingFile, (FileType)GspFileType.GSP_FILE_TYPE)) continue;
            ++gspFileCount;
        }
        if (gspFileCount > 4) {
            return Collections.emptyList();
        }
        ArrayList<GspFile> res = new ArrayList<GspFile>();
        LinkedHashMap valuesToProcess = new LinkedHashMap();
        index.processValues(GspIncludeIndex.NAME, (Object)key, null, (file, value) -> {
            if (file.getFileType() != GspFileType.GSP_FILE_TYPE) {
                return true;
            }
            valuesToProcess.put(file, value);
            return true;
        }, scope);
        int resolveAttempts = 1;
        block1: for (Map.Entry entry : valuesToProcess.entrySet()) {
            for (GspIncludeInfo includeInfo : (Collection)entry.getValue()) {
                if (resolveAttempts-- == 0) {
                    return Collections.emptyList();
                }
                GspFile f = GspHtmlFileImpl.getPsiFileIfReferenceResolved(gspFile, (VirtualFile)entry.getKey(), includeInfo.getOffset());
                if (f == null) continue;
                res.add(f);
                if (res.size() <= 1) continue block1;
                return Collections.emptyList();
            }
        }
        return res;
    }

    @Nullable
    private static GspFile getPsiFileIfReferenceResolved(@NotNull GspFile gspFileToCompare, @NotNull VirtualFile virtualFile, int offset) {
        PsiFile file;
        if (gspFileToCompare == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(5);
        }
        if (!((file = gspFileToCompare.getManager().findFile(virtualFile)) instanceof GspFile)) {
            return null;
        }
        PsiElement elementAt = file.findElementAt(offset);
        if (elementAt == null) {
            return null;
        }
        PsiElement viewElement = elementAt.getParent();
        if (viewElement == null) {
            return null;
        }
        for (PsiReference reference : viewElement.getReferences()) {
            PsiElement resolve;
            if (!(reference instanceof FileReference)) continue;
            FileReference lastReference = ((FileReference)reference).getFileReferenceSet().getLastReference();
            if (lastReference == null || (resolve = (PsiElement)RecursionManager.doPreventingRecursion((Object)viewElement, (boolean)false, () -> ((FileReference)lastReference).resolve())) != gspFileToCompare) break;
            return (GspFile)file;
        }
        return null;
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(6);
        }
        if (state == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(7);
        }
        if (place == null) {
            GspHtmlFileImpl.$$$reportNull$$$0(8);
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (JavaScriptIntegrationUtil.isJSElement(place)) {
            GspFile gspLanguageRoot = (GspFile)this.getGspLanguageRoot().getOriginalFile();
            if (!gspLanguageRoot.processJsInJavascriptTags(processor, state, place)) {
                return false;
            }
            if (GrailsUtils.getTemplateName(this.getName()) != null) {
                List includingFilesList = (List)CachedValuesManager.getCachedValue((PsiElement)gspLanguageRoot, () -> CachedValueProvider.Result.create(GspHtmlFileImpl.getIncludingFiles(gspLanguageRoot), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
                for (GspFile gspFile : includingFilesList) {
                    if (!ScriptSupportUtil.processDeclarations((XmlFile)gspFile.getHtmlLanguageRoot(), (PsiScopeProcessor)processor, (ResolveState)state, null, (PsiElement)place)) {
                        return false;
                    }
                    if (gspFile.processJsInJavascriptTags(processor, state, place)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isTemplateDataFile() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/psi/html/impl/GspHtmlFileImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gspFileToCompare";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGspLanguageRoot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/psi/html/impl/GspHtmlFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileIfReferenceResolved";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

