/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag;

import com.intellij.jsp.JspManager;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.GspDirectiveKind;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.directive.GspDirective;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspXmlRootTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.GspXmlTagBaseImpl;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspElementDescriptorBase;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspLinkNamespaceDescriptor;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspNamespaceDescriptor;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspTagDescriptorService;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.impl.gtag.GspTmplNamespaceDescriptor;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.GspTagLibUtil;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.util.GrailsUtils;

public class GspXmlRootTagImpl
extends GspXmlTagBaseImpl
implements GspXmlRootTag {
    @NonNls
    private static final String GSP_ROOT_TAG = "gsp:root";
    @NonNls
    private static final String GSP_ROOT_TAG_LOCAL = "root";

    public GspXmlRootTagImpl() {
        super((IElementType)GspElementTypes.GSP_ROOT_TAG);
    }

    public String toString() {
        return "Gsp root tag";
    }

    @NotNull
    public String getName() {
        return GSP_ROOT_TAG;
    }

    @NotNull
    public String getLocalName() {
        return GSP_ROOT_TAG_LOCAL;
    }

    @NotNull
    public String getNamespace() {
        return "g";
    }

    public String getPrefixByNamespace(String namespace) {
        String ns = this.getNamespaceData().getPrefixByNamespace(namespace);
        return ns != null ? ns : super.getPrefixByNamespace(namespace);
    }

    @NotNull
    public String getNamespaceByPrefix(String prefix) {
        if (!this.isValid()) {
            Object message;
            PsiFile containingFile = SharedImplUtil.getContainingFile((ASTNode)this.getNode());
            if (containingFile == null) {
                message = "no file";
            } else {
                PsiFile newFile;
                FileViewProvider provider = containingFile.getViewProvider();
                message = "VFile valid=" + provider.getVirtualFile().isValid() + "; ";
                message = (String)message + "newFile=" + newFile + "; equals=" + ((newFile = provider.getPsi(containingFile.getLanguage())) == containingFile);
            }
            throw new PsiInvalidElementAccessException((PsiElement)this, (String)message);
        }
        String ns = this.getNamespaceData().getNamespaceByPrefix(prefix);
        String string = ns == null ? super.getNamespaceByPrefix(prefix) : ns;
        if (string == null) {
            GspXmlRootTagImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    private NamespaceData getNamespaceData() {
        return (NamespaceData)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)new NamespaceData(this), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public String[] knownNamespaces() {
        return this.getNamespaceData().knownNamespaces();
    }

    public XmlNSDescriptor getNSDescriptor(String namespace, boolean strict) {
        return this.getNamespaceData().getNSDescriptor(namespace);
    }

    public XmlElementDescriptor getDescriptor() {
        return new GspRootElementDescriptor(this, GspNamespaceDescriptor.getDefaultNsDescriptor(this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/GspXmlRootTagImpl", "getNamespaceByPrefix"));
    }

    private static class NamespaceData {
        private final BidirectionalMap<String, String> myPrefix2Namespace = new BidirectionalMap();
        private final Map<String, XmlNSDescriptor> myUri2Descriptor = new HashMap<String, XmlNSDescriptor>();

        NamespaceData(GspXmlRootTagImpl tag) {
            assert (tag.isValid());
            Project project = tag.getProject();
            for (String prefix : GspTagLibUtil.getTagLibClasses((PsiElement)tag).keySet()) {
                TldDescriptor tldDescriptor;
                this.myPrefix2Namespace.put((Object)prefix, (Object)prefix);
                TagLibNamespaceDescriptor descriptor = GspTagLibUtil.getTagLibClasses((PsiElement)tag, prefix);
                Object nsDescriptor = descriptor != null && descriptor.getClasses().size() > 0 ? new GspNamespaceDescriptor(descriptor) : ("g".equals(prefix) ? ((tldDescriptor = GspTagDescriptorService.getTldDescriptor(project)) != null ? tldDescriptor : GspNamespaceDescriptor.getDefaultNsDescriptor(tag)) : null);
                this.myUri2Descriptor.put(prefix, (XmlNSDescriptor)nsDescriptor);
            }
            PsiFile containingFile = tag.getContainingFile();
            if (containingFile instanceof GspFile) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)tag);
                JspManager jspManager = JspManager.getInstance((Project)project);
                for (GspDirective directive : ((GspFile)containingFile).getDirectiveTags(GspDirectiveKind.TAGLIB, false)) {
                    String uri;
                    String prefix = directive.getAttributeValue("prefix");
                    if (StringUtil.isEmpty((String)prefix) || "g".equals(prefix) || StringUtil.isEmpty((String)(uri = directive.getAttributeValue("uri")))) continue;
                    this.myPrefix2Namespace.put((Object)prefix, (Object)uri);
                    if (jspManager == null) continue;
                    XmlFile tldFile = jspManager.getTldFileByUri(uri, module, null);
                    TldDescriptor nsDescriptor = GrailsUtils.getTldDescriptor(tldFile);
                    this.myUri2Descriptor.put(uri, (XmlNSDescriptor)nsDescriptor);
                }
            }
            this.myPrefix2Namespace.put((Object)"tmpl", (Object)"tmpl");
            this.myUri2Descriptor.put("tmpl", new GspTmplNamespaceDescriptor(tag));
            this.myPrefix2Namespace.put((Object)"link", (Object)"link");
            this.myUri2Descriptor.put("link", GspLinkNamespaceDescriptor.INSTANCE);
        }

        @Nullable
        public XmlNSDescriptor getNSDescriptor(@NotNull String uri) {
            if (uri == null) {
                NamespaceData.$$$reportNull$$$0(0);
            }
            return this.myUri2Descriptor.get(uri);
        }

        @Nullable
        public String getNamespaceByPrefix(@NotNull String prefix) {
            if (prefix == null) {
                NamespaceData.$$$reportNull$$$0(1);
            }
            return (String)this.myPrefix2Namespace.get((Object)prefix);
        }

        @Nullable
        public String getPrefixByNamespace(@NotNull String namespace) {
            List value;
            if (namespace == null) {
                NamespaceData.$$$reportNull$$$0(2);
            }
            return (value = this.myPrefix2Namespace.getKeysByValue((Object)namespace)) == null || value.isEmpty() ? null : (String)value.get(0);
        }

        public String[] knownNamespaces() {
            return ArrayUtilRt.toStringArray((Collection)this.myPrefix2Namespace.values());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/psi/gsp/impl/gtag/GspXmlRootTagImpl$NamespaceData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNSDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNamespaceByPrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrefixByNamespace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GspRootElementDescriptor
    extends GspElementDescriptorBase {
        GspRootElementDescriptor(GspXmlRootTagImpl tag, GspNamespaceDescriptor nsDescriptor) {
            super(nsDescriptor, (PsiElement)tag, "gsp root");
        }

        public XmlAttributeDescriptor[] getAttributesDescriptors(@Nullable XmlTag context) {
            return XmlAttributeDescriptor.EMPTY;
        }

        public XmlAttributeDescriptor getAttributeDescriptor(@NonNls String attributeName, @Nullable XmlTag context) {
            return null;
        }
    }
}

