/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.psi.groovy.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.gspIndex.GspIncludeIndex;
import org.jetbrains.plugins.grails.lang.gsp.gspIndex.GspIncludeInfo;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspGrailsTag;
import org.jetbrains.plugins.grails.util.GrailsPsiUtil;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.GrVariableImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GspModelVariableModel {
    private static final Logger LOG = Logger.getInstance(GspModelVariableModel.class);
    private static final Object INVALID_VARIABLE_MARKER = new Object();
    private static final int MAX_RESOLVE_USAGES = 6;
    private static final int MAX_ATTEMPTS_RESOLVE = 25;
    private final Map<String, ParameterDescriptor> myDescriptors = new HashMap<String, ParameterDescriptor>();
    private final GspFile myGspFile;

    public GspModelVariableModel(GspFile gspFile) {
        this.myGspFile = gspFile;
        String fileName = StringUtil.trimEnd((String)gspFile.getName(), (String)".gsp");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)gspFile);
        if (module == null) {
            return;
        }
        this.collectArgumentFromActionReturn(gspFile, module);
        FileBasedIndex.getInstance().processValues(GspIncludeIndex.NAME, (Object)fileName, null, (file, value) -> {
            for (GspIncludeInfo includeInfo : value) {
                IncludePoint point = new IncludePoint(file, includeInfo.getOffset());
                for (String argumentName : includeInfo.getNamedArguments()) {
                    this.getOrCreateParameterDescriptor((String)argumentName).myUsages.add(point);
                }
            }
            return true;
        }, module.getModuleContentScope());
    }

    public static GspModelVariableModel getInstance(@NotNull GspFile file) {
        if (file == null) {
            GspModelVariableModel.$$$reportNull$$$0(0);
        }
        return (GspModelVariableModel)CachedValuesManager.getCachedValue((PsiElement)file, () -> new CachedValueProvider.Result((Object)new GspModelVariableModel(file), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private ParameterDescriptor getOrCreateParameterDescriptor(String name) {
        ParameterDescriptor descriptor = this.myDescriptors.get(name);
        if (descriptor == null) {
            descriptor = new ParameterDescriptor(name);
            this.myDescriptors.put(name, descriptor);
        }
        return descriptor;
    }

    public Collection<String> getArgumentNames() {
        return this.myDescriptors.keySet();
    }

    @Nullable
    public PsiVariable getVariable(@Nullable String name) {
        ParameterDescriptor descriptor = this.myDescriptors.get(name);
        if (descriptor != null) {
            return descriptor.getVariable();
        }
        return null;
    }

    private void collectArgumentFromActionReturn(GspFile gspFile, Module module) {
        GrOpenBlock block;
        VirtualFile virtualFile = gspFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        String gspName = virtualFile.getNameWithoutExtension();
        String controllerName = GrailsUtils.getControllerNameByGsp(virtualFile);
        PsiMethod method = GrailsUtils.getControllerActions(controllerName, module).get(gspName);
        if (method == null) {
            return;
        }
        if (method instanceof GrAccessorMethod) {
            GrExpression initializerGroovy = ((GrAccessorMethod)method).getProperty().getInitializerGroovy();
            if (!(initializerGroovy instanceof GrClosableBlock)) {
                return;
            }
            block = (GrClosableBlock)initializerGroovy;
        } else if (method instanceof GrMethod) {
            block = ((GrMethod)method).getBlock();
        } else {
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.error("Unknown action type");
            }
            return;
        }
        if (block == null) {
            return;
        }
        for (GrStatement returnStatement : ControlFlowUtils.collectReturns((PsiElement)block, (boolean)true)) {
            PsiElement resolve;
            GrReferenceExpression ref;
            GrExpression value = ControlFlowUtils.extractReturnExpression((GrStatement)returnStatement);
            if (value instanceof GrListOrMap) {
                this.collectNamedArguments((PsiElement)value);
                continue;
            }
            if (!(value instanceof GrReferenceExpression) || (ref = (GrReferenceExpression)value).isQualified() || !((resolve = ref.resolve()) instanceof GrVariableImpl)) continue;
            for (ReadWriteVariableInstruction inst : ControlFlowUtils.findAccess((GrVariable)((GrVariable)resolve), (PsiElement)ref, (boolean)false, (boolean)false)) {
                PsiElement element = inst.getElement();
                if (element instanceof GrVariable) {
                    this.collectNamedArguments((PsiElement)((GrVariable)element).getInitializerGroovy());
                    continue;
                }
                if (!(element instanceof GrReferenceExpression)) continue;
                PsiElement parent = element.getParent();
                if (parent instanceof GrAssignmentExpression) {
                    if (((GrAssignmentExpression)parent).getLValue() != element) continue;
                    this.collectNamedArguments((PsiElement)((GrAssignmentExpression)parent).getRValue());
                    continue;
                }
                if (!(parent instanceof GrBinaryExpression) || ((GrBinaryExpression)parent).getOperationTokenType() != GroovyElementTypes.COMPOSITE_LSHIFT_SIGN || ((GrBinaryExpression)parent).getLeftOperand() != element) continue;
                this.collectNamedArguments((PsiElement)((GrBinaryExpression)parent).getRightOperand());
            }
        }
    }

    private void collectNamedArguments(@Nullable PsiElement initializer) {
        if (!(initializer instanceof GrListOrMap)) {
            return;
        }
        for (GrNamedArgument namedArgument : ((GrListOrMap)initializer).getNamedArguments()) {
            String labelName = GrailsPsiUtil.getPlainLabelName(namedArgument);
            if (labelName == null) continue;
            this.getOrCreateParameterDescriptor((String)labelName).myArgumentsFromActionReturn.add(namedArgument);
        }
    }

    private static PsiVariable createVariableDefinedInNamedArguments(String name, Collection<PsiElement> arguments, PsiElement scope) {
        PsiClassType type = null;
        ArrayList<Object> declarations = new ArrayList<Object>(arguments.size());
        PsiManager manager = scope.getManager();
        for (PsiElement argument : arguments) {
            PsiType argumentType = null;
            if (argument instanceof GrNamedArgument) {
                GrExpression expression = ((GrNamedArgument)argument).getExpression();
                if (expression != null) {
                    argumentType = expression.getType();
                }
                declarations.add(((GrNamedArgument)argument).getLabel());
            } else {
                XmlAttribute attribute = (XmlAttribute)argument;
                XmlAttributeValue valueElement = attribute.getValueElement();
                if (valueElement != null) {
                    argumentType = GrailsPsiUtil.getAttributeExpressionType(valueElement);
                }
                declarations.add(attribute);
            }
            type = TypesUtil.getLeastUpperBoundNullable((PsiType)argumentType, (PsiType)type, (PsiManager)manager);
        }
        if (type == null) {
            type = PsiType.getJavaLangObject((PsiManager)manager, (GlobalSearchScope)scope.getResolveScope());
        }
        return new GrLightVariable(manager, name, (PsiType)type, declarations, scope);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/lang/gsp/psi/groovy/impl/GspModelVariableModel", "getInstance"));
    }

    private final class IncludePoint {
        private final VirtualFile myFile;
        private final int myOffset;
        private GrListOrMap myListOrMap;
        private GspGrailsTag myTag;
        private volatile Boolean myResolved;

        private IncludePoint(VirtualFile file, int offset) {
            this.myFile = file;
            this.myOffset = offset;
        }

        @Nullable
        private PsiElement findArgument(String name) {
            if (this.myListOrMap != null) {
                return this.myListOrMap.findNamedArgument(name);
            }
            return this.myTag.getAttribute(name);
        }

        private boolean resolveInternal() {
            PsiFile file = GspModelVariableModel.this.myGspFile.getManager().findFile(this.myFile);
            if (!(file instanceof GspFile) && !(file instanceof GroovyFile)) {
                return false;
            }
            PsiElement elementAt = file.findElementAt(this.myOffset);
            if (elementAt == null) {
                return false;
            }
            PsiElement viewElement = elementAt.getParent();
            if (viewElement == null) {
                return false;
            }
            for (PsiReference reference : viewElement.getReferences()) {
                PsiElement model;
                PsiElement resolve;
                if (!(reference instanceof FileReference)) continue;
                FileReference lastReference = ((FileReference)reference).getFileReferenceSet().getLastReference();
                if (lastReference == null || (resolve = (PsiElement)RecursionManager.doPreventingRecursion((Object)viewElement, (boolean)false, () -> ((FileReference)lastReference).resolve())) != GspModelVariableModel.this.myGspFile) break;
                if (viewElement instanceof GspGrailsTag) {
                    this.myTag = (GspGrailsTag)viewElement;
                    return true;
                }
                PsiElement parent = viewElement.getParent();
                if (parent instanceof XmlAttribute) {
                    XmlAttribute modelAttr;
                    PsiElement xmlTag = parent.getParent();
                    if (!(xmlTag instanceof XmlTag) || (modelAttr = ((XmlTag)xmlTag).getAttribute("model")) == null) break;
                    this.myListOrMap = GspIncludeIndex.extractMap(modelAttr);
                    return true;
                }
                if (!(parent instanceof GrNamedArgument) || !((model = PsiUtil.getNamedArgumentValue((GrNamedArgument)((GrNamedArgument)parent), (String)"model")) instanceof GrListOrMap)) break;
                this.myListOrMap = (GrListOrMap)model;
                return true;
            }
            return false;
        }

        public boolean resolve() {
            Boolean resolved = this.myResolved;
            if (resolved == null) {
                this.myResolved = resolved = Boolean.valueOf(this.resolveInternal());
            }
            return resolved;
        }
    }

    private final class ParameterDescriptor {
        private final String myName;
        private final AtomicReference<Object> myVariable = new AtomicReference();
        private final List<IncludePoint> myUsages = new ArrayList<IncludePoint>();
        private final List<GrNamedArgument> myArgumentsFromActionReturn = new ArrayList<GrNamedArgument>();

        private ParameterDescriptor(String name) {
            this.myName = name;
        }

        @Nullable
        private PsiVariable calculateVariable() {
            ArrayList<PsiElement> arguments = new ArrayList<PsiElement>();
            int resolvedUsages = 0;
            if (this.myUsages.size() > 6) {
                for (IncludePoint usage : this.myUsages) {
                    if (usage.myResolved != Boolean.TRUE) continue;
                    ++resolvedUsages;
                }
                if (resolvedUsages > 6) {
                    return this.createUntypedVariable();
                }
            }
            int numberOfAttemptsResolve = 25;
            for (IncludePoint usage : this.myUsages) {
                if (usage.myResolved != null) continue;
                if (usage.resolve() && ++resolvedUsages > 6) {
                    return this.createUntypedVariable();
                }
                if (--numberOfAttemptsResolve != 0) continue;
                return resolvedUsages > 0 ? this.createUntypedVariable() : null;
            }
            for (IncludePoint usage : this.myUsages) {
                if (!usage.myResolved.booleanValue()) continue;
                ContainerUtil.addIfNotNull(arguments, (Object)usage.findArgument(this.myName));
            }
            arguments.addAll(this.myArgumentsFromActionReturn);
            if (arguments.isEmpty()) {
                return null;
            }
            return GspModelVariableModel.createVariableDefinedInNamedArguments(this.myName, arguments, (PsiElement)GspModelVariableModel.this.myGspFile.getGroovyLanguageRoot());
        }

        private PsiVariable createUntypedVariable() {
            GrLightVariable res = new GrLightVariable(GspModelVariableModel.this.myGspFile.getManager(), this.myName, "java.lang.Object", (PsiElement)GspModelVariableModel.this.myGspFile);
            res.setNavigationElement((PsiElement)res);
            return res;
        }

        @Nullable
        public PsiVariable getVariable() {
            Object value = this.myVariable.get();
            if (INVALID_VARIABLE_MARKER == value) {
                return null;
            }
            if (value != null) {
                return (PsiVariable)value;
            }
            PsiVariable variable = this.calculateVariable();
            if (variable == null) {
                this.myVariable.compareAndSet(null, INVALID_VARIABLE_MARKER);
                return null;
            }
            if (!this.myVariable.compareAndSet(null, variable)) {
                Object o = this.myVariable.get();
                return o == INVALID_VARIABLE_MARKER ? null : (PsiVariable)o;
            }
            return variable;
        }
    }
}

