/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.highlighter;

import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.editor.JspHighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataHighlighterWrapper;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.highlighter.GspDirectiveHighlighter;
import org.jetbrains.plugins.grails.lang.gsp.highlighter.GspSyntaxHighlighter;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.GspPsiUtil;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;

public class GspEditorHighlighter
extends LayeredLexerEditorHighlighter {
    private final Project myProject;
    private final VirtualFile myVirtualFile;
    private Language myTemplateLanguage;

    public GspEditorHighlighter(EditorColorsScheme scheme, Project project, VirtualFile virtualFile) {
        super((SyntaxHighlighter)new GspSyntaxHighlighter(), scheme);
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        GroovySyntaxHighlighter groovyHighlighter = new GroovySyntaxHighlighter();
        LayerDescriptor groovyLayer = new LayerDescriptor((SyntaxHighlighter)groovyHighlighter, "\n", JspHighlighterColors.JSP_SCRIPTING_BACKGROUND);
        this.registerLayer(GspTokenTypes.GROOVY_CODE, groovyLayer);
        this.registerLayer(GspTokenTypes.GROOVY_EXPR_CODE, groovyLayer);
        this.registerLayer(GspTokenTypes.GSP_MAP_ATTR_VALUE, groovyLayer);
        this.registerLayer(GspTokenTypes.GROOVY_ATTR_VALUE, groovyLayer);
        this.registerLayer(GspTokenTypes.GROOVY_DECLARATION, groovyLayer);
        SyntaxHighlighter htmlHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)HTMLLanguage.INSTANCE, (Project)project, (VirtualFile)virtualFile);
        LayerDescriptor htmlLayer = new LayerDescriptor((SyntaxHighlighter)new TemplateDataHighlighterWrapper(htmlHighlighter), "\n", XmlHighlighterColors.HTML_TAG);
        this.registerLayer(GspTokenTypesEx.GSP_TEMPLATE_DATA, htmlLayer);
        GspDirectiveHighlighter directiveHighlighter = new GspDirectiveHighlighter();
        LayerDescriptor directiveLayer = new LayerDescriptor((SyntaxHighlighter)directiveHighlighter, "\n", JspHighlighterColors.JSP_ACTION_AND_DIRECTIVE_BACKGROUND);
        this.registerLayer((IElementType)GspTokenTypes.GSP_DIRECTIVE, directiveLayer);
    }

    protected boolean updateLayers() {
        if (this.myVirtualFile == null || !this.myVirtualFile.isValid() || this.myVirtualFile.getFileType() != GspFileType.GSP_FILE_TYPE) {
            return false;
        }
        Language templateLanguage = this.getCurrentTemplateLanguage();
        if (!Comparing.equal((Object)this.myTemplateLanguage, (Object)templateLanguage)) {
            this.unregisterLayer(GspTokenTypesEx.GSP_TEMPLATE_DATA);
            this.myTemplateLanguage = templateLanguage;
            SyntaxHighlighter templateLanguageHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)this.myTemplateLanguage, (Project)this.myProject, (VirtualFile)this.myVirtualFile);
            this.registerLayer(GspTokenTypesEx.GSP_TEMPLATE_DATA, new LayerDescriptor((SyntaxHighlighter)new TemplateDataHighlighterWrapper(templateLanguageHighlighter), "", null));
            return true;
        }
        return false;
    }

    private Language getCurrentTemplateLanguage() {
        PsiDocumentManager instance;
        PsiFile psiFile;
        if (this.myProject != null && !this.myProject.isDisposed() && this.getDocument() != null && GspPsiUtil.isInGspFile((PsiElement)(psiFile = (instance = PsiDocumentManager.getInstance((Project)this.myProject)).getPsiFile(this.getDocument())))) {
            GspFile gspFile = GspPsiUtil.getGspFile((PsiElement)psiFile);
            assert (gspFile != null);
            return HTMLLanguage.INSTANCE;
        }
        return HTMLLanguage.INSTANCE;
    }
}

