/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;

public class GspPositionManager
implements PositionManager {
    private final DebugProcess myDebugProcess;
    private final Map<String, String> className2gspName = Collections.synchronizedMap(new HashMap());
    public static final Pattern ESCAPED_CHAR = Pattern.compile("[^\\w]");
    private static final Set<FileType> ourFileTypes = Collections.singleton(GspFileType.GSP_FILE_TYPE);

    public GspPositionManager(DebugProcess debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    @Nullable
    private String getGspClassName(PsiFile file) {
        if (!(file instanceof GspFile)) {
            return null;
        }
        String path = (String)ReadAction.compute(() -> {
            VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            return virtualFile.getPath();
        });
        String className = ESCAPED_CHAR.matcher(path.startsWith("/") ? path.substring(1) : path).replaceAll("_");
        this.className2gspName.put(className, path);
        return className;
    }

    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        if (location == null) {
            throw NoDataException.INSTANCE;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            throw NoDataException.INSTANCE;
        }
        String className = refType.name();
        int dollar = className.indexOf(36);
        String qname = dollar == -1 ? className : className.substring(0, dollar);
        String path = this.className2gspName.get(qname);
        if (path == null) {
            throw NoDataException.INSTANCE;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (virtualFile == null) {
            throw NoDataException.INSTANCE;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myDebugProcess.getProject()).findFile(virtualFile);
        GspPositionManager.checkGspFile(psiFile);
        return SourcePosition.createFromLine((PsiFile)psiFile, (int)(location.lineNumber() - 1));
    }

    private static void collectNestedTypes(List<ReferenceType> res, ReferenceType type, int line) {
        if (!type.isPrepared()) {
            return;
        }
        try {
            if (DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (int)line).size() > 0) {
                res.add(type);
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        HashMap<String, ReferenceType> nestedTypeMap = new HashMap<String, ReferenceType>();
        for (ReferenceType referenceType : type.nestedTypes()) {
            nestedTypeMap.put(referenceType.name(), referenceType);
        }
        for (ReferenceType referenceType : nestedTypeMap.values()) {
            GspPositionManager.collectNestedTypes(res, referenceType, line);
        }
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
        if (classPosition == null) {
            GspPositionManager.$$$reportNull$$$0(0);
        }
        PsiFile file = classPosition.getFile();
        GspPositionManager.checkGspFile(file);
        String className = this.getGspClassName(file);
        if (className == null) {
            throw NoDataException.INSTANCE;
        }
        ArrayList<ReferenceType> res = new ArrayList<ReferenceType>();
        List referenceTypes = this.myDebugProcess.getVirtualMachineProxy().classesByName(className);
        if (referenceTypes.size() > 0) {
            GspPositionManager.collectNestedTypes(res, (ReferenceType)referenceTypes.get(referenceTypes.size() - 1), classPosition.getLine() + 1);
        }
        ArrayList<ReferenceType> arrayList = res;
        if (arrayList == null) {
            GspPositionManager.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void checkGspFile(PsiFile file) throws NoDataException {
        if (!(file instanceof GspFile)) {
            throw NoDataException.INSTANCE;
        }
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        block6: {
            List list;
            String qname;
            if (type == null) {
                GspPositionManager.$$$reportNull$$$0(2);
            }
            if (position == null) {
                GspPositionManager.$$$reportNull$$$0(3);
            }
            GspPositionManager.checkGspFile(position.getFile());
            String className = type.name();
            int dollar = className.indexOf(36);
            String string = qname = dollar == -1 ? className : className.substring(0, dollar);
            if (!this.className2gspName.containsKey(qname)) {
                throw NoDataException.INSTANCE;
            }
            try {
                List locations = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type, (int)(position.getLine() + 1));
                if (locations.size() <= 0) break block6;
                list = locations;
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
            if (list == null) {
                GspPositionManager.$$$reportNull$$$0(4);
            }
            return list;
        }
        throw NoDataException.INSTANCE;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        String className;
        if (requestor == null) {
            GspPositionManager.$$$reportNull$$$0(5);
        }
        if (position == null) {
            GspPositionManager.$$$reportNull$$$0(6);
        }
        if ((className = this.getGspClassName(position.getFile())) == null) {
            throw NoDataException.INSTANCE;
        }
        return this.myDebugProcess.getRequestsManager().createClassPrepareRequest(requestor, className + "*");
    }

    @NotNull
    public Set<? extends FileType> getAcceptedFileTypes() {
        Set<FileType> set = ourFileTypes;
        if (set == null) {
            GspPositionManager.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPosition";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/lang/gsp/debug/GspPositionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

