/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeHandlerProvider;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.i18n.GrailsI18nGroovyQuickFixHandler;
import org.jetbrains.plugins.grails.i18n.GrailsI18nQuickFixHandler;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

final class GrailsI18nizeProvider
extends I18nizeHandlerProvider {
    GrailsI18nizeProvider() {
    }

    public I18nQuickFixHandler<?> getHandler(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull TextRange range) {
        if (psiFile == null) {
            GrailsI18nizeProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            GrailsI18nizeProvider.$$$reportNull$$$0(1);
        }
        if (range == null) {
            GrailsI18nizeProvider.$$$reportNull$$$0(2);
        }
        if (psiFile instanceof GspFile) {
            PsiElement elementAt = psiFile.getViewProvider().findElementAt(range.getStartOffset());
            if (elementAt != null && elementAt.getLanguage() == GroovyLanguage.INSTANCE) {
                if (GrailsI18nGroovyQuickFixHandler.calculatePropertyValue(editor, psiFile) != null) {
                    return GrailsI18nGroovyQuickFixHandler.INSTANCE;
                }
                return null;
            }
            return GrailsI18nQuickFixHandler.INSTANCE;
        }
        if (psiFile instanceof GroovyFile && GrailsI18nizeProvider.isApplicableGroovyFile((GroovyFileBase)((GroovyFile)psiFile))) {
            return GrailsI18nGroovyQuickFixHandler.INSTANCE;
        }
        return null;
    }

    public static boolean isApplicableGroovyFile(@NotNull GroovyFileBase groovyFile) {
        PsiClass[] classes;
        if (groovyFile == null) {
            GrailsI18nizeProvider.$$$reportNull$$$0(3);
        }
        if ((classes = groovyFile.getClasses()).length == 1) {
            PsiClass aClass = classes[0];
            return GrailsArtifact.CONTROLLER.isInstance(aClass) || GrailsArtifact.TAGLIB.isInstance(aClass);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groovyFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/i18n/GrailsI18nizeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableGroovyFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

