/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.i18n;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.i18n.GrailsI18nPropertyReferenceProvider;
import org.jetbrains.plugins.grails.inspections.GspAndGroovyInspection;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspAttribute;
import org.jetbrains.plugins.grails.lang.gsp.resolve.taglib.TagLibNamespaceDescriptor;
import org.jetbrains.plugins.grails.references.common.GroovyGspAttributeWrapper;
import org.jetbrains.plugins.grails.references.common.XmlGspAttributeWrapper;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

final class GrailsI18nInspection
extends GspAndGroovyInspection {
    private static final String SHORT_NAME = "InvalidI18nProperty";
    private static final Key<GrailsI18nInspection> SHORT_NAME_KEY = Key.create((String)"InvalidI18nProperty");
    public boolean ignoreTagsWithDefault;

    GrailsI18nInspection() {
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(GrailsBundle.message("label.text.ignore.if.default.value.specified", new Object[0]), (InspectionProfileEntry)this, "ignoreTagsWithDefault");
    }

    @Override
    protected GroovyRecursiveElementVisitor createGroovyFileVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            GrailsI18nInspection.$$$reportNull$$$0(0);
        }
        return new GroovyRecursiveElementVisitor(){

            public void visitNamedArgument(@NotNull GrNamedArgument argument) {
                GrExpression expression;
                if (argument == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expression = argument.getExpression()) instanceof GrLiteralImpl) {
                    GroovyGspAttributeWrapper attr;
                    Boolean refType;
                    PsiElement resolve;
                    GrExpression invokedExpression;
                    GrCall call;
                    if (((GrLiteralImpl)expression).isStringLiteral() && (call = PsiUtil.getCallByNamedParameter((GrNamedArgument)argument)) instanceof GrMethodCall && (invokedExpression = ((GrMethodCall)call).getInvokedExpression()) instanceof GrReferenceExpression && (resolve = ((GrReferenceExpression)invokedExpression).resolve()) instanceof TagLibNamespaceDescriptor.GspTagMethod && (refType = GrailsI18nPropertyReferenceProvider.getTypeOfReference(attr = new GroovyGspAttributeWrapper(argument, (TagLibNamespaceDescriptor.GspTagMethod)resolve))) != null && (!refType.booleanValue() || !GrailsI18nInspection.this.ignoreTagsWithDefault)) {
                        for (PsiReference reference : expression.getReferences()) {
                            if (!(reference instanceof PropertyReference)) continue;
                            GrailsI18nInspection.checkReference(holder, refType, isOnTheFly, (PropertyReference)reference);
                            break;
                        }
                    }
                    return;
                }
                super.visitNamedArgument(argument);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$1", "visitNamedArgument"));
            }
        };
    }

    private static void checkReference(ProblemsHolder holder, boolean isSoft, boolean isOnTheFly, @NotNull PropertyReference reference) {
        if (reference == null) {
            GrailsI18nInspection.$$$reportNull$$$0(1);
        }
        if (!(reference instanceof PrefixBasedPropertyReference && ((PrefixBasedPropertyReference)reference).isDynamicPrefix() || reference.multiResolve(false).length != 0)) {
            Object[] quickFixes;
            String message;
            String pattern = reference.getUnresolvedMessagePattern();
            String string = message = pattern.contains("{0}") ? MessageFormat.format(pattern, reference.getCanonicalText()) : pattern;
            if (!isOnTheFly) {
                quickFixes = LocalQuickFix.EMPTY_ARRAY;
            } else {
                quickFixes = reference.getQuickFixes();
                if (quickFixes == null) {
                    quickFixes = LocalQuickFix.EMPTY_ARRAY;
                }
                if (isSoft) {
                    quickFixes = (LocalQuickFix[])ArrayUtil.append((Object[])quickFixes, (Object)new LocalQuickFix(){

                        @NotNull
                        public String getFamilyName() {
                            String string = GrailsBundle.message("quick.fix.don.t.check.message.code", new Object[0]);
                            if (string == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                            if (project == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (descriptor == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            PsiElement element = descriptor.getPsiElement();
                            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
                            profile.modifyToolSettings(SHORT_NAME_KEY, element, tool -> {
                                tool.ignoreTagsWithDefault = true;
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 2;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    n2 = 3;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$2";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "project";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "descriptor";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getFamilyName";
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "applyFix";
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                }
            }
            holder.registerProblemForReference((PsiReference)reference, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, message, (LocalQuickFix[])quickFixes);
        }
    }

    @Override
    protected GspAndGroovyInspection.GspElementVisitor createGspElementVisitor() {
        return new GspAndGroovyInspection.GspElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (!(attribute instanceof GspAttribute)) {
                    return;
                }
                Boolean refType = GrailsI18nPropertyReferenceProvider.getTypeOfReference(new XmlGspAttributeWrapper((GspAttribute)attribute));
                if (!(refType == null || refType.booleanValue() && GrailsI18nInspection.this.ignoreTagsWithDefault)) {
                    XmlAttributeValue attributeValue = attribute.getValueElement();
                    if (attributeValue == null) {
                        return;
                    }
                    PropertyReference reference = GrailsI18nPropertyReferenceProvider.getReferenceByElement(attributeValue);
                    if (reference == null) {
                        return;
                    }
                    GrailsI18nInspection.checkReference(this.getProblemHolder(), refType, this.isOnTheFly(), reference);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/i18n/GrailsI18nInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createGroovyFileVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

