/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.feature.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.feature.forge.FFeature;
import org.jetbrains.plugins.grails.feature.forge.FProfile;
import org.jetbrains.plugins.grails.feature.forge.FVersion;
import org.jetbrains.plugins.grails.feature.forge.GrailsForgeModuleBuilder;
import org.jetbrains.plugins.grails.feature.forge.ImplKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002\u001a\f\u0010\u0015\u001a\u00020\f*\u00020\u0012H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "downloadAndExtract", "", "serviceUrl", "", "name", "params", "where", "getForgeVersions", "", "Lorg/jetbrains/plugins/grails/feature/forge/FVersion;", "getJson", "Lcom/google/gson/JsonElement;", "url", "asForgeFeature", "Lorg/jetbrains/plugins/grails/feature/forge/FFeature;", "Lcom/google/gson/JsonObject;", "asForgeProfile", "Lorg/jetbrains/plugins/grails/feature/forge/FProfile;", "asForgeVersion", "intellij.groovy.grails"})
public final class ImplKt {
    private static final Logger LOG;

    private static final JsonElement getJson(String url) {
        Object object = HttpRequests.request((String)url).productNameAsUserAgent().accept("application/json").connect((HttpRequests.RequestProcessor)getJson.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.request(url\u2026r().parse(jsonReader)\n  }");
        return (JsonElement)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FVersion> getForgeVersions(@NotNull String serviceUrl) {
        List list;
        Intrinsics.checkNotNullParameter((Object)serviceUrl, (String)"serviceUrl");
        try {
            void $this$mapTo$iv$iv;
            JsonArray jsonArray = ImplKt.getJson(serviceUrl + "/appData").getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getJson(\"$serviceUrl/appData\").asJsonArray");
            Iterable $this$map$iv = (Iterable)jsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JsonElement jsonElement = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                JsonObject jsonObject = v1.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.asJsonObject");
                FVersion fVersion = ImplKt.asForgeVersion(jsonObject);
                collection.add(fVersion);
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable e) {
            LOG.info(e);
            throw e;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final FVersion asForgeVersion(JsonObject $this$asForgeVersion) {
        Collection<FProfile> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsonElement jsonElement = $this$asForgeVersion.get("version");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"this[\"version\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this[\"version\"].asString");
        JsonElement jsonElement2 = $this$asForgeVersion.get("profiles");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"this[\"profiles\"]");
        JsonArray jsonArray = jsonElement2.getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"this[\"profiles\"].asJsonArray");
        Iterable iterable = (Iterable)jsonArray;
        String string2 = string;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement3 = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            JsonObject jsonObject = v4.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.asJsonObject");
            FProfile fProfile = ImplKt.asForgeProfile(jsonObject);
            collection.add(fProfile);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string3 = string2;
        return new FVersion(string3, list);
    }

    /*
     * WARNING - void declaration
     */
    private static final FProfile asForgeProfile(JsonObject $this$asForgeProfile) {
        Collection<FFeature> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        JsonElement jsonElement = $this$asForgeProfile.get("name");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"this[\"name\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this[\"name\"].asString");
        JsonElement jsonElement2 = $this$asForgeProfile.get("description");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"this[\"description\"]");
        String string2 = jsonElement2.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this[\"description\"].asString");
        JsonElement jsonElement3 = $this$asForgeProfile.get("features");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"this[\"features\"]");
        JsonArray jsonArray = jsonElement3.getAsJsonArray();
        Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"this[\"features\"].asJsonArray");
        Iterable iterable = (Iterable)jsonArray;
        String string3 = string2;
        String string4 = string;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JsonElement jsonElement4 = (JsonElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v6 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"it");
            JsonObject jsonObject = v6.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"it.asJsonObject");
            FFeature fFeature = ImplKt.asForgeFeature(jsonObject);
            collection.add(fFeature);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        String string5 = string3;
        String string6 = string4;
        return new FProfile(string6, string5, list);
    }

    private static final FFeature asForgeFeature(JsonObject $this$asForgeFeature) {
        JsonElement jsonElement = $this$asForgeFeature.get("name");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"this[\"name\"]");
        String string = jsonElement.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this[\"name\"].asString");
        JsonElement jsonElement2 = $this$asForgeFeature.get("description");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"this[\"description\"]");
        String string2 = jsonElement2.getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this[\"description\"].asString");
        JsonElement jsonElement3 = $this$asForgeFeature.get("required");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"this[\"required\"]");
        boolean bl = jsonElement3.getAsBoolean();
        JsonElement jsonElement4 = $this$asForgeFeature.get("defaultFeature");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"this[\"defaultFeature\"]");
        return new FFeature(string, string2, bl, jsonElement4.getAsBoolean());
    }

    public static final void downloadAndExtract(@NotNull String serviceUrl, @NotNull String name, @NotNull String params, @NotNull String where) {
        Intrinsics.checkNotNullParameter((Object)serviceUrl, (String)"serviceUrl");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)where, (String)"where");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        File file = FileUtil.createTempDirectory((String)"grails-application-forge", (String)".tmp", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"FileUtil.createTempDirec\u2026ion-forge\", \".tmp\", true)");
        File tempDir = file;
        File file2 = FileUtil.createTempFile((File)tempDir, (String)name, (String)"downloaded", (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempFile(\u2026\"downloaded\", true, true)");
        File tempFile = file2;
        String downloadUrl = serviceUrl + '/' + name + ".zip?" + params;
        LOG.debug("Starting download: " + downloadUrl);
        HttpRequests.request((String)downloadUrl).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor(tempFile, indicator){
            final /* synthetic */ File $tempFile;
            final /* synthetic */ ProgressIndicator $indicator;

            public final void process(@NotNull HttpRequests.Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                request.saveToFile(this.$tempFile, this.$indicator);
            }
            {
                this.$tempFile = file;
                this.$indicator = progressIndicator;
            }
        });
        LOG.debug("Download completed, extracting to: " + tempDir);
        ProgressIndicator progressIndicator = indicator;
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"indicator");
        progressIndicator.setText(GrailsBundle.message("progress.title.extract.forge.app", new Object[0]));
        ZipUtil.extract((File)tempFile, (File)tempDir, null);
        File destination = new File(where);
        LOG.debug("Extracting completed, copying to: " + destination);
        FileUtil.copyDir((File)new File(tempDir, name), (File)destination);
        LOG.debug("Copying completed, refreshing " + destination);
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)CollectionsKt.listOf((Object)destination), false, true, null);
        LOG.debug("Refreshing completed");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GrailsForgeModuleBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

