/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.editor.toolbar;

import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.actions.ArtefactData;
import org.jetbrains.plugins.grails.editor.toolbar.GrailsToolbarTargetAction;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0002H\u0017J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/grails/editor/toolbar/GrailsGoToArtefactActionBase;", "Lorg/jetbrains/plugins/grails/editor/toolbar/GrailsToolbarTargetAction;", "Lcom/intellij/psi/PsiClass;", "artefactType", "Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "(Lorg/jetbrains/plugins/grails/util/GrailsArtifact;)V", "getArtefactType", "()Lorg/jetbrains/plugins/grails/util/GrailsArtifact;", "getNavigateIcon", "Ljavax/swing/Icon;", "target", "getNavigateTargets", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/typedef/GrClassDefinition;", "artefactData", "Lorg/jetbrains/plugins/grails/actions/ArtefactData;", "getNavigateTitle", "", "getTitle", "navigate", "", "intellij.groovy.grails"})
public abstract class GrailsGoToArtefactActionBase
extends GrailsToolbarTargetAction<PsiClass> {
    @NotNull
    private final GrailsArtifact artefactType;

    @Override
    @NlsSafe
    @NotNull
    public String getTitle(@NotNull ArtefactData artefactData) {
        Intrinsics.checkNotNullParameter((Object)artefactData, (String)"artefactData");
        return StringsKt.capitalize((String)artefactData.getArtefactName()) + this.artefactType.suffix;
    }

    @Override
    @NotNull
    public Collection<GrClassDefinition> getNavigateTargets(@NotNull ArtefactData artefactData) {
        Intrinsics.checkNotNullParameter((Object)artefactData, (String)"artefactData");
        Collection<GrClassDefinition> collection = this.artefactType.getInstances(artefactData.getModule(), artefactData.getPackageName(), artefactData.getArtefactName());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"artefactType.getInstance\u2026factData.artefactName\n  )");
        return collection;
    }

    @Override
    @NlsActions.ActionText
    @NotNull
    public String getNavigateTitle(@NotNull PsiClass target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String string = GrailsBundle.message("action.text.go.to.artefact", target.getName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GrailsBundle.message(\"ac\u2026o.artefact\", target.name)");
        return string;
    }

    @Override
    @Nullable
    public Icon getNavigateIcon(@NotNull PsiClass target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.artefactType.getIcon();
    }

    @Override
    public void navigate(@NotNull ArtefactData artefactData, @NotNull PsiClass target) {
        Intrinsics.checkNotNullParameter((Object)artefactData, (String)"artefactData");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.navigate(true);
    }

    @NotNull
    public final GrailsArtifact getArtefactType() {
        return this.artefactType;
    }

    public GrailsGoToArtefactActionBase(@NotNull GrailsArtifact artefactType) {
        Intrinsics.checkNotNullParameter((Object)((Object)artefactType), (String)"artefactType");
        this.artefactType = artefactType;
    }
}

