/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsPropertiesFileCache;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;
import org.jetbrains.plugins.groovy.mvc.plugins.MvcPluginUtil;

public final class GrailsStructure {
    private final Module myModule;
    private final VirtualFile myAppRoot;
    private final VirtualFile myAppDirectory;
    private final String myGrailsVersion;
    private final PsiManager myManager;
    private GrailsPropertiesFileCache myGrailsPropertiesFileCache;
    private volatile Map<String, VirtualFile> myInstalledPlugins;

    private GrailsStructure(Module module, @NotNull VirtualFile appDirectory, @Nullable String grailsVersion2) {
        if (appDirectory == null) {
            GrailsStructure.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myManager = PsiManager.getInstance((Project)module.getProject());
        this.myAppDirectory = appDirectory;
        this.myAppRoot = this.myAppDirectory.getParent();
        this.myGrailsVersion = grailsVersion2;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            GrailsStructure.$$$reportNull$$$0(1);
        }
        return module;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public Map<String, VirtualFile> getInstalledCommonPlugins() {
        Map<String, VirtualFile> res = this.myInstalledPlugins;
        if (res == null) {
            res = new HashMap<String, VirtualFile>();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                VirtualFile applicationProperties = this.myAppRoot.findChild("application.properties");
                if (applicationProperties != null) {
                    PropertiesFile file = (PropertiesFile)this.myManager.findFile(applicationProperties);
                    assert (file != null);
                    for (Map.Entry<String, String> entry : MvcPluginUtil.getInstalledPluginVersions(file).entrySet()) {
                        res.put(entry.getKey(), null);
                    }
                }
            } else {
                GrailsFramework.getInstance().collectCommonPluginRoots(res, this.myModule, false);
            }
            this.myInstalledPlugins = res;
        }
        return res;
    }

    public boolean isPluginInstalled(String pluginName) {
        return this.getInstalledCommonPlugins().containsKey(pluginName);
    }

    @NotNull
    public VirtualFile getAppRoot() {
        VirtualFile virtualFile = this.myAppRoot;
        if (virtualFile == null) {
            GrailsStructure.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getAppDirectory() {
        VirtualFile virtualFile = this.myAppDirectory;
        if (virtualFile == null) {
            GrailsStructure.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @Nullable(value="Grails version can be unknown, because it's got from name of grails-core.jar")
    public @Nullable(value="Grails version can be unknown, because it's got from name of grails-core.jar") String getGrailsVersion() {
        return this.myGrailsVersion;
    }

    public boolean isAtLeastGrails(@NotNull String version) {
        if (version == null) {
            GrailsStructure.$$$reportNull$$$0(4);
        }
        return this.myGrailsVersion != null && VersionComparatorUtil.compare((String)this.myGrailsVersion, (String)version) >= 0;
    }

    public boolean isVersionLessThan(@NotNull String version) {
        if (version == null) {
            GrailsStructure.$$$reportNull$$$0(5);
        }
        return this.myGrailsVersion != null && VersionComparatorUtil.compare((String)this.myGrailsVersion, (String)version) < 0;
    }

    public static boolean isVersionAtLeast(@NotNull String grailsVersion2, @Nullable Module module) {
        GrailsStructure structure;
        if (grailsVersion2 == null) {
            GrailsStructure.$$$reportNull$$$0(6);
        }
        return (structure = GrailsStructure.getInstance(module)) != null && structure.isAtLeastGrails(grailsVersion2);
    }

    public static boolean isVersionLessThan(@NotNull String grailsVersion2, @NotNull Module module) {
        GrailsStructure grailsStructure;
        if (grailsVersion2 == null) {
            GrailsStructure.$$$reportNull$$$0(7);
        }
        if (module == null) {
            GrailsStructure.$$$reportNull$$$0(8);
        }
        return (grailsStructure = GrailsStructure.getInstance(module)) != null && grailsStructure.isVersionLessThan(grailsVersion2);
    }

    public static boolean isVersionLessThan(@NotNull String grailsVersion2, @NotNull PsiElement element) {
        GrailsStructure instance;
        if (grailsVersion2 == null) {
            GrailsStructure.$$$reportNull$$$0(9);
        }
        if (element == null) {
            GrailsStructure.$$$reportNull$$$0(10);
        }
        return (instance = GrailsStructure.getInstance(element)) != null && instance.isVersionLessThan(grailsVersion2);
    }

    public boolean isAtLeastGrails1_4() {
        return this.isAtLeastGrails("1.4");
    }

    @NotNull
    public String getAppName() {
        String res = this.getGrailsPropertiesFileCache().getAppName();
        String string = res == null ? this.myAppRoot.getName() : res;
        if (string == null) {
            GrailsStructure.$$$reportNull$$$0(11);
        }
        return string;
    }

    GrailsPropertiesFileCache getGrailsPropertiesFileCache() {
        GrailsPropertiesFileCache res = this.myGrailsPropertiesFileCache;
        if (res == null || res.isOutdated()) {
            this.myGrailsPropertiesFileCache = res = new GrailsPropertiesFileCache(this);
        }
        return res;
    }

    @Nullable
    public static GrailsStructure getInstance(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            GrailsStructure.$$$reportNull$$$0(12);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return null;
        }
        return GrailsStructure.getInstance(module);
    }

    public static boolean isAtLeastGrails1_4(@NotNull PsiElement element) {
        GrailsStructure structure;
        if (element == null) {
            GrailsStructure.$$$reportNull$$$0(13);
        }
        if ((structure = GrailsStructure.getInstance(element)) == null) {
            return true;
        }
        return structure.isAtLeastGrails1_4();
    }

    public static boolean isAtLeastGrails1_4(@NotNull Module module) {
        GrailsStructure structure;
        if (module == null) {
            GrailsStructure.$$$reportNull$$$0(14);
        }
        if ((structure = GrailsStructure.getInstance(module)) == null) {
            return true;
        }
        return structure.isAtLeastGrails1_4();
    }

    @Nullable
    public static GrailsStructure getInstance(final @Nullable Module module) {
        if (module == null) {
            return null;
        }
        final Project project = module.getProject();
        return (GrailsStructure)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<GrailsStructure>(){

            @Nullable
            public CachedValueProvider.Result<GrailsStructure> compute() {
                return CachedValueProvider.Result.create((Object)this.doCompute(), (Object[])new Object[]{MvcModuleStructureSynchronizer.getInstance(project).getFileAndRootsModificationTracker(), ProjectRootManager.getInstance((Project)project)});
            }

            private GrailsStructure doCompute() {
                VirtualFile appDirectory = GrailsFramework.getInstance().findAppDirectory(module);
                if (appDirectory != null) {
                    String grailsVersion2 = GrailsConfigUtils.getGrailsVersion(module);
                    return new GrailsStructure(module, appDirectory, grailsVersion2);
                }
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appDirectory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/config/GrailsStructure";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grailsVersion";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeastGrails";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isVersionLessThan";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isVersionAtLeast";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeastGrails1_4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

