/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsSettings;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;

public class GrailsSettingSynchronizer {
    private static final Logger LOG = Logger.getInstance(GrailsSettingSynchronizer.class);
    private static final String PRINT_SCRIPT_NAME = "IdeaPrintProjectSettings.groovy";
    private static final String SCRIPT_DIRECTORY = ".grails/scripts";
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([A-Za-z]+)\\.\\d+");
    private static final Key<Boolean> UPDATING_SETTINGS = Key.create((String)"grails.updating.settings");
    private static final Pattern ARTIFACT_TYPE_PATTERN = Pattern.compile(".+/([^/]+)/(?:sources|javadocs)/\\1-[^/]+-(javadoc|sources)\\.jar\\!/");
    private static final Pattern IVY_JAR_PATTERN = Pattern.compile("(.+)/([^/]+)/jars/\\2-([^/]+)\\.jar\\!/");
    private static final Pattern MAVEN_JAR_PATTERN = Pattern.compile("(.+)/([^/]+)/([^/]+)/\\2-\\3\\.jar\\!/");
    private static final Pattern DIST_PATTERN = Pattern.compile("(.+)/dist/([^/]+)-([^/]+)\\.jar\\!/");
    protected final Module myModule;

    public GrailsSettingSynchronizer(Module module) {
        this.myModule = module;
    }

    public static boolean isUpdateSettingRunning(@NotNull Project project) {
        if (project == null) {
            GrailsSettingSynchronizer.$$$reportNull$$$0(0);
        }
        if (project.getUserData(GrailsFramework.UPDATE_IN_PROGRESS) == Boolean.TRUE) {
            return true;
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (m.getUserData(UPDATING_SETTINGS) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    protected void onDone(boolean isSettingChanged, boolean isExtractingSettingsRan) {
        VirtualFile buildConfigFile;
        if (isSettingChanged && (buildConfigFile = this.getBuildConfigFile()) != null) {
            EditorNotifications.getInstance((Project)this.myModule.getProject()).updateNotifications(buildConfigFile);
        }
    }

    @Nullable
    private String getBuildConfigText() {
        VirtualFile buildConfigFile = this.getBuildConfigFile();
        if (buildConfigFile != null) {
            try {
                return VfsUtilCore.loadText((VirtualFile)buildConfigFile);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    private VirtualFile getBuildConfigFile() {
        VirtualFile appDirectory = GrailsFramework.getInstance().findAppDirectory(this.myModule);
        if (appDirectory != null) {
            return VfsUtil.findRelativeFile((VirtualFile)appDirectory, (String[])new String[]{"conf", "BuildConfig.groovy"});
        }
        return null;
    }

    private void showMessage(@NlsContexts.NotificationContent String message, MessageType type) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        GrailsConsole.getInstance(this.myModule.getProject());
        GrailsConsole.NOTIFICATION_GROUP.createNotification(message, type).notify(this.myModule.getProject());
    }

    private static String readJvmOptions(@NotNull Module module) {
        VirtualFile root;
        if (module == null) {
            GrailsSettingSynchronizer.$$$reportNull$$$0(1);
        }
        if ((root = GrailsUtils.findGrailsAppRoot(module)) == null) {
            return null;
        }
        VirtualFile vmOptionFile = root.findChild("grails-synch-jvm-options.txt");
        if (vmOptionFile == null) {
            return null;
        }
        return LoadTextUtil.loadText((VirtualFile)vmOptionFile).toString().replaceAll("\\s*\\n\\s*", " ").trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean syncGrailsSettings(final boolean isCalledByUser) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            GeneralCommandLine commandLine;
            GrailsSettings settings = GrailsSettingsService.getGrailsSettings(this.myModule);
            String buildConfigText = this.getBuildConfigText();
            int pluginDependenciesCrc = GrailsUtils.getPluginDependenciesCrc(this.myModule);
            if (buildConfigText == null && pluginDependenciesCrc == 0) {
                boolean isChanged;
                if (settings.buildConfigCrc != null && settings.buildConfigCrc == 0 && settings.pluginDependenciesCrc == 0 && settings.properties.isEmpty() && settings.customPluginLocations.isEmpty()) {
                    isChanged = false;
                } else {
                    WriteAction.run(() -> {
                        settings.buildConfigCrc = 0;
                        settings.pluginDependenciesCrc = 0;
                        settings.customPluginLocations.clear();
                        settings.properties.clear();
                    });
                    isChanged = true;
                }
                if (isChanged || isCalledByUser) {
                    this.showMessage(GrailsBundle.message("notification.content.settings.sync.completed", new Object[0]), MessageType.INFO);
                }
                this.onDone(isChanged, false);
                boolean bl = true;
                return bl;
            }
            if (!isCalledByUser && !settings.isBuildConfigOutdated(buildConfigText) && settings.pluginDependenciesCrc == pluginDependenciesCrc) {
                this.onDone(false, false);
                boolean isChanged = true;
                return isChanged;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                boolean isChanged = true;
                return isChanged;
            }
            if (!GrailsSettingSynchronizer.ensureScriptExists(PRINT_SCRIPT_NAME, SCRIPT_DIRECTORY)) {
                boolean isChanged = false;
                return isChanged;
            }
            try {
                OldGrailsApplication application = GrailsApplicationManager.findApplication(this.myModule);
                if (application == null) {
                    throw new ExecutionException(GrailsBundle.message("dialog.message.cannot.find.grails.application.for.module", this.myModule.getName()));
                }
                commandLine = GrailsCommandExecutorUtil.createCommandLine(application, MvcCommand.parse("idea-print-project-settings").setVmOptions(GrailsSettingSynchronizer.readJvmOptions(this.myModule)));
            }
            catch (ExecutionException e) {
                if (isCalledByUser) {
                    Notifications.Bus.notify((Notification)new Notification("grails", GrailsBundle.message("notification.title.failed.to.run.grails.command", new Object[0]), e.getMessage(), NotificationType.ERROR));
                }
                boolean bl = false;
                DaemonCodeAnalyzer.getInstance((Project)this.myModule.getProject()).restart();
                return bl;
            }
            final StringBuilder output2 = new StringBuilder();
            ProcessAdapter listener = new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        output2.append(StringUtil.convertLineSeparators((String)event.getText()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/grails/config/GrailsSettingSynchronizer$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myModule.putUserData(UPDATING_SETTINGS, (Object)true);
            GrailsConsole.getInstance(this.myModule.getProject()).executeProcess(commandLine, new Runnable(){

                @Override
                public void run() {
                    GrailsSettingSynchronizer.this.myModule.getProject().putUserData(GrailsFramework.UPDATE_IN_PROGRESS, (Object)true);
                    GrailsSettingSynchronizer.this.myModule.putUserData(UPDATING_SETTINGS, (Object)false);
                    Ref isChanged = new Ref();
                    if (GrailsSettingSynchronizer.this.processOutput(GrailsSettingSynchronizer.this.myModule, output2.toString(), (Ref<Boolean>)isChanged)) {
                        if (isCalledByUser || ((Boolean)isChanged.get()).booleanValue()) {
                            GrailsSettingSynchronizer.this.showMessage(GrailsBundle.message("notification.content.settings.sync.completed", new Object[0]), MessageType.INFO);
                        }
                        GrailsSettingSynchronizer.this.onDone((Boolean)isChanged.get(), true);
                    } else {
                        GrailsSettingSynchronizer.this.showMessage(GrailsBundle.message("notification.content.settings.sync.failed", new Object[0]), MessageType.ERROR);
                        GrailsConsole.getInstance(GrailsSettingSynchronizer.this.myModule.getProject()).show(null, true);
                    }
                    GrailsSettingSynchronizer.this.myModule.getProject().putUserData(GrailsFramework.UPDATE_IN_PROGRESS, null);
                    DaemonCodeAnalyzer.getInstance((Project)GrailsSettingSynchronizer.this.myModule.getProject()).restart();
                }
            }, isCalledByUser, true, new String[0]).addProcessListener((ProcessListener)listener);
            boolean bl = false;
            return bl;
        }
        finally {
            DaemonCodeAnalyzer.getInstance((Project)this.myModule.getProject()).restart();
        }
    }

    public static boolean ensureScriptExists(@NotNull String name, @NotNull String directory) {
        byte[] bundledScriptContents;
        if (name == null) {
            GrailsSettingSynchronizer.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            GrailsSettingSynchronizer.$$$reportNull$$$0(3);
        }
        try (InputStream inputStream = GrailsSettingSynchronizer.class.getResourceAsStream("/" + name);){
            bundledScriptContents = StreamUtil.readBytes((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path script = Paths.get(SystemProperties.getUserHome(), directory, name);
        if (!GrailsSettingSynchronizer.contentEquals(bundledScriptContents, script)) {
            try {
                Files.write(script, bundledScriptContents, new OpenOption[0]);
            }
            catch (Exception e) {
                Notifications.Bus.notify((Notification)new Notification("grails", GrailsBundle.message("notification.title.grails.setting.synchronization.failed", new Object[0]), GrailsBundle.message("notification.content.failed.to.create.0.see.log.for.more.details", script), NotificationType.ERROR));
                LOG.warn("Failed to create " + script, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private static boolean contentEquals(byte[] expected, Path file) {
        try {
            byte[] actual = Files.readAllBytes(file);
            return Arrays.equals(expected, actual);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static List<VirtualFile> getPomFiles(@NotNull Module module) {
        if (module == null) {
            GrailsSettingSynchronizer.$$$reportNull$$$0(4);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        HashSet dependentModules = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, dependentModules);
        for (Module m : dependentModules) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)m).getContentRoots()) {
                ContainerUtil.addIfNotNull(result2, (Object)root.findChild("pom.xml"));
            }
        }
        return result2;
    }

    private static Set<String> getNonManagedJarNames(Module module) {
        THashSet coreJars = new THashSet();
        for (VirtualFile file : OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
            coreJars.add(VfsUtil.getLocalFile((VirtualFile)file).getName());
        }
        Library defaultLibrary = MvcModuleStructureUtil.findUserLibrary(module, "Grails User Library");
        if (defaultLibrary != null) {
            for (VirtualFile file : defaultLibrary.getFiles(OrderRootType.CLASSES)) {
                coreJars.remove(VfsUtil.getLocalFile((VirtualFile)file).getName());
            }
        }
        return coreJars;
    }

    private boolean processOutput(Module module, String output2, Ref<Boolean> isChanged) {
        if (!GrailsFramework.getInstance().hasSupport(this.myModule)) {
            return false;
        }
        MultiMap deps = new MultiMap();
        HashMap<String, String> properties = new HashMap<String, String>();
        HashMap<String, String> customPluginLocations = new HashMap<String, String>();
        if (!this.parseOutput((MultiMap<String, VirtualFile>)deps, properties, customPluginLocations, output2)) {
            return false;
        }
        List<VirtualFile> dependenciesToPoms = GrailsSettingSynchronizer.getPomFiles(this.myModule);
        HashMap<VirtualFile, byte[]> contentCache = new HashMap<VirtualFile, byte[]>();
        Set<String> nonManagedJarNames = GrailsSettingSynchronizer.getNonManagedJarNames(this.myModule);
        Iterator itr = deps.values().iterator();
        block0: while (itr.hasNext()) {
            String path;
            VirtualFile virtualFile = (VirtualFile)itr.next();
            if (nonManagedJarNames.contains(virtualFile.getName())) {
                itr.remove();
                continue;
            }
            VirtualFile jar = JarFileSystem.getInstance().getVirtualFileForJar(virtualFile);
            if (jar == null || !(path = jar.getPath()).endsWith(".jar")) continue;
            String pomPath = path.substring(0, path.length() - ".jar".length()) + ".pom";
            VirtualFile pom = LocalFileSystem.getInstance().refreshAndFindFileByPath(pomPath);
            if (pom == null) {
                VirtualFile artifactDir;
                VirtualFile jarDir = jar.getParent();
                if (jarDir != null && "jars".equals(jarDir.getName()) && (artifactDir = jarDir.getParent()) != null) {
                    String artifactName = artifactDir.getName();
                    String jarName = jar.getName();
                    if (jarName.startsWith(artifactName) && jarName.length() > artifactName.length() + ".jar".length()) {
                        String version = jarName.substring(artifactName.length(), jarName.length() - ".jar".length());
                        pom = artifactDir.findChild("ivy" + version + ".xml.original");
                    }
                }
                if (pom == null) continue;
            }
            for (VirtualFile dependPom : dependenciesToPoms) {
                if (!GrailsSettingSynchronizer.equalsByContent(pom, dependPom, contentCache)) continue;
                itr.remove();
                continue block0;
            }
        }
        LinkedHashSet compileDeps = new LinkedHashSet(deps.get((Object)"Compile"));
        compileDeps.addAll(deps.get((Object)"Runtime"));
        compileDeps.addAll(deps.get((Object)"Test"));
        compileDeps.addAll(deps.get((Object)"Build"));
        compileDeps.addAll(deps.get((Object)"Provided"));
        GrailsSettings settings = GrailsSettingsService.getGrailsSettings(module);
        String buildConfigText = this.getBuildConfigText();
        isChanged.set((Object)(!properties.equals(settings.properties) || !customPluginLocations.equals(settings.customPluginLocations) ? 1 : 0));
        WriteAction.run(() -> {
            GrailsFramework framework = GrailsFramework.getInstance(module);
            if (framework != null) {
                settings.properties = properties;
                settings.customPluginLocations = customPluginLocations;
                settings.updateBuildConfig(buildConfigText);
                settings.pluginDependenciesCrc = GrailsUtils.getPluginDependenciesCrc(module);
                GrailsSettingSynchronizer.applyDefaultLibraryChanges(module, compileDeps);
            }
        });
        return true;
    }

    private static boolean equalsByContent(VirtualFile file1, VirtualFile file2, Map<VirtualFile, byte[]> contentCache) {
        if (file1.getLength() != file2.getLength()) {
            return false;
        }
        try {
            return Arrays.equals(GrailsSettingSynchronizer.getContent(file1, contentCache), GrailsSettingSynchronizer.getContent(file2, contentCache));
        }
        catch (IOException e) {
            LOG.warn("Failed to read file", (Throwable)e);
            return false;
        }
    }

    private static byte[] getContent(VirtualFile file, Map<VirtualFile, byte[]> contentCache) throws IOException {
        byte[] res = contentCache.get(file);
        if (res == null) {
            res = file.contentsToByteArray();
            contentCache.put(file, res);
        }
        return res;
    }

    private boolean parseOutput(MultiMap<String, VirtualFile> deps, Map<String, String> properties, Map<String, String> customPlugins, String output2) {
        int startIndex = output2.indexOf("---=== IDEA Grails build settings ===---");
        if (startIndex == -1) {
            return false;
        }
        int endIndex = output2.indexOf("---=== End IDEA Grails build settings ===---");
        if (endIndex < startIndex) {
            return false;
        }
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(output2.substring(startIndex + "---=== IDEA Grails build settings ===---".length(), endIndex).getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            return false;
        }
        if (props.isEmpty()) {
            return false;
        }
        VirtualFile appRoot = null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("grails.plugin.location.")) {
                customPlugins.put(key.substring("grails.plugin.location.".length()), value);
                continue;
            }
            Matcher matcher = DEPENDENCY_PATTERN.matcher(key);
            if (matcher.matches()) {
                VirtualFile dependency;
                Object systemIndependentPath = FileUtil.toSystemIndependentName((String)value);
                if (!new File((String)systemIndependentPath).isAbsolute()) {
                    if (appRoot == null) {
                        appRoot = GrailsFramework.getInstance().findAppRoot(this.myModule);
                    }
                    if (appRoot != null) {
                        systemIndependentPath = appRoot.getPath() + "/" + (String)systemIndependentPath;
                    }
                }
                if ((dependency = LocalFileSystem.getInstance().refreshAndFindFileByPath((String)systemIndependentPath)) == null) continue;
                VirtualFile jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(dependency);
                VirtualFile toAdd = jarRoot != null ? jarRoot : dependency;
                deps.putValue((Object)matcher.group(1), (Object)toAdd);
                continue;
            }
            properties.put(key, value);
        }
        return true;
    }

    private static OrderRootType getArtifactType(String url) {
        Matcher matcher = ARTIFACT_TYPE_PATTERN.matcher(url);
        if (!matcher.matches()) {
            return OrderRootType.CLASSES;
        }
        String type = matcher.group(2);
        if (type.equals("sources")) {
            return OrderRootType.SOURCES;
        }
        assert (type.equals("javadoc"));
        return JavadocOrderRootType.getInstance();
    }

    private static void applyDefaultLibraryChanges(Module module, Set<VirtualFile> compileDeps) {
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        Library.ModifiableModel modifiableModel = MvcModuleStructureUtil.modifyDefaultLibrary(model, "Grails User Library");
        HashSet<VirtualFile> exists = new HashSet<VirtualFile>();
        for (VirtualFile file : modifiableModel.getFiles(OrderRootType.CLASSES)) {
            if (!compileDeps.contains(file) || OrderRootType.CLASSES != GrailsSettingSynchronizer.getArtifactType(file.getUrl())) {
                modifiableModel.removeRoot(file.getUrl(), OrderRootType.CLASSES);
                continue;
            }
            exists.add(file);
        }
        for (VirtualFile file : modifiableModel.getFiles(OrderRootType.SOURCES)) {
            if (!compileDeps.contains(file) && OrderRootType.SOURCES == GrailsSettingSynchronizer.getArtifactType(file.getUrl())) {
                modifiableModel.removeRoot(file.getUrl(), OrderRootType.SOURCES);
                continue;
            }
            exists.add(file);
        }
        OrderRootType javadocType = JavadocOrderRootType.getInstance();
        for (VirtualFile file : modifiableModel.getFiles(javadocType)) {
            if (!compileDeps.contains(file) && javadocType == GrailsSettingSynchronizer.getArtifactType(file.getUrl())) {
                modifiableModel.removeRoot(file.getUrl(), javadocType);
                continue;
            }
            exists.add(file);
        }
        for (VirtualFile compileDep : compileDeps) {
            VirtualFile javadoc;
            VirtualFile sources;
            String version;
            String path;
            OrderRootType type = GrailsSettingSynchronizer.getArtifactType(compileDep.getUrl());
            if (!exists.contains(compileDep)) {
                modifiableModel.addRoot(compileDep, type);
            }
            if (type != OrderRootType.CLASSES) continue;
            String jarPath = compileDep.getPath();
            Matcher matcher = IVY_JAR_PATTERN.matcher(jarPath);
            if (matcher.matches()) {
                VirtualFile javadoc2;
                String home;
                path = matcher.group(1);
                String name = matcher.group(2);
                version = matcher.group(3);
                sources = JarFileSystem.getInstance().findFileByPath(path + "/" + name + "/sources/" + name + "-" + version + "-sources.jar!/");
                if (sources != null && !exists.contains(sources)) {
                    modifiableModel.addRoot(sources, OrderRootType.SOURCES);
                    exists.add(sources);
                }
                if (!StringUtil.isEmpty((String)(home = PathUtil.getParentPath((String)PathUtil.getParentPath((String)path)))) && (sources = JarFileSystem.getInstance().findFileByPath(home + "/src/" + name + "-" + version + "-sources.jar!/")) != null && !exists.contains(sources)) {
                    modifiableModel.addRoot(sources, OrderRootType.SOURCES);
                    exists.add(sources);
                }
                if ((javadoc2 = JarFileSystem.getInstance().findFileByPath(path + "/" + name + "/javadocs/" + name + "-" + version + "-javadoc.jar!/")) == null || exists.contains(javadoc2)) continue;
                modifiableModel.addRoot(javadoc2, javadocType);
                exists.add(sources);
                continue;
            }
            matcher = MAVEN_JAR_PATTERN.matcher(jarPath);
            if (matcher.matches()) {
                VirtualFile javadoc3;
                path = matcher.group(1);
                String artifactId = matcher.group(2);
                version = matcher.group(3);
                sources = JarFileSystem.getInstance().findFileByPath(path + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "-sources.jar!/");
                if (sources != null && !exists.contains(sources)) {
                    modifiableModel.addRoot(sources, OrderRootType.SOURCES);
                    exists.add(sources);
                }
                if ((javadoc3 = JarFileSystem.getInstance().findFileByPath(path + "/" + artifactId + "/" + version + "/" + artifactId + "-" + version + "-javadoc.jar!/")) == null || exists.contains(javadoc3)) continue;
                modifiableModel.addRoot(javadoc3, javadocType);
                exists.add(sources);
                continue;
            }
            matcher = DIST_PATTERN.matcher(jarPath);
            if (!matcher.matches()) continue;
            VirtualFile sources2 = JarFileSystem.getInstance().findFileByPath(jarPath.replace(".jar!/", "-sources.jar!/"));
            if (sources2 != null && exists.add(sources2)) {
                modifiableModel.addRoot(sources2, OrderRootType.SOURCES);
            }
            if ((javadoc = JarFileSystem.getInstance().findFileByPath(jarPath.replace(".jar!/", "-javadoc.jar!/"))) == null || !exists.contains(javadoc)) continue;
            modifiableModel.addRoot(javadoc, javadocType);
        }
        if (modifiableModel.isChanged()) {
            modifiableModel.commit();
            model.commit();
        } else {
            Disposer.dispose((Disposable)modifiableModel);
            model.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsSettingSynchronizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpdateSettingRunning";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readJvmOptions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureScriptExists";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPomFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

